% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tensor-baseline-power.R
\name{collapse2}
\alias{collapse2}
\alias{collapse2.FileArray}
\alias{collapse2.Tensor}
\alias{collapse2.array}
\title{Collapse high-dimensional tensor array}
\usage{
collapse2(x, keep, method = c("mean", "sum"), ...)

\method{collapse2}{FileArray}(x, keep, method = c("mean", "sum"), ...)

\method{collapse2}{Tensor}(x, keep, method = c("mean", "sum"), ...)

\method{collapse2}{array}(x, keep, method = c("mean", "sum"), ...)
}
\arguments{
\item{x}{R array, \code{\link[filearray]{FileArray-class}}, or
\code{\link{Tensor}} object}

\item{keep}{integer vector, the margins to keep}

\item{method}{character, calculates mean or sum of the array when collapsing}

\item{...}{passed to other methods}
}
\value{
A collapsed array (or a vector or matrix), depending on \code{keep}
}
\description{
Collapse high-dimensional tensor array
}
\examples{

x <- array(1:16, rep(2, 4))

collapse2(x, c(3, 2))

# Alternative method, but slower when `x` is a large array
apply(x, c(3, 2), mean)

}
\seealso{
\code{\link[dipsaus]{collapse}}
}
