% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_traces.R
\name{get_traces}
\alias{get_traces}
\title{Get the parameter traces}
\usage{
get_traces(x, model, burnin, all = FALSE, ...)
}
\arguments{
\item{x}{a \code{\link{libbi}} object which has been run, or a
list of data frames containing parameter traces (as returned by
\code{bi_read}); if it is not a \code{\link{libbi}}
object, either 'all' must be TRUE or a model given}

\item{model}{a model to get the parameter names from; not needed if
'run' is given as a \code{\link{libbi}} object or 'all' is set
to TRUE}

\item{burnin}{proportion of iterations to discard as burn-in (if between 0 and 1), or number of samples to discard (if >1)}

\item{all}{whether all variables in the run file should be
considered (otherwise, just parameters)}

\item{...}{parameters to \code{bi_read} (e.g., dimensions)}
}
\value{
data frame with parameter traces; this can be fed to
    \code{coda} routines
}
\description{
This function takes the provided \code{\link{libbi}} object
    which has been run and returns a data frame with the parameter
    traces.
}
