% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/libbi.R
\name{attach_file}
\alias{attach_file}
\alias{attach_file.libbi}
\title{Attach a new file to a \code{\link{libbi}} object}
\usage{
\method{attach_file}{libbi}(x, file, data, force = FALSE, ...)
}
\arguments{
\item{x}{a \code{\link{libbi}} object}

\item{file}{file to open (out of "input", "init", "obs", "output"), if \code{x} is given as a \code{libbi} object; by default, will read output file}

\item{data}{name of the file to attach, or a list of data frames that contain the outputs}

\item{force}{attach the file even if one like this already exists in the libbi object}

\item{...}{ignored}
}
\description{
Adds an (output, obs, etc.) file to a \code{\link{libbi}} object. This is useful to recreate a \code{\link{libbi}} object from the model and output files of a previous run
}
\examples{
bi <- libbi(model = system.file(package="rbi", "PZ.bi"))
example_output_file <- system.file(package="rbi", "example_output.nc")
bi <- attach_file(bi, "output", example_output_file)
}
