// Generated by rstantools.  Do not edit by hand.

/*
    rbioacc is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    rbioacc is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with rbioacc.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.26.1-4-gd72b68b7-dirty
#include <stan/model/model_header.hpp>
namespace model_TK_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'TK', line 140, column 2 to column 25)",
                                                      " (in 'TK', line 141, column 2 to column 25)",
                                                      " (in 'TK', line 142, column 2 to column 25)",
                                                      " (in 'TK', line 143, column 2 to column 26)",
                                                      " (in 'TK', line 144, column 2 to column 42)",
                                                      " (in 'TK', line 145, column 2 to column 40)",
                                                      " (in 'TK', line 146, column 2 to column 39)",
                                                      " (in 'TK', line 147, column 2 to column 35)",
                                                      " (in 'TK', line 151, column 2 to column 29)",
                                                      " (in 'TK', line 152, column 2 to column 29)",
                                                      " (in 'TK', line 153, column 2 to column 29)",
                                                      " (in 'TK', line 154, column 2 to column 30)",
                                                      " (in 'TK', line 155, column 2 to column 19)",
                                                      " (in 'TK', line 156, column 2 to column 10)",
                                                      " (in 'TK', line 157, column 2 to column 10)",
                                                      " (in 'TK', line 158, column 2 to column 19)",
                                                      " (in 'TK', line 159, column 2 to column 19)",
                                                      " (in 'TK', line 161, column 2 to column 30)",
                                                      " (in 'TK', line 162, column 2 to column 32)",
                                                      " (in 'TK', line 164, column 4 to column 29)",
                                                      " (in 'TK', line 163, column 19 to line 165, column 3)",
                                                      " (in 'TK', line 163, column 2 to line 165, column 3)",
                                                      " (in 'TK', line 170, column 6 to column 31)",
                                                      " (in 'TK', line 169, column 10 to line 171, column 5)",
                                                      " (in 'TK', line 168, column 7 to column 18)",
                                                      " (in 'TK', line 167, column 26 to line 169, column 5)",
                                                      " (in 'TK', line 167, column 4 to line 171, column 5)",
                                                      " (in 'TK', line 166, column 19 to line 172, column 3)",
                                                      " (in 'TK', line 166, column 2 to line 172, column 3)",
                                                      " (in 'TK', line 174, column 4 to column 29)",
                                                      " (in 'TK', line 175, column 4 to column 31)",
                                                      " (in 'TK', line 173, column 19 to line 176, column 3)",
                                                      " (in 'TK', line 173, column 2 to line 176, column 3)",
                                                      " (in 'TK', line 180, column 5 to column 18)",
                                                      " (in 'TK', line 179, column 8 to line 181, column 3)",
                                                      " (in 'TK', line 178, column 4 to column 11)",
                                                      " (in 'TK', line 177, column 16 to line 179, column 3)",
                                                      " (in 'TK', line 177, column 2 to line 181, column 3)",
                                                      " (in 'TK', line 185, column 4 to column 17)",
                                                      " (in 'TK', line 184, column 8 to line 186, column 3)",
                                                      " (in 'TK', line 183, column 4 to column 19)",
                                                      " (in 'TK', line 182, column 24 to line 184, column 3)",
                                                      " (in 'TK', line 182, column 2 to line 186, column 3)",
                                                      " (in 'TK', line 189, column 4 to column 33)",
                                                      " (in 'TK', line 190, column 4 to column 27)",
                                                      " (in 'TK', line 187, column 19 to line 191, column 3)",
                                                      " (in 'TK', line 187, column 2 to line 191, column 3)",
                                                      " (in 'TK', line 193, column 6 to column 31)",
                                                      " (in 'TK', line 192, column 19 to line 194, column 3)",
                                                      " (in 'TK', line 192, column 2 to line 194, column 3)",
                                                      " (in 'TK', line 198, column 4 to column 63)",
                                                      " (in 'TK', line 202, column 9 to line 204, column 12)",
                                                      " (in 'TK', line 201, column 23 to line 205, column 7)",
                                                      " (in 'TK', line 201, column 6 to line 205, column 7)",
                                                      " (in 'TK', line 200, column 17 to line 206, column 5)",
                                                      " (in 'TK', line 200, column 4 to line 206, column 5)",
                                                      " (in 'TK', line 196, column 21 to line 207, column 3)",
                                                      " (in 'TK', line 196, column 2 to line 207, column 3)",
                                                      " (in 'TK', line 211, column 4 to column 82)",
                                                      " (in 'TK', line 215, column 6 to line 219, column 11)",
                                                      " (in 'TK', line 214, column 23 to line 220, column 7)",
                                                      " (in 'TK', line 214, column 6 to line 220, column 7)",
                                                      " (in 'TK', line 213, column 17 to line 221, column 5)",
                                                      " (in 'TK', line 213, column 4 to line 221, column 5)",
                                                      " (in 'TK', line 209, column 29 to line 222, column 3)",
                                                      " (in 'TK', line 209, column 2 to line 222, column 3)",
                                                      " (in 'TK', line 226, column 6 to column 72)",
                                                      " (in 'TK', line 225, column 21 to line 227, column 5)",
                                                      " (in 'TK', line 225, column 4 to line 227, column 5)",
                                                      " (in 'TK', line 224, column 16 to line 228, column 3)",
                                                      " (in 'TK', line 224, column 2 to line 228, column 3)",
                                                      " (in 'TK', line 281, column 2 to column 36)",
                                                      " (in 'TK', line 282, column 2 to column 35)",
                                                      " (in 'TK', line 283, column 2 to column 42)",
                                                      " (in 'TK', line 287, column 4 to column 62)",
                                                      " (in 'TK', line 290, column 6 to column 67)",
                                                      " (in 'TK', line 289, column 21 to line 291, column 5)",
                                                      " (in 'TK', line 289, column 4 to line 291, column 5)",
                                                      " (in 'TK', line 285, column 19 to line 292, column 3)",
                                                      " (in 'TK', line 285, column 2 to line 292, column 3)",
                                                      " (in 'TK', line 295, column 6 to column 64)",
                                                      " (in 'TK', line 294, column 21 to line 296, column 5)",
                                                      " (in 'TK', line 294, column 4 to line 296, column 5)",
                                                      " (in 'TK', line 293, column 16 to line 297, column 3)",
                                                      " (in 'TK', line 293, column 2 to line 297, column 3)",
                                                      " (in 'TK', line 301, column 6 to column 69)",
                                                      " (in 'TK', line 300, column 22 to line 302, column 5)",
                                                      " (in 'TK', line 300, column 4 to line 302, column 5)",
                                                      " (in 'TK', line 298, column 19 to line 303, column 3)",
                                                      " (in 'TK', line 298, column 2 to line 303, column 3)",
                                                      " (in 'TK', line 232, column 2 to column 43)",
                                                      " (in 'TK', line 233, column 2 to column 43)",
                                                      " (in 'TK', line 234, column 2 to column 43)",
                                                      " (in 'TK', line 235, column 2 to column 44)",
                                                      " (in 'TK', line 236, column 2 to column 55)",
                                                      " (in 'TK', line 237, column 2 to column 54)",
                                                      " (in 'TK', line 239, column 5 to column 58)",
                                                      " (in 'TK', line 240, column 5 to column 59)",
                                                      " (in 'TK', line 241, column 5 to column 49)",
                                                      " (in 'TK', line 238, column 16 to line 242, column 3)",
                                                      " (in 'TK', line 238, column 2 to line 242, column 3)",
                                                      " (in 'TK', line 248, column 8 to column 78)",
                                                      " (in 'TK', line 247, column 33 to line 249, column 7)",
                                                      " (in 'TK', line 247, column 6 to line 249, column 7)",
                                                      " (in 'TK', line 253, column 10 to column 83)",
                                                      " (in 'TK', line 252, column 34 to line 254, column 9)",
                                                      " (in 'TK', line 252, column 8 to line 254, column 9)",
                                                      " (in 'TK', line 251, column 23 to line 255, column 7)",
                                                      " (in 'TK', line 251, column 6 to line 255, column 7)",
                                                      " (in 'TK', line 245, column 23 to line 256, column 5)",
                                                      " (in 'TK', line 245, column 4 to line 256, column 5)",
                                                      " (in 'TK', line 261, column 8 to column 78)",
                                                      " (in 'TK', line 260, column 33 to line 262, column 7)",
                                                      " (in 'TK', line 260, column 6 to line 262, column 7)",
                                                      " (in 'TK', line 266, column 10 to column 82)",
                                                      " (in 'TK', line 265, column 34 to line 267, column 9)",
                                                      " (in 'TK', line 265, column 8 to line 267, column 9)",
                                                      " (in 'TK', line 264, column 23 to line 268, column 7)",
                                                      " (in 'TK', line 264, column 6 to line 268, column 7)",
                                                      " (in 'TK', line 258, column 31 to line 269, column 5)",
                                                      " (in 'TK', line 258, column 4 to line 269, column 5)",
                                                      " (in 'TK', line 274, column 10 to column 79)",
                                                      " (in 'TK', line 273, column 35 to line 275, column 9)",
                                                      " (in 'TK', line 273, column 8 to line 275, column 9)",
                                                      " (in 'TK', line 272, column 23 to line 276, column 7)",
                                                      " (in 'TK', line 272, column 6 to line 276, column 7)",
                                                      " (in 'TK', line 271, column 18 to line 277, column 5)",
                                                      " (in 'TK', line 271, column 4 to line 277, column 5)",
                                                      " (in 'TK', line 243, column 21 to line 278, column 3)",
                                                      " (in 'TK', line 243, column 2 to line 278, column 3)",
                                                      " (in 'TK', line 115, column 2 to column 22)",
                                                      " (in 'TK', line 117, column 2 to column 21)",
                                                      " (in 'TK', line 118, column 9 to column 14)",
                                                      " (in 'TK', line 118, column 2 to column 20)",
                                                      " (in 'TK', line 120, column 2 to column 22)",
                                                      " (in 'TK', line 121, column 9 to column 14)",
                                                      " (in 'TK', line 121, column 16 to column 21)",
                                                      " (in 'TK', line 121, column 2 to column 29)",
                                                      " (in 'TK', line 124, column 2 to column 22)",
                                                      " (in 'TK', line 125, column 8 to column 13)",
                                                      " (in 'TK', line 125, column 15 to column 20)",
                                                      " (in 'TK', line 125, column 22 to column 27)",
                                                      " (in 'TK', line 125, column 2 to column 40)",
                                                      " (in 'TK', line 127, column 2 to column 22)",
                                                      " (in 'TK', line 128, column 8 to column 13)",
                                                      " (in 'TK', line 128, column 15 to column 20)",
                                                      " (in 'TK', line 128, column 22 to column 27)",
                                                      " (in 'TK', line 128, column 2 to column 40)",
                                                      " (in 'TK', line 129, column 2 to column 25)",
                                                      " (in 'TK', line 131, column 2 to column 24)",
                                                      " (in 'TK', line 132, column 2 to column 22)",
                                                      " (in 'TK', line 133, column 2 to column 20)",
                                                      " (in 'TK', line 134, column 2 to column 18)",
                                                      " (in 'TK', line 135, column 2 to column 16)",
                                                      " (in 'TK', line 136, column 2 to column 22)",
                                                      " (in 'TK', line 137, column 9 to column 15)",
                                                      " (in 'TK', line 137, column 2 to column 21)",
                                                      " (in 'TK', line 140, column 9 to column 14)",
                                                      " (in 'TK', line 141, column 9 to column 14)",
                                                      " (in 'TK', line 142, column 9 to column 14)",
                                                      " (in 'TK', line 143, column 9 to column 14)",
                                                      " (in 'TK', line 144, column 8 to column 13)",
                                                      " (in 'TK', line 145, column 18 to column 23)",
                                                      " (in 'TK', line 146, column 8 to column 17)",
                                                      " (in 'TK', line 147, column 8 to column 16)",
                                                      " (in 'TK', line 151, column 18 to column 23)",
                                                      " (in 'TK', line 152, column 18 to column 23)",
                                                      " (in 'TK', line 153, column 18 to column 23)",
                                                      " (in 'TK', line 154, column 18 to column 23)",
                                                      " (in 'TK', line 155, column 9 to column 14)",
                                                      " (in 'TK', line 158, column 9 to column 14)",
                                                      " (in 'TK', line 159, column 9 to column 14)",
                                                      " (in 'TK', line 161, column 9 to column 14)",
                                                      " (in 'TK', line 161, column 15 to column 20)",
                                                      " (in 'TK', line 162, column 9 to column 14)",
                                                      " (in 'TK', line 162, column 15 to column 20)",
                                                      " (in 'TK', line 281, column 8 to column 13)",
                                                      " (in 'TK', line 281, column 14 to column 19)",
                                                      " (in 'TK', line 282, column 8 to column 13)",
                                                      " (in 'TK', line 282, column 14 to column 19)",
                                                      " (in 'TK', line 283, column 8 to column 14)",
                                                      " (in 'TK', line 283, column 16 to column 21)",
                                                      " (in 'TK', line 4, column 2 to column 13)",
                                                      " (in 'TK', line 12, column 6 to column 15)",
                                                      " (in 'TK', line 11, column 24 to line 13, column 5)",
                                                      " (in 'TK', line 11, column 4 to line 13, column 5)",
                                                      " (in 'TK', line 14, column 4 to column 14)",
                                                      " (in 'TK', line 10, column 9 to line 15, column 3)",
                                                      " (in 'TK', line 9, column 4 to column 14)",
                                                      " (in 'TK', line 8, column 39 to line 10, column 3)",
                                                      " (in 'TK', line 8, column 9 to line 15, column 3)",
                                                      " (in 'TK', line 6, column 4 to column 30)",
                                                      " (in 'TK', line 7, column 4 to column 14)",
                                                      " (in 'TK', line 5, column 18 to line 8, column 3)",
                                                      " (in 'TK', line 5, column 2 to line 15, column 3)",
                                                      " (in 'TK', line 3, column 33 to line 16, column 1)",
                                                      " (in 'TK', line 22, column 4 to column 16)",
                                                      " (in 'TK', line 21, column 8 to line 23, column 3)",
                                                      " (in 'TK', line 19, column 4 to column 33)",
                                                      " (in 'TK', line 20, column 4 to column 90)",
                                                      " (in 'TK', line 18, column 36 to line 21, column 3)",
                                                      " (in 'TK', line 18, column 2 to line 23, column 3)",
                                                      " (in 'TK', line 17, column 48 to line 24, column 1)",
                                                      " (in 'TK', line 32, column 2 to column 27)",
                                                      " (in 'TK', line 33, column 2 to column 22)",
                                                      " (in 'TK', line 34, column 2 to column 22)",
                                                      " (in 'TK', line 35, column 2 to column 22)",
                                                      " (in 'TK', line 36, column 2 to column 22)",
                                                      " (in 'TK', line 37, column 8 to column 13)",
                                                      " (in 'TK', line 37, column 2 to column 41)",
                                                      " (in 'TK', line 38, column 8 to column 13)",
                                                      " (in 'TK', line 38, column 2 to column 57)",
                                                      " (in 'TK', line 39, column 8 to column 13)",
                                                      " (in 'TK', line 39, column 2 to column 69)",
                                                      " (in 'TK', line 40, column 8 to column 13)",
                                                      " (in 'TK', line 40, column 2 to column 82)",
                                                      " (in 'TK', line 42, column 8 to column 15)",
                                                      " (in 'TK', line 42, column 2 to column 28)",
                                                      " (in 'TK', line 43, column 2 to column 22)",
                                                      " (in 'TK', line 45, column 9 to column 19)",
                                                      " (in 'TK', line 45, column 2 to column 65)",
                                                      " (in 'TK', line 48, column 9 to column 19)",
                                                      " (in 'TK', line 48, column 2 to column 91)",
                                                      " (in 'TK', line 50, column 2 to column 10)",
                                                      " (in 'TK', line 51, column 2 to column 10)",
                                                      " (in 'TK', line 52, column 2 to column 10)",
                                                      " (in 'TK', line 56, column 4 to column 17)",
                                                      " (in 'TK', line 55, column 8 to line 57, column 3)",
                                                      " (in 'TK', line 54, column 4 to column 11)",
                                                      " (in 'TK', line 53, column 16 to line 55, column 3)",
                                                      " (in 'TK', line 53, column 2 to line 57, column 3)",
                                                      " (in 'TK', line 58, column 2 to column 15)",
                                                      " (in 'TK', line 61, column 2 to column 50)",
                                                      " (in 'TK', line 72, column 4 to column 32)",
                                                      " (in 'TK', line 70, column 8 to line 73, column 3)",
                                                      " (in 'TK', line 69, column 4 to column 34)",
                                                      " (in 'TK', line 67, column 15 to line 70, column 3)",
                                                      " (in 'TK', line 67, column 2 to line 73, column 3)",
                                                      " (in 'TK', line 76, column 6 to column 46)",
                                                      " (in 'TK', line 75, column 25 to line 77, column 5)",
                                                      " (in 'TK', line 75, column 4 to line 77, column 5)",
                                                      " (in 'TK', line 74, column 15 to line 78, column 3)",
                                                      " (in 'TK', line 74, column 2 to line 78, column 3)",
                                                      " (in 'TK', line 79, column 2 to column 16)",
                                                      " (in 'TK', line 30, column 30 to line 80, column 1)"};
template <typename T0__, typename T1__>
int
findfirst(const T0__& t, const T1__& xt_arg__, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__,
          stan::value_type_t<T1__>>;
  const auto& xt = to_ref(xt_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    int i;
    i = std::numeric_limits<int>::min();
    
    current_statement__ = 183;
    i = 0;
    current_statement__ = 195;
    if (logical_eq(t, max(xt))) {
      current_statement__ = 192;
      i = (num_elements(xt) - 1);
      current_statement__ = 193;
      return i;
    } else {
      current_statement__ = 191;
      if ((primitive_value(logical_lt(t, min(xt))) || primitive_value(
          logical_gt(t, max(xt))))) {
        current_statement__ = 189;
        return i;
      } else {
        current_statement__ = 186;
        while (logical_gte(t, xt[((i + 1) - 1)])) {
          current_statement__ = 184;
          i = (i + 1);
        }
        current_statement__ = 187;
        return i;
      }
    }
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct findfirst_functor__ {
template <typename T0__, typename T1__>
int
operator()(const T0__& t, const T1__& xt, std::ostream* pstream__)  const 
{
return findfirst(t, xt, pstream__);
}
};
template <typename T0__, typename T1__, typename T2__>
stan::promote_args_t<T0__, stan::value_type_t<T1__>,
stan::value_type_t<T2__>>
interpolate(const T0__& x, const T1__& xpt_arg__, const T2__& ypt_arg__,
            std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__,
          stan::value_type_t<T1__>,
          stan::value_type_t<T2__>>;
  const auto& xpt = to_ref(xpt_arg__);
  const auto& ypt = to_ref(ypt_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 202;
    if ((primitive_value(logical_gte(x, min(xpt))) && primitive_value(
        logical_lte(x, max(xpt))))) {
      int idx;
      idx = std::numeric_limits<int>::min();
      
      current_statement__ = 199;
      idx = findfirst(x, xpt, pstream__);
      current_statement__ = 200;
      return (ypt[(idx - 1)] +
               (((x - xpt[(idx - 1)]) *
                  (ypt[((idx + 1) - 1)] - ypt[(idx - 1)])) /
                 (xpt[((idx + 1) - 1)] - xpt[(idx - 1)])));
    } else {
      current_statement__ = 197;
      return 0.0;
    }
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct interpolate_functor__ {
template <typename T0__, typename T1__, typename T2__>
stan::promote_args_t<T0__, stan::value_type_t<T1__>,
stan::value_type_t<T2__>>
operator()(const T0__& x, const T1__& xpt, const T2__& ypt,
           std::ostream* pstream__)  const 
{
return interpolate(x, xpt, ypt, pstream__);
}
};
template <typename T0__, typename T1__, typename T2__, typename T3__>
std::vector<stan::promote_args_t<T0__, T1__, T2__,
T3__>>
odeTK(const T0__& t, const std::vector<T1__>& y,
      const std::vector<T2__>& theta, const std::vector<T3__>& x_r,
      const std::vector<int>& x_i, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__, T1__, T2__, T3__>;
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    int lentp_rmNA;
    lentp_rmNA = std::numeric_limits<int>::min();
    
    current_statement__ = 204;
    lentp_rmNA = x_i[(1 - 1)];
    int lentp;
    lentp = std::numeric_limits<int>::min();
    
    current_statement__ = 205;
    lentp = x_i[(2 - 1)];
    int n_exp;
    n_exp = std::numeric_limits<int>::min();
    
    current_statement__ = 206;
    n_exp = x_i[(3 - 1)];
    int n_out;
    n_out = std::numeric_limits<int>::min();
    
    current_statement__ = 207;
    n_out = x_i[(4 - 1)];
    int n_met;
    n_met = std::numeric_limits<int>::min();
    
    current_statement__ = 208;
    n_met = x_i[(5 - 1)];
    current_statement__ = 209;
    validate_non_negative_index("ku", "n_exp", n_exp);
    std::vector<local_scalar_t__> ku;
    ku = std::vector<local_scalar_t__>(n_exp, DUMMY_VAR__);
    
    current_statement__ = 210;
    assign(ku, nil_index_list(),
      rvalue(theta, cons_list(index_min_max(1, n_exp), nil_index_list()),
        "theta"), "assigning variable ku");
    current_statement__ = 211;
    validate_non_negative_index("ke", "n_out", n_out);
    std::vector<local_scalar_t__> ke;
    ke = std::vector<local_scalar_t__>(n_out, DUMMY_VAR__);
    
    current_statement__ = 212;
    assign(ke, nil_index_list(),
      rvalue(theta,
        cons_list(index_min_max((n_exp + 1), (n_exp + n_out)),
          nil_index_list()), "theta"), "assigning variable ke");
    current_statement__ = 213;
    validate_non_negative_index("km", "n_met", n_met);
    std::vector<local_scalar_t__> km;
    km = std::vector<local_scalar_t__>(n_met, DUMMY_VAR__);
    
    current_statement__ = 214;
    assign(km, nil_index_list(),
      rvalue(theta,
        cons_list(
          index_min_max(((n_exp + n_out) + 1), ((n_exp + n_out) + n_met)),
          nil_index_list()), "theta"), "assigning variable km");
    current_statement__ = 215;
    validate_non_negative_index("kem", "n_met", n_met);
    std::vector<local_scalar_t__> kem;
    kem = std::vector<local_scalar_t__>(n_met, DUMMY_VAR__);
    
    current_statement__ = 216;
    assign(kem, nil_index_list(),
      rvalue(theta,
        cons_list(
          index_min_max((((n_exp + n_out) + n_met) + 1), (((n_exp + n_out) +
                                                            n_met) + n_met)),
          nil_index_list()), "theta"), "assigning variable kem");
    current_statement__ = 217;
    validate_non_negative_index("dydt", "1 + n_met", (1 + n_met));
    std::vector<local_scalar_t__> dydt;
    dydt = std::vector<local_scalar_t__>((1 + n_met), DUMMY_VAR__);
    
    local_scalar_t__ tacc;
    tacc = DUMMY_VAR__;
    
    current_statement__ = 219;
    tacc = x_r[(1 - 1)];
    current_statement__ = 220;
    validate_non_negative_index("tp_rmNA", "lentp_rmNA", lentp_rmNA);
    Eigen::Matrix<local_scalar_t__, -1, 1> tp_rmNA;
    tp_rmNA = Eigen::Matrix<local_scalar_t__, -1, 1>(lentp_rmNA);
    stan::math::fill(tp_rmNA, DUMMY_VAR__);
    
    current_statement__ = 221;
    assign(tp_rmNA, nil_index_list(),
      to_vector(
        rvalue(x_r,
          cons_list(index_min_max(2, (lentp_rmNA + 1)), nil_index_list()),
          "x_r")), "assigning variable tp_rmNA");
    current_statement__ = 222;
    validate_non_negative_index("Cexp_rmNA", "lentp_rmNA", lentp_rmNA);
    Eigen::Matrix<local_scalar_t__, -1, 1> Cexp_rmNA;
    Cexp_rmNA = Eigen::Matrix<local_scalar_t__, -1, 1>(lentp_rmNA);
    stan::math::fill(Cexp_rmNA, DUMMY_VAR__);
    
    current_statement__ = 223;
    assign(Cexp_rmNA, nil_index_list(),
      to_vector(
        rvalue(x_r,
          cons_list(
            index_min_max((lentp_rmNA + 2), ((lentp_rmNA + 1) + lentp_rmNA)),
            nil_index_list()), "x_r")), "assigning variable Cexp_rmNA");
    local_scalar_t__ U;
    U = DUMMY_VAR__;
    
    local_scalar_t__ M;
    M = DUMMY_VAR__;
    
    local_scalar_t__ E;
    E = DUMMY_VAR__;
    
    current_statement__ = 231;
    if (logical_eq(n_met, 0)) {
      current_statement__ = 229;
      M = 0;
    } else {
      current_statement__ = 227;
      M = sum(km);
    }
    current_statement__ = 232;
    E = sum(ke);
    current_statement__ = 233;
    U = (ku[(1 - 1)] * interpolate(t, tp_rmNA, Cexp_rmNA, pstream__));
    current_statement__ = 238;
    if (logical_lte(t, tacc)) {
      current_statement__ = 236;
      assign(dydt, cons_list(index_uni(1), nil_index_list()),
        (U - ((E + M) * y[(1 - 1)])), "assigning variable dydt");
    } else {
      current_statement__ = 234;
      assign(dydt, cons_list(index_uni(1), nil_index_list()),
        (-(E + M) * y[(1 - 1)]), "assigning variable dydt");
    }
    current_statement__ = 243;
    if (logical_gt(n_met, 0)) {
      current_statement__ = 241;
      for (int i = 2; i <= (n_met + 1); ++i) {
        current_statement__ = 239;
        assign(dydt, cons_list(index_uni(i), nil_index_list()),
          ((km[(i - 1)] * y[(1 - 1)]) - (kem[(i - 1)] * y[(i - 1)])),
          "assigning variable dydt");}
    } 
    current_statement__ = 244;
    return dydt;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct odeTK_functor__ {
template <typename T0__, typename T1__, typename T2__, typename T3__>
std::vector<stan::promote_args_t<T0__, T1__, T2__,
T3__>>
operator()(const T0__& t, const std::vector<T1__>& y,
           const std::vector<T2__>& theta, const std::vector<T3__>& x_r,
           const std::vector<int>& x_i, std::ostream* pstream__)  const 
{
return odeTK(t, y, theta, x_r, x_i, pstream__);
}
};
#include <stan_meta_header.hpp>
class model_TK final : public model_base_crtp<model_TK> {
private:
  int n_rep;
  int lentp;
  Eigen::Matrix<double, -1, 1> tp;
  int n_exp;
  Eigen::Matrix<double, -1, -1> Cexp;
  int n_out;
  std::vector<std::vector<std::vector<double>>> CGobs;
  int n_met;
  std::vector<std::vector<std::vector<double>>> Cmet;
  double gmaxsup;
  int rankacc;
  double tacc;
  double C0;
  double elim_rate;
  double unifMax;
  int len_vt;
  Eigen::Matrix<double, -1, 1> vt;
  int gmax_1dim__;
  int G0_1dim__;
 
public:
  ~model_TK() { }
  
  inline std::string model_name() const final { return "model_TK"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1-4-gd72b68b7-dirty", "stancflags = "};
  }
  
  
  model_TK(stan::io::var_context& context__, unsigned int random_seed__ = 0,
           std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_TK_namespace::model_TK";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 131;
      context__.validate_dims("data initialization","n_rep","int",
          context__.to_vec());
      n_rep = std::numeric_limits<int>::min();
      
      current_statement__ = 131;
      n_rep = context__.vals_i("n_rep")[(1 - 1)];
      current_statement__ = 131;
      current_statement__ = 131;
      check_greater_or_equal(function__, "n_rep", n_rep, 0);
      current_statement__ = 132;
      context__.validate_dims("data initialization","lentp","int",
          context__.to_vec());
      lentp = std::numeric_limits<int>::min();
      
      current_statement__ = 132;
      lentp = context__.vals_i("lentp")[(1 - 1)];
      current_statement__ = 132;
      current_statement__ = 132;
      check_greater_or_equal(function__, "lentp", lentp, 0);
      current_statement__ = 133;
      validate_non_negative_index("tp", "lentp", lentp);
      current_statement__ = 134;
      context__.validate_dims("data initialization","tp","double",
          context__.to_vec(lentp));
      tp = Eigen::Matrix<double, -1, 1>(lentp);
      stan::math::fill(tp, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> tp_flat__;
        current_statement__ = 134;
        assign(tp_flat__, nil_index_list(), context__.vals_r("tp"),
          "assigning variable tp_flat__");
        current_statement__ = 134;
        pos__ = 1;
        current_statement__ = 134;
        for (int sym1__ = 1; sym1__ <= lentp; ++sym1__) {
          current_statement__ = 134;
          assign(tp, cons_list(index_uni(sym1__), nil_index_list()),
            tp_flat__[(pos__ - 1)], "assigning variable tp");
          current_statement__ = 134;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 135;
      context__.validate_dims("data initialization","n_exp","int",
          context__.to_vec());
      n_exp = std::numeric_limits<int>::min();
      
      current_statement__ = 135;
      n_exp = context__.vals_i("n_exp")[(1 - 1)];
      current_statement__ = 135;
      current_statement__ = 135;
      check_greater_or_equal(function__, "n_exp", n_exp, 0);
      current_statement__ = 136;
      validate_non_negative_index("Cexp", "lentp", lentp);
      current_statement__ = 137;
      validate_non_negative_index("Cexp", "n_exp", n_exp);
      current_statement__ = 138;
      context__.validate_dims("data initialization","Cexp","double",
          context__.to_vec(lentp, n_exp));
      Cexp = Eigen::Matrix<double, -1, -1>(lentp, n_exp);
      stan::math::fill(Cexp, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> Cexp_flat__;
        current_statement__ = 138;
        assign(Cexp_flat__, nil_index_list(), context__.vals_r("Cexp"),
          "assigning variable Cexp_flat__");
        current_statement__ = 138;
        pos__ = 1;
        current_statement__ = 138;
        for (int sym1__ = 1; sym1__ <= n_exp; ++sym1__) {
          current_statement__ = 138;
          for (int sym2__ = 1; sym2__ <= lentp; ++sym2__) {
            current_statement__ = 138;
            assign(Cexp,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              Cexp_flat__[(pos__ - 1)], "assigning variable Cexp");
            current_statement__ = 138;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 139;
      context__.validate_dims("data initialization","n_out","int",
          context__.to_vec());
      n_out = std::numeric_limits<int>::min();
      
      current_statement__ = 139;
      n_out = context__.vals_i("n_out")[(1 - 1)];
      current_statement__ = 139;
      current_statement__ = 139;
      check_greater_or_equal(function__, "n_out", n_out, 0);
      current_statement__ = 140;
      validate_non_negative_index("CGobs", "lentp", lentp);
      current_statement__ = 141;
      validate_non_negative_index("CGobs", "n_out", n_out);
      current_statement__ = 142;
      validate_non_negative_index("CGobs", "n_rep", n_rep);
      current_statement__ = 143;
      context__.validate_dims("data initialization","CGobs","double",
          context__.to_vec(lentp, n_out, n_rep));
      CGobs = std::vector<std::vector<std::vector<double>>>(lentp, std::vector<std::vector<double>>(n_out, std::vector<double>(n_rep, std::numeric_limits<double>::quiet_NaN())));
      
      {
        std::vector<local_scalar_t__> CGobs_flat__;
        current_statement__ = 143;
        assign(CGobs_flat__, nil_index_list(), context__.vals_r("CGobs"),
          "assigning variable CGobs_flat__");
        current_statement__ = 143;
        pos__ = 1;
        current_statement__ = 143;
        for (int sym1__ = 1; sym1__ <= n_rep; ++sym1__) {
          current_statement__ = 143;
          for (int sym2__ = 1; sym2__ <= n_out; ++sym2__) {
            current_statement__ = 143;
            for (int sym3__ = 1; sym3__ <= lentp; ++sym3__) {
              current_statement__ = 143;
              assign(CGobs,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))),
                CGobs_flat__[(pos__ - 1)], "assigning variable CGobs");
              current_statement__ = 143;
              pos__ = (pos__ + 1);}}}
      }
      current_statement__ = 144;
      context__.validate_dims("data initialization","n_met","int",
          context__.to_vec());
      n_met = std::numeric_limits<int>::min();
      
      current_statement__ = 144;
      n_met = context__.vals_i("n_met")[(1 - 1)];
      current_statement__ = 144;
      current_statement__ = 144;
      check_greater_or_equal(function__, "n_met", n_met, 0);
      current_statement__ = 145;
      validate_non_negative_index("Cmet", "lentp", lentp);
      current_statement__ = 146;
      validate_non_negative_index("Cmet", "n_met", n_met);
      current_statement__ = 147;
      validate_non_negative_index("Cmet", "n_rep", n_rep);
      current_statement__ = 148;
      context__.validate_dims("data initialization","Cmet","double",
          context__.to_vec(lentp, n_met, n_rep));
      Cmet = std::vector<std::vector<std::vector<double>>>(lentp, std::vector<std::vector<double>>(n_met, std::vector<double>(n_rep, std::numeric_limits<double>::quiet_NaN())));
      
      {
        std::vector<local_scalar_t__> Cmet_flat__;
        current_statement__ = 148;
        assign(Cmet_flat__, nil_index_list(), context__.vals_r("Cmet"),
          "assigning variable Cmet_flat__");
        current_statement__ = 148;
        pos__ = 1;
        current_statement__ = 148;
        for (int sym1__ = 1; sym1__ <= n_rep; ++sym1__) {
          current_statement__ = 148;
          for (int sym2__ = 1; sym2__ <= n_met; ++sym2__) {
            current_statement__ = 148;
            for (int sym3__ = 1; sym3__ <= lentp; ++sym3__) {
              current_statement__ = 148;
              assign(Cmet,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))),
                Cmet_flat__[(pos__ - 1)], "assigning variable Cmet");
              current_statement__ = 148;
              pos__ = (pos__ + 1);}}}
      }
      current_statement__ = 149;
      context__.validate_dims("data initialization","gmaxsup","double",
          context__.to_vec());
      gmaxsup = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 149;
      gmaxsup = context__.vals_r("gmaxsup")[(1 - 1)];
      current_statement__ = 149;
      current_statement__ = 149;
      check_greater_or_equal(function__, "gmaxsup", gmaxsup, 0);
      current_statement__ = 150;
      context__.validate_dims("data initialization","rankacc","int",
          context__.to_vec());
      rankacc = std::numeric_limits<int>::min();
      
      current_statement__ = 150;
      rankacc = context__.vals_i("rankacc")[(1 - 1)];
      current_statement__ = 150;
      current_statement__ = 150;
      check_greater_or_equal(function__, "rankacc", rankacc, 0);
      current_statement__ = 151;
      context__.validate_dims("data initialization","tacc","double",
          context__.to_vec());
      tacc = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 151;
      tacc = context__.vals_r("tacc")[(1 - 1)];
      current_statement__ = 151;
      current_statement__ = 151;
      check_greater_or_equal(function__, "tacc", tacc, 0);
      current_statement__ = 152;
      context__.validate_dims("data initialization","C0","double",
          context__.to_vec());
      C0 = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 152;
      C0 = context__.vals_r("C0")[(1 - 1)];
      current_statement__ = 152;
      current_statement__ = 152;
      check_greater_or_equal(function__, "C0", C0, 0);
      current_statement__ = 153;
      context__.validate_dims("data initialization","elim_rate","double",
          context__.to_vec());
      elim_rate = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 153;
      elim_rate = context__.vals_r("elim_rate")[(1 - 1)];
      current_statement__ = 154;
      context__.validate_dims("data initialization","unifMax","double",
          context__.to_vec());
      unifMax = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 154;
      unifMax = context__.vals_r("unifMax")[(1 - 1)];
      current_statement__ = 155;
      context__.validate_dims("data initialization","len_vt","int",
          context__.to_vec());
      len_vt = std::numeric_limits<int>::min();
      
      current_statement__ = 155;
      len_vt = context__.vals_i("len_vt")[(1 - 1)];
      current_statement__ = 155;
      current_statement__ = 155;
      check_greater_or_equal(function__, "len_vt", len_vt, 0);
      current_statement__ = 156;
      validate_non_negative_index("vt", "len_vt", len_vt);
      current_statement__ = 157;
      context__.validate_dims("data initialization","vt","double",
          context__.to_vec(len_vt));
      vt = Eigen::Matrix<double, -1, 1>(len_vt);
      stan::math::fill(vt, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> vt_flat__;
        current_statement__ = 157;
        assign(vt_flat__, nil_index_list(), context__.vals_r("vt"),
          "assigning variable vt_flat__");
        current_statement__ = 157;
        pos__ = 1;
        current_statement__ = 157;
        for (int sym1__ = 1; sym1__ <= len_vt; ++sym1__) {
          current_statement__ = 157;
          assign(vt, cons_list(index_uni(sym1__), nil_index_list()),
            vt_flat__[(pos__ - 1)], "assigning variable vt");
          current_statement__ = 157;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 158;
      validate_non_negative_index("log10ku", "n_exp", n_exp);
      current_statement__ = 159;
      validate_non_negative_index("log10ke", "n_out", n_out);
      current_statement__ = 160;
      validate_non_negative_index("log10km", "n_met", n_met);
      current_statement__ = 161;
      validate_non_negative_index("log10kem", "n_met", n_met);
      current_statement__ = 162;
      validate_non_negative_index("sigmaCGpred", "n_out", n_out);
      current_statement__ = 163;
      validate_non_negative_index("sigmaCmetpred", "n_met", n_met);
      current_statement__ = 164;
      gmax_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 164;
      gmax_1dim__ = (n_out - 1);
      current_statement__ = 164;
      validate_non_negative_index("gmax", "n_out - 1", gmax_1dim__);
      current_statement__ = 165;
      G0_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 165;
      G0_1dim__ = (n_out - 1);
      current_statement__ = 165;
      validate_non_negative_index("G0", "n_out - 1", G0_1dim__);
      current_statement__ = 166;
      validate_non_negative_index("ku", "n_exp", n_exp);
      current_statement__ = 167;
      validate_non_negative_index("ke", "n_out", n_out);
      current_statement__ = 168;
      validate_non_negative_index("km", "n_met", n_met);
      current_statement__ = 169;
      validate_non_negative_index("kem", "n_met", n_met);
      current_statement__ = 170;
      validate_non_negative_index("U", "lentp", lentp);
      current_statement__ = 171;
      validate_non_negative_index("R", "lentp", lentp);
      current_statement__ = 172;
      validate_non_negative_index("D", "n_met", n_met);
      current_statement__ = 173;
      validate_non_negative_index("CGpred", "lentp", lentp);
      current_statement__ = 174;
      validate_non_negative_index("CGpred", "n_out", n_out);
      current_statement__ = 175;
      validate_non_negative_index("Cmetpred", "lentp", lentp);
      current_statement__ = 176;
      validate_non_negative_index("Cmetpred", "n_met", n_met);
      current_statement__ = 177;
      validate_non_negative_index("CGobs_out", "lentp", lentp);
      current_statement__ = 178;
      validate_non_negative_index("CGobs_out", "n_out", n_out);
      current_statement__ = 179;
      validate_non_negative_index("Cmet_out", "lentp", lentp);
      current_statement__ = 180;
      validate_non_negative_index("Cmet_out", "n_met", n_met);
      current_statement__ = 181;
      validate_non_negative_index("Cexp_interpol", "len_vt", len_vt);
      current_statement__ = 182;
      validate_non_negative_index("Cexp_interpol", "n_exp", n_exp);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += n_exp;
      num_params_r__ += n_out;
      num_params_r__ += n_met;
      num_params_r__ += n_met;
      num_params_r__ += n_out;
      num_params_r__ += n_met;
      num_params_r__ += gmax_1dim__;
      num_params_r__ += G0_1dim__;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_TK_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<local_scalar_t__, -1, 1> log10ku;
      log10ku = Eigen::Matrix<local_scalar_t__, -1, 1>(n_exp);
      stan::math::fill(log10ku, DUMMY_VAR__);
      
      current_statement__ = 1;
      log10ku = in__.vector(n_exp);
      Eigen::Matrix<local_scalar_t__, -1, 1> log10ke;
      log10ke = Eigen::Matrix<local_scalar_t__, -1, 1>(n_out);
      stan::math::fill(log10ke, DUMMY_VAR__);
      
      current_statement__ = 2;
      log10ke = in__.vector(n_out);
      Eigen::Matrix<local_scalar_t__, -1, 1> log10km;
      log10km = Eigen::Matrix<local_scalar_t__, -1, 1>(n_met);
      stan::math::fill(log10km, DUMMY_VAR__);
      
      current_statement__ = 3;
      log10km = in__.vector(n_met);
      Eigen::Matrix<local_scalar_t__, -1, 1> log10kem;
      log10kem = Eigen::Matrix<local_scalar_t__, -1, 1>(n_met);
      stan::math::fill(log10kem, DUMMY_VAR__);
      
      current_statement__ = 4;
      log10kem = in__.vector(n_met);
      std::vector<local_scalar_t__> sigmaCGpred;
      sigmaCGpred = std::vector<local_scalar_t__>(n_out, DUMMY_VAR__);
      
      current_statement__ = 5;
      for (int sym1__ = 1; sym1__ <= n_out; ++sym1__) {
        current_statement__ = 5;
        assign(sigmaCGpred, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable sigmaCGpred");}
      current_statement__ = 5;
      for (int sym1__ = 1; sym1__ <= n_out; ++sym1__) {
        current_statement__ = 5;
        if (jacobian__) {
          current_statement__ = 5;
          assign(sigmaCGpred, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(sigmaCGpred[(sym1__ - 1)], 0, lp__),
            "assigning variable sigmaCGpred");
        } else {
          current_statement__ = 5;
          assign(sigmaCGpred, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(sigmaCGpred[(sym1__ - 1)], 0),
            "assigning variable sigmaCGpred");
        }}
      Eigen::Matrix<local_scalar_t__, -1, 1> sigmaCmetpred;
      sigmaCmetpred = Eigen::Matrix<local_scalar_t__, -1, 1>(n_met);
      stan::math::fill(sigmaCmetpred, DUMMY_VAR__);
      
      current_statement__ = 6;
      sigmaCmetpred = in__.vector(n_met);
      current_statement__ = 6;
      for (int sym1__ = 1; sym1__ <= n_met; ++sym1__) {
        current_statement__ = 6;
        if (jacobian__) {
          current_statement__ = 6;
          assign(sigmaCmetpred,
            cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(sigmaCmetpred[(sym1__ - 1)], 0, lp__),
            "assigning variable sigmaCmetpred");
        } else {
          current_statement__ = 6;
          assign(sigmaCmetpred,
            cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(sigmaCmetpred[(sym1__ - 1)], 0),
            "assigning variable sigmaCmetpred");
        }}
      std::vector<local_scalar_t__> gmax;
      gmax = std::vector<local_scalar_t__>(gmax_1dim__, DUMMY_VAR__);
      
      current_statement__ = 7;
      for (int sym1__ = 1; sym1__ <= gmax_1dim__; ++sym1__) {
        current_statement__ = 7;
        assign(gmax, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable gmax");}
      current_statement__ = 7;
      for (int sym1__ = 1; sym1__ <= gmax_1dim__; ++sym1__) {
        current_statement__ = 7;
        if (jacobian__) {
          current_statement__ = 7;
          assign(gmax, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(gmax[(sym1__ - 1)], 0, lp__),
            "assigning variable gmax");
        } else {
          current_statement__ = 7;
          assign(gmax, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(gmax[(sym1__ - 1)], 0),
            "assigning variable gmax");
        }}
      std::vector<local_scalar_t__> G0;
      G0 = std::vector<local_scalar_t__>(G0_1dim__, DUMMY_VAR__);
      
      current_statement__ = 8;
      for (int sym1__ = 1; sym1__ <= G0_1dim__; ++sym1__) {
        current_statement__ = 8;
        assign(G0, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable G0");}
      current_statement__ = 8;
      for (int sym1__ = 1; sym1__ <= G0_1dim__; ++sym1__) {
        current_statement__ = 8;
        if (jacobian__) {
          current_statement__ = 8;
          assign(G0, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(G0[(sym1__ - 1)], 0, lp__),
            "assigning variable G0");
        } else {
          current_statement__ = 8;
          assign(G0, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(G0[(sym1__ - 1)], 0),
            "assigning variable G0");
        }}
      Eigen::Matrix<local_scalar_t__, -1, 1> ku;
      ku = Eigen::Matrix<local_scalar_t__, -1, 1>(n_exp);
      stan::math::fill(ku, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> ke;
      ke = Eigen::Matrix<local_scalar_t__, -1, 1>(n_out);
      stan::math::fill(ke, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> km;
      km = Eigen::Matrix<local_scalar_t__, -1, 1>(n_met);
      stan::math::fill(km, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> kem;
      kem = Eigen::Matrix<local_scalar_t__, -1, 1>(n_met);
      stan::math::fill(kem, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> U;
      U = Eigen::Matrix<local_scalar_t__, -1, 1>(lentp);
      stan::math::fill(U, DUMMY_VAR__);
      
      local_scalar_t__ M;
      M = DUMMY_VAR__;
      
      local_scalar_t__ E;
      E = DUMMY_VAR__;
      
      Eigen::Matrix<local_scalar_t__, -1, 1> R;
      R = Eigen::Matrix<local_scalar_t__, -1, 1>(lentp);
      stan::math::fill(R, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> D;
      D = Eigen::Matrix<local_scalar_t__, -1, 1>(n_met);
      stan::math::fill(D, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, -1> CGpred;
      CGpred = Eigen::Matrix<local_scalar_t__, -1, -1>(lentp, n_out);
      stan::math::fill(CGpred, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, -1> Cmetpred;
      Cmetpred = Eigen::Matrix<local_scalar_t__, -1, -1>(lentp, n_met);
      stan::math::fill(Cmetpred, DUMMY_VAR__);
      
      current_statement__ = 22;
      for (int i = 1; i <= n_exp; ++i) {
        current_statement__ = 20;
        assign(ku, cons_list(index_uni(i), nil_index_list()),
          pow(10, log10ku[(i - 1)]), "assigning variable ku");}
      current_statement__ = 29;
      for (int i = 1; i <= n_out; ++i) {
        current_statement__ = 27;
        if (logical_negation(is_inf(elim_rate))) {
          current_statement__ = 25;
          assign(ke, cons_list(index_uni(i), nil_index_list()), 0,
            "assigning variable ke");
        } else {
          current_statement__ = 23;
          assign(ke, cons_list(index_uni(i), nil_index_list()),
            pow(10, log10ke[(i - 1)]), "assigning variable ke");
        }}
      current_statement__ = 33;
      for (int i = 1; i <= n_met; ++i) {
        current_statement__ = 30;
        assign(km, cons_list(index_uni(i), nil_index_list()),
          pow(10, log10km[(i - 1)]), "assigning variable km");
        current_statement__ = 31;
        assign(kem, cons_list(index_uni(i), nil_index_list()),
          pow(10, log10kem[(i - 1)]), "assigning variable kem");}
      current_statement__ = 38;
      if (logical_eq(n_met, 0)) {
        current_statement__ = 36;
        M = 0;
      } else {
        current_statement__ = 34;
        M = sum(km);
      }
      current_statement__ = 43;
      if (logical_negation(is_inf(elim_rate))) {
        current_statement__ = 41;
        E = elim_rate;
      } else {
        current_statement__ = 39;
        E = sum(ke);
      }
      current_statement__ = 47;
      for (int t = 1; t <= lentp; ++t) {
        current_statement__ = 44;
        assign(U, cons_list(index_uni(t), nil_index_list()),
          multiply(
            rvalue(Cexp,
              cons_list(index_uni(t),
                cons_list(index_min_max(1, n_exp), nil_index_list())),
              "Cexp"), ku), "assigning variable U");
        current_statement__ = 45;
        assign(R, cons_list(index_uni(t), nil_index_list()),
          (U[(t - 1)] / (E + M)), "assigning variable R");}
      current_statement__ = 50;
      for (int i = 1; i <= n_met; ++i) {
        current_statement__ = 48;
        assign(D, cons_list(index_uni(i), nil_index_list()),
          (kem[(i - 1)] - (E + M)), "assigning variable D");}
      current_statement__ = 58;
      for (int t = 1; t <= rankacc; ++t) {
        current_statement__ = 51;
        assign(CGpred,
          cons_list(index_uni(t), cons_list(index_uni(1), nil_index_list())),
          (((C0 - R[(t - 1)]) * stan::math::exp((-(E + M) * tp[(t - 1)]))) +
            R[(t - 1)]), "assigning variable CGpred");
        current_statement__ = 56;
        if (logical_gt(n_met, 0)) {
          current_statement__ = 54;
          for (int i = 1; i <= n_met; ++i) {
            current_statement__ = 52;
            assign(Cmetpred,
              cons_list(index_uni(t),
                cons_list(index_uni(i), nil_index_list())),
              (km[(i - 1)] *
                ((((C0 - R[(t - 1)]) / D[(i - 1)]) *
                   (stan::math::exp((-(E + M) * tp[(t - 1)])) -
                     stan::math::exp((-kem[(i - 1)] * tp[(t - 1)])))) +
                  ((R[(t - 1)] / kem[(i - 1)]) *
                    (1 - stan::math::exp(-(kem[(i - 1)] * tp[(t - 1)])))))),
              "assigning variable Cmetpred");}
        } }
      current_statement__ = 66;
      for (int t = (rankacc + 1); t <= lentp; ++t) {
        current_statement__ = 59;
        assign(CGpred,
          cons_list(index_uni(t), cons_list(index_uni(1), nil_index_list())),
          ((C0 - (R[(t - 1)] * (1 - stan::math::exp(((E + M) * tacc))))) *
            stan::math::exp((-(E + M) * tp[(t - 1)]))),
          "assigning variable CGpred");
        current_statement__ = 64;
        if (logical_gt(n_met, 0)) {
          current_statement__ = 62;
          for (int i = 1; i <= n_met; ++i) {
            current_statement__ = 60;
            assign(Cmetpred,
              cons_list(index_uni(t),
                cons_list(index_uni(i), nil_index_list())),
              (km[(i - 1)] *
                (((((C0 - R[(t - 1)]) / D[(i - 1)]) *
                    (stan::math::exp((-(E + M) * tp[(t - 1)])) -
                      stan::math::exp((-kem[(i - 1)] * tp[(t - 1)])))) +
                   ((R[(t - 1)] / kem[(i - 1)]) *
                     (stan::math::exp((-kem[(i - 1)] * (tp[(t - 1)] - tacc)))
                       - stan::math::exp((-kem[(i - 1)] * tp[(t - 1)]))))) +
                  ((R[(t - 1)] / D[(i - 1)]) *
                    (stan::math::exp((-(E + M) * (tp[(t - 1)] - tacc))) -
                      stan::math::exp((-kem[(i - 1)] * (tp[(t - 1)] - tacc))))))),
              "assigning variable Cmetpred");}
        } }
      current_statement__ = 71;
      if (logical_eq(n_out, 2)) {
        current_statement__ = 69;
        for (int t = 1; t <= lentp; ++t) {
          current_statement__ = 67;
          assign(CGpred,
            cons_list(index_uni(t),
              cons_list(index_uni(2), nil_index_list())),
            (((G0[(1 - 1)] - gmax[(1 - 1)]) *
               stan::math::exp((-ke[(2 - 1)] * tp[(t - 1)]))) +
              gmax[(1 - 1)]), "assigning variable CGpred");}
      } 
      current_statement__ = 9;
      for (int sym1__ = 1; sym1__ <= n_exp; ++sym1__) {
        current_statement__ = 9;
        current_statement__ = 9;
        check_greater_or_equal(function__, "ku[sym1__]", ku[(sym1__ - 1)], 0);
      }
      current_statement__ = 10;
      for (int sym1__ = 1; sym1__ <= n_out; ++sym1__) {
        current_statement__ = 10;
        current_statement__ = 10;
        check_greater_or_equal(function__, "ke[sym1__]", ke[(sym1__ - 1)], 0);
      }
      current_statement__ = 11;
      for (int sym1__ = 1; sym1__ <= n_met; ++sym1__) {
        current_statement__ = 11;
        current_statement__ = 11;
        check_greater_or_equal(function__, "km[sym1__]", km[(sym1__ - 1)], 0);
      }
      current_statement__ = 12;
      for (int sym1__ = 1; sym1__ <= n_met; ++sym1__) {
        current_statement__ = 12;
        current_statement__ = 12;
        check_greater_or_equal(function__, "kem[sym1__]", kem[(sym1__ - 1)],
                               0);}
      {
        current_statement__ = 91;
        lp_accum__.add(uniform_lpdf<false>(log10ku, -5, 5));
        current_statement__ = 92;
        lp_accum__.add(uniform_lpdf<false>(log10ke, -5, 5));
        current_statement__ = 93;
        lp_accum__.add(uniform_lpdf<false>(log10km, -5, 5));
        current_statement__ = 94;
        lp_accum__.add(uniform_lpdf<false>(log10kem, -5, 5));
        current_statement__ = 95;
        lp_accum__.add(uniform_lpdf<false>(sigmaCGpred[(1 - 1)], 0, unifMax));
        current_statement__ = 96;
        lp_accum__.add(uniform_lpdf<false>(sigmaCmetpred, 0, unifMax));
        current_statement__ = 101;
        if (logical_eq(n_out, 2)) {
          current_statement__ = 97;
          lp_accum__.add(
            uniform_lpdf<false>(sigmaCGpred[(2 - 1)], 0, unifMax));
          current_statement__ = 98;
          lp_accum__.add(
            uniform_lpdf<false>(gmax[(1 - 1)], (gmaxsup / 6), gmaxsup));
          current_statement__ = 99;
          lp_accum__.add(uniform_lpdf<false>(G0[(1 - 1)], 0, gmaxsup));
        } 
        current_statement__ = 130;
        for (int rep = 1; rep <= n_rep; ++rep) {
          current_statement__ = 111;
          for (int t = 1; t <= rankacc; ++t) {
            current_statement__ = 104;
            if (logical_negation(is_inf(CGobs[(t - 1)][(1 - 1)][(rep - 1)]))) {
              current_statement__ = 102;
              lp_accum__.add(
                normal_lpdf<false>(CGobs[(t - 1)][(1 - 1)][(rep - 1)],
                  rvalue(CGpred,
                    cons_list(index_uni(t),
                      cons_list(index_uni(1), nil_index_list())), "CGpred"),
                  sigmaCGpred[(1 - 1)]));
            } 
            current_statement__ = 109;
            for (int i = 1; i <= n_met; ++i) {
              current_statement__ = 107;
              if (logical_negation(is_inf(Cmet[(t - 1)][(i - 1)][(rep - 1)]))) {
                current_statement__ = 105;
                lp_accum__.add(
                  normal_lpdf<false>(Cmet[(t - 1)][(i - 1)][(rep - 1)],
                    rvalue(Cmetpred,
                      cons_list(index_uni(t),
                        cons_list(index_uni(i), nil_index_list())),
                      "Cmetpred"), sigmaCmetpred[(i - 1)]));
              } }}
          current_statement__ = 121;
          for (int t = (rankacc + 1); t <= lentp; ++t) {
            current_statement__ = 114;
            if (logical_negation(is_inf(CGobs[(t - 1)][(1 - 1)][(rep - 1)]))) {
              current_statement__ = 112;
              lp_accum__.add(
                normal_lpdf<false>(CGobs[(t - 1)][(1 - 1)][(rep - 1)],
                  rvalue(CGpred,
                    cons_list(index_uni(t),
                      cons_list(index_uni(1), nil_index_list())), "CGpred"),
                  sigmaCGpred[(1 - 1)]));
            } 
            current_statement__ = 119;
            for (int i = 1; i <= n_met; ++i) {
              current_statement__ = 117;
              if (logical_negation(is_inf(Cmet[(t - 1)][(i - 1)][(rep - 1)]))) {
                current_statement__ = 115;
                lp_accum__.add(
                  normal_lpdf<false>(Cmet[(t - 1)][(i - 1)][(rep - 1)],
                    rvalue(Cmetpred,
                      cons_list(index_uni(t),
                        cons_list(index_uni(i), nil_index_list())),
                      "Cmetpred"), sigmaCmetpred[(i - 1)]));
              } }}
          current_statement__ = 128;
          if (logical_eq(n_out, 2)) {
            current_statement__ = 126;
            for (int t = 1; t <= lentp; ++t) {
              current_statement__ = 124;
              if (logical_negation(
                    is_inf(CGobs[(t - 1)][(2 - 1)][(rep - 1)]))) {
                current_statement__ = 122;
                lp_accum__.add(
                  normal_lpdf<false>(CGobs[(t - 1)][(2 - 1)][(rep - 1)],
                    rvalue(CGpred,
                      cons_list(index_uni(t),
                        cons_list(index_uni(2), nil_index_list())), "CGpred"),
                    sigmaCGpred[(2 - 1)]));
              } }
          } }
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_TK_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<double, -1, 1> log10ku;
      log10ku = Eigen::Matrix<double, -1, 1>(n_exp);
      stan::math::fill(log10ku, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      log10ku = in__.vector(n_exp);
      Eigen::Matrix<double, -1, 1> log10ke;
      log10ke = Eigen::Matrix<double, -1, 1>(n_out);
      stan::math::fill(log10ke, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      log10ke = in__.vector(n_out);
      Eigen::Matrix<double, -1, 1> log10km;
      log10km = Eigen::Matrix<double, -1, 1>(n_met);
      stan::math::fill(log10km, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      log10km = in__.vector(n_met);
      Eigen::Matrix<double, -1, 1> log10kem;
      log10kem = Eigen::Matrix<double, -1, 1>(n_met);
      stan::math::fill(log10kem, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 4;
      log10kem = in__.vector(n_met);
      std::vector<double> sigmaCGpred;
      sigmaCGpred = std::vector<double>(n_out, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 5;
      for (int sym1__ = 1; sym1__ <= n_out; ++sym1__) {
        current_statement__ = 5;
        assign(sigmaCGpred, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable sigmaCGpred");}
      current_statement__ = 5;
      for (int sym1__ = 1; sym1__ <= n_out; ++sym1__) {
        current_statement__ = 5;
        assign(sigmaCGpred, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(sigmaCGpred[(sym1__ - 1)], 0),
          "assigning variable sigmaCGpred");}
      Eigen::Matrix<double, -1, 1> sigmaCmetpred;
      sigmaCmetpred = Eigen::Matrix<double, -1, 1>(n_met);
      stan::math::fill(sigmaCmetpred, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 6;
      sigmaCmetpred = in__.vector(n_met);
      current_statement__ = 6;
      for (int sym1__ = 1; sym1__ <= n_met; ++sym1__) {
        current_statement__ = 6;
        assign(sigmaCmetpred, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(sigmaCmetpred[(sym1__ - 1)], 0),
          "assigning variable sigmaCmetpred");}
      std::vector<double> gmax;
      gmax = std::vector<double>(gmax_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 7;
      for (int sym1__ = 1; sym1__ <= gmax_1dim__; ++sym1__) {
        current_statement__ = 7;
        assign(gmax, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable gmax");}
      current_statement__ = 7;
      for (int sym1__ = 1; sym1__ <= gmax_1dim__; ++sym1__) {
        current_statement__ = 7;
        assign(gmax, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(gmax[(sym1__ - 1)], 0),
          "assigning variable gmax");}
      std::vector<double> G0;
      G0 = std::vector<double>(G0_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 8;
      for (int sym1__ = 1; sym1__ <= G0_1dim__; ++sym1__) {
        current_statement__ = 8;
        assign(G0, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable G0");}
      current_statement__ = 8;
      for (int sym1__ = 1; sym1__ <= G0_1dim__; ++sym1__) {
        current_statement__ = 8;
        assign(G0, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(G0[(sym1__ - 1)], 0),
          "assigning variable G0");}
      Eigen::Matrix<double, -1, 1> ku;
      ku = Eigen::Matrix<double, -1, 1>(n_exp);
      stan::math::fill(ku, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> ke;
      ke = Eigen::Matrix<double, -1, 1>(n_out);
      stan::math::fill(ke, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> km;
      km = Eigen::Matrix<double, -1, 1>(n_met);
      stan::math::fill(km, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> kem;
      kem = Eigen::Matrix<double, -1, 1>(n_met);
      stan::math::fill(kem, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> U;
      U = Eigen::Matrix<double, -1, 1>(lentp);
      stan::math::fill(U, std::numeric_limits<double>::quiet_NaN());
      
      double M;
      M = std::numeric_limits<double>::quiet_NaN();
      
      double E;
      E = std::numeric_limits<double>::quiet_NaN();
      
      Eigen::Matrix<double, -1, 1> R;
      R = Eigen::Matrix<double, -1, 1>(lentp);
      stan::math::fill(R, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> D;
      D = Eigen::Matrix<double, -1, 1>(n_met);
      stan::math::fill(D, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, -1> CGpred;
      CGpred = Eigen::Matrix<double, -1, -1>(lentp, n_out);
      stan::math::fill(CGpred, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, -1> Cmetpred;
      Cmetpred = Eigen::Matrix<double, -1, -1>(lentp, n_met);
      stan::math::fill(Cmetpred, std::numeric_limits<double>::quiet_NaN());
      
      for (int sym1__ = 1; sym1__ <= n_exp; ++sym1__) {
        vars__.emplace_back(log10ku[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= n_out; ++sym1__) {
        vars__.emplace_back(log10ke[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= n_met; ++sym1__) {
        vars__.emplace_back(log10km[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= n_met; ++sym1__) {
        vars__.emplace_back(log10kem[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= n_out; ++sym1__) {
        vars__.emplace_back(sigmaCGpred[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= n_met; ++sym1__) {
        vars__.emplace_back(sigmaCmetpred[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= gmax_1dim__; ++sym1__) {
        vars__.emplace_back(gmax[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= G0_1dim__; ++sym1__) {
        vars__.emplace_back(G0[(sym1__ - 1)]);}
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      current_statement__ = 22;
      for (int i = 1; i <= n_exp; ++i) {
        current_statement__ = 20;
        assign(ku, cons_list(index_uni(i), nil_index_list()),
          pow(10, log10ku[(i - 1)]), "assigning variable ku");}
      current_statement__ = 29;
      for (int i = 1; i <= n_out; ++i) {
        current_statement__ = 27;
        if (logical_negation(is_inf(elim_rate))) {
          current_statement__ = 25;
          assign(ke, cons_list(index_uni(i), nil_index_list()), 0,
            "assigning variable ke");
        } else {
          current_statement__ = 23;
          assign(ke, cons_list(index_uni(i), nil_index_list()),
            pow(10, log10ke[(i - 1)]), "assigning variable ke");
        }}
      current_statement__ = 33;
      for (int i = 1; i <= n_met; ++i) {
        current_statement__ = 30;
        assign(km, cons_list(index_uni(i), nil_index_list()),
          pow(10, log10km[(i - 1)]), "assigning variable km");
        current_statement__ = 31;
        assign(kem, cons_list(index_uni(i), nil_index_list()),
          pow(10, log10kem[(i - 1)]), "assigning variable kem");}
      current_statement__ = 38;
      if (logical_eq(n_met, 0)) {
        current_statement__ = 36;
        M = 0;
      } else {
        current_statement__ = 34;
        M = sum(km);
      }
      current_statement__ = 43;
      if (logical_negation(is_inf(elim_rate))) {
        current_statement__ = 41;
        E = elim_rate;
      } else {
        current_statement__ = 39;
        E = sum(ke);
      }
      current_statement__ = 47;
      for (int t = 1; t <= lentp; ++t) {
        current_statement__ = 44;
        assign(U, cons_list(index_uni(t), nil_index_list()),
          multiply(
            rvalue(Cexp,
              cons_list(index_uni(t),
                cons_list(index_min_max(1, n_exp), nil_index_list())),
              "Cexp"), ku), "assigning variable U");
        current_statement__ = 45;
        assign(R, cons_list(index_uni(t), nil_index_list()),
          (U[(t - 1)] / (E + M)), "assigning variable R");}
      current_statement__ = 50;
      for (int i = 1; i <= n_met; ++i) {
        current_statement__ = 48;
        assign(D, cons_list(index_uni(i), nil_index_list()),
          (kem[(i - 1)] - (E + M)), "assigning variable D");}
      current_statement__ = 58;
      for (int t = 1; t <= rankacc; ++t) {
        current_statement__ = 51;
        assign(CGpred,
          cons_list(index_uni(t), cons_list(index_uni(1), nil_index_list())),
          (((C0 - R[(t - 1)]) * stan::math::exp((-(E + M) * tp[(t - 1)]))) +
            R[(t - 1)]), "assigning variable CGpred");
        current_statement__ = 56;
        if (logical_gt(n_met, 0)) {
          current_statement__ = 54;
          for (int i = 1; i <= n_met; ++i) {
            current_statement__ = 52;
            assign(Cmetpred,
              cons_list(index_uni(t),
                cons_list(index_uni(i), nil_index_list())),
              (km[(i - 1)] *
                ((((C0 - R[(t - 1)]) / D[(i - 1)]) *
                   (stan::math::exp((-(E + M) * tp[(t - 1)])) -
                     stan::math::exp((-kem[(i - 1)] * tp[(t - 1)])))) +
                  ((R[(t - 1)] / kem[(i - 1)]) *
                    (1 - stan::math::exp(-(kem[(i - 1)] * tp[(t - 1)])))))),
              "assigning variable Cmetpred");}
        } }
      current_statement__ = 66;
      for (int t = (rankacc + 1); t <= lentp; ++t) {
        current_statement__ = 59;
        assign(CGpred,
          cons_list(index_uni(t), cons_list(index_uni(1), nil_index_list())),
          ((C0 - (R[(t - 1)] * (1 - stan::math::exp(((E + M) * tacc))))) *
            stan::math::exp((-(E + M) * tp[(t - 1)]))),
          "assigning variable CGpred");
        current_statement__ = 64;
        if (logical_gt(n_met, 0)) {
          current_statement__ = 62;
          for (int i = 1; i <= n_met; ++i) {
            current_statement__ = 60;
            assign(Cmetpred,
              cons_list(index_uni(t),
                cons_list(index_uni(i), nil_index_list())),
              (km[(i - 1)] *
                (((((C0 - R[(t - 1)]) / D[(i - 1)]) *
                    (stan::math::exp((-(E + M) * tp[(t - 1)])) -
                      stan::math::exp((-kem[(i - 1)] * tp[(t - 1)])))) +
                   ((R[(t - 1)] / kem[(i - 1)]) *
                     (stan::math::exp((-kem[(i - 1)] * (tp[(t - 1)] - tacc)))
                       - stan::math::exp((-kem[(i - 1)] * tp[(t - 1)]))))) +
                  ((R[(t - 1)] / D[(i - 1)]) *
                    (stan::math::exp((-(E + M) * (tp[(t - 1)] - tacc))) -
                      stan::math::exp((-kem[(i - 1)] * (tp[(t - 1)] - tacc))))))),
              "assigning variable Cmetpred");}
        } }
      current_statement__ = 71;
      if (logical_eq(n_out, 2)) {
        current_statement__ = 69;
        for (int t = 1; t <= lentp; ++t) {
          current_statement__ = 67;
          assign(CGpred,
            cons_list(index_uni(t),
              cons_list(index_uni(2), nil_index_list())),
            (((G0[(1 - 1)] - gmax[(1 - 1)]) *
               stan::math::exp((-ke[(2 - 1)] * tp[(t - 1)]))) +
              gmax[(1 - 1)]), "assigning variable CGpred");}
      } 
      current_statement__ = 9;
      for (int sym1__ = 1; sym1__ <= n_exp; ++sym1__) {
        current_statement__ = 9;
        current_statement__ = 9;
        check_greater_or_equal(function__, "ku[sym1__]", ku[(sym1__ - 1)], 0);
      }
      current_statement__ = 10;
      for (int sym1__ = 1; sym1__ <= n_out; ++sym1__) {
        current_statement__ = 10;
        current_statement__ = 10;
        check_greater_or_equal(function__, "ke[sym1__]", ke[(sym1__ - 1)], 0);
      }
      current_statement__ = 11;
      for (int sym1__ = 1; sym1__ <= n_met; ++sym1__) {
        current_statement__ = 11;
        current_statement__ = 11;
        check_greater_or_equal(function__, "km[sym1__]", km[(sym1__ - 1)], 0);
      }
      current_statement__ = 12;
      for (int sym1__ = 1; sym1__ <= n_met; ++sym1__) {
        current_statement__ = 12;
        current_statement__ = 12;
        check_greater_or_equal(function__, "kem[sym1__]", kem[(sym1__ - 1)],
                               0);}
      if (emit_transformed_parameters__) {
        for (int sym1__ = 1; sym1__ <= n_exp; ++sym1__) {
          vars__.emplace_back(ku[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= n_out; ++sym1__) {
          vars__.emplace_back(ke[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= n_met; ++sym1__) {
          vars__.emplace_back(km[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= n_met; ++sym1__) {
          vars__.emplace_back(kem[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= lentp; ++sym1__) {
          vars__.emplace_back(U[(sym1__ - 1)]);}
        vars__.emplace_back(M);
        vars__.emplace_back(E);
        for (int sym1__ = 1; sym1__ <= lentp; ++sym1__) {
          vars__.emplace_back(R[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= n_met; ++sym1__) {
          vars__.emplace_back(D[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= n_out; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= lentp; ++sym2__) {
            vars__.emplace_back(
              rvalue(CGpred,
                cons_list(index_uni(sym2__),
                  cons_list(index_uni(sym1__), nil_index_list())), "CGpred"));
          }}
        for (int sym1__ = 1; sym1__ <= n_met; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= lentp; ++sym2__) {
            vars__.emplace_back(
              rvalue(Cmetpred,
                cons_list(index_uni(sym2__),
                  cons_list(index_uni(sym1__), nil_index_list())),
                "Cmetpred"));}}
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
      std::vector<std::vector<double>> CGobs_out;
      CGobs_out = std::vector<std::vector<double>>(lentp, std::vector<double>(n_out, std::numeric_limits<double>::quiet_NaN()));
      
      std::vector<std::vector<double>> Cmet_out;
      Cmet_out = std::vector<std::vector<double>>(lentp, std::vector<double>(n_met, std::numeric_limits<double>::quiet_NaN()));
      
      std::vector<std::vector<double>> Cexp_interpol;
      Cexp_interpol = std::vector<std::vector<double>>(len_vt, std::vector<double>(n_exp, std::numeric_limits<double>::quiet_NaN()));
      
      current_statement__ = 80;
      for (int t = 1; t <= lentp; ++t) {
        current_statement__ = 75;
        assign(CGobs_out,
          cons_list(index_uni(t), cons_list(index_uni(1), nil_index_list())),
          normal_rng(
            rvalue(CGpred,
              cons_list(index_uni(t),
                cons_list(index_uni(1), nil_index_list())), "CGpred"),
            sigmaCGpred[(1 - 1)], base_rng__), "assigning variable CGobs_out");
        current_statement__ = 78;
        for (int i = 1; i <= n_met; ++i) {
          current_statement__ = 76;
          assign(Cmet_out,
            cons_list(index_uni(t),
              cons_list(index_uni(i), nil_index_list())),
            normal_rng(
              rvalue(Cmetpred,
                cons_list(index_uni(t),
                  cons_list(index_uni(i), nil_index_list())), "Cmetpred"),
              sigmaCmetpred[(i - 1)], base_rng__),
            "assigning variable Cmet_out");}}
      current_statement__ = 85;
      if (logical_eq(n_out, 2)) {
        current_statement__ = 83;
        for (int t = 1; t <= lentp; ++t) {
          current_statement__ = 81;
          assign(CGobs_out,
            cons_list(index_uni(t),
              cons_list(index_uni(2), nil_index_list())),
            normal_rng(
              rvalue(CGpred,
                cons_list(index_uni(t),
                  cons_list(index_uni(2), nil_index_list())), "CGpred"),
              sigmaCGpred[(2 - 1)], base_rng__),
            "assigning variable CGobs_out");}
      } 
      current_statement__ = 90;
      for (int i = 1; i <= n_exp; ++i) {
        current_statement__ = 88;
        for (int t = 1; t <= len_vt; ++t) {
          current_statement__ = 86;
          assign(Cexp_interpol,
            cons_list(index_uni(t),
              cons_list(index_uni(i), nil_index_list())),
            interpolate(vt[(t - 1)], tp,
              rvalue(Cexp,
                cons_list(index_min_max(1, lentp),
                  cons_list(index_uni(i), nil_index_list())), "Cexp"), pstream__),
            "assigning variable Cexp_interpol");}}
      for (int sym1__ = 1; sym1__ <= n_out; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= lentp; ++sym2__) {
          vars__.emplace_back(CGobs_out[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= n_met; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= lentp; ++sym2__) {
          vars__.emplace_back(Cmet_out[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= n_exp; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= len_vt; ++sym2__) {
          vars__.emplace_back(Cexp_interpol[(sym2__ - 1)][(sym1__ - 1)]);}}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      Eigen::Matrix<double, -1, 1> log10ku;
      log10ku = Eigen::Matrix<double, -1, 1>(n_exp);
      stan::math::fill(log10ku, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> log10ku_flat__;
        current_statement__ = 1;
        assign(log10ku_flat__, nil_index_list(), context__.vals_r("log10ku"),
          "assigning variable log10ku_flat__");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= n_exp; ++sym1__) {
          current_statement__ = 1;
          assign(log10ku, cons_list(index_uni(sym1__), nil_index_list()),
            log10ku_flat__[(pos__ - 1)], "assigning variable log10ku");
          current_statement__ = 1;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> log10ke;
      log10ke = Eigen::Matrix<double, -1, 1>(n_out);
      stan::math::fill(log10ke, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> log10ke_flat__;
        current_statement__ = 2;
        assign(log10ke_flat__, nil_index_list(), context__.vals_r("log10ke"),
          "assigning variable log10ke_flat__");
        current_statement__ = 2;
        pos__ = 1;
        current_statement__ = 2;
        for (int sym1__ = 1; sym1__ <= n_out; ++sym1__) {
          current_statement__ = 2;
          assign(log10ke, cons_list(index_uni(sym1__), nil_index_list()),
            log10ke_flat__[(pos__ - 1)], "assigning variable log10ke");
          current_statement__ = 2;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> log10km;
      log10km = Eigen::Matrix<double, -1, 1>(n_met);
      stan::math::fill(log10km, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> log10km_flat__;
        current_statement__ = 3;
        assign(log10km_flat__, nil_index_list(), context__.vals_r("log10km"),
          "assigning variable log10km_flat__");
        current_statement__ = 3;
        pos__ = 1;
        current_statement__ = 3;
        for (int sym1__ = 1; sym1__ <= n_met; ++sym1__) {
          current_statement__ = 3;
          assign(log10km, cons_list(index_uni(sym1__), nil_index_list()),
            log10km_flat__[(pos__ - 1)], "assigning variable log10km");
          current_statement__ = 3;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> log10kem;
      log10kem = Eigen::Matrix<double, -1, 1>(n_met);
      stan::math::fill(log10kem, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> log10kem_flat__;
        current_statement__ = 4;
        assign(log10kem_flat__, nil_index_list(),
          context__.vals_r("log10kem"), "assigning variable log10kem_flat__");
        current_statement__ = 4;
        pos__ = 1;
        current_statement__ = 4;
        for (int sym1__ = 1; sym1__ <= n_met; ++sym1__) {
          current_statement__ = 4;
          assign(log10kem, cons_list(index_uni(sym1__), nil_index_list()),
            log10kem_flat__[(pos__ - 1)], "assigning variable log10kem");
          current_statement__ = 4;
          pos__ = (pos__ + 1);}
      }
      std::vector<double> sigmaCGpred;
      sigmaCGpred = std::vector<double>(n_out, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 5;
      assign(sigmaCGpred, nil_index_list(), context__.vals_r("sigmaCGpred"),
        "assigning variable sigmaCGpred");
      std::vector<double> sigmaCGpred_free__;
      sigmaCGpred_free__ = std::vector<double>(n_out, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 5;
      for (int sym1__ = 1; sym1__ <= n_out; ++sym1__) {
        current_statement__ = 5;
        assign(sigmaCGpred_free__,
          cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(sigmaCGpred[(sym1__ - 1)], 0),
          "assigning variable sigmaCGpred_free__");}
      Eigen::Matrix<double, -1, 1> sigmaCmetpred;
      sigmaCmetpred = Eigen::Matrix<double, -1, 1>(n_met);
      stan::math::fill(sigmaCmetpred, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> sigmaCmetpred_flat__;
        current_statement__ = 6;
        assign(sigmaCmetpred_flat__, nil_index_list(),
          context__.vals_r("sigmaCmetpred"),
          "assigning variable sigmaCmetpred_flat__");
        current_statement__ = 6;
        pos__ = 1;
        current_statement__ = 6;
        for (int sym1__ = 1; sym1__ <= n_met; ++sym1__) {
          current_statement__ = 6;
          assign(sigmaCmetpred,
            cons_list(index_uni(sym1__), nil_index_list()),
            sigmaCmetpred_flat__[(pos__ - 1)],
            "assigning variable sigmaCmetpred");
          current_statement__ = 6;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> sigmaCmetpred_free__;
      sigmaCmetpred_free__ = Eigen::Matrix<double, -1, 1>(n_met);
      stan::math::fill(sigmaCmetpred_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 6;
      for (int sym1__ = 1; sym1__ <= n_met; ++sym1__) {
        current_statement__ = 6;
        assign(sigmaCmetpred_free__,
          cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(sigmaCmetpred[(sym1__ - 1)], 0),
          "assigning variable sigmaCmetpred_free__");}
      std::vector<double> gmax;
      gmax = std::vector<double>(gmax_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 7;
      assign(gmax, nil_index_list(), context__.vals_r("gmax"),
        "assigning variable gmax");
      std::vector<double> gmax_free__;
      gmax_free__ = std::vector<double>(gmax_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 7;
      for (int sym1__ = 1; sym1__ <= gmax_1dim__; ++sym1__) {
        current_statement__ = 7;
        assign(gmax_free__, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(gmax[(sym1__ - 1)], 0),
          "assigning variable gmax_free__");}
      std::vector<double> G0;
      G0 = std::vector<double>(G0_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 8;
      assign(G0, nil_index_list(), context__.vals_r("G0"),
        "assigning variable G0");
      std::vector<double> G0_free__;
      G0_free__ = std::vector<double>(G0_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 8;
      for (int sym1__ = 1; sym1__ <= G0_1dim__; ++sym1__) {
        current_statement__ = 8;
        assign(G0_free__, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(G0[(sym1__ - 1)], 0),
          "assigning variable G0_free__");}
      for (int sym1__ = 1; sym1__ <= n_exp; ++sym1__) {
        vars__.emplace_back(log10ku[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= n_out; ++sym1__) {
        vars__.emplace_back(log10ke[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= n_met; ++sym1__) {
        vars__.emplace_back(log10km[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= n_met; ++sym1__) {
        vars__.emplace_back(log10kem[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= n_out; ++sym1__) {
        vars__.emplace_back(sigmaCGpred_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= n_met; ++sym1__) {
        vars__.emplace_back(sigmaCmetpred_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= gmax_1dim__; ++sym1__) {
        vars__.emplace_back(gmax_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= G0_1dim__; ++sym1__) {
        vars__.emplace_back(G0_free__[(sym1__ - 1)]);}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("log10ku");
    names__.emplace_back("log10ke");
    names__.emplace_back("log10km");
    names__.emplace_back("log10kem");
    names__.emplace_back("sigmaCGpred");
    names__.emplace_back("sigmaCmetpred");
    names__.emplace_back("gmax");
    names__.emplace_back("G0");
    names__.emplace_back("ku");
    names__.emplace_back("ke");
    names__.emplace_back("km");
    names__.emplace_back("kem");
    names__.emplace_back("U");
    names__.emplace_back("M");
    names__.emplace_back("E");
    names__.emplace_back("R");
    names__.emplace_back("D");
    names__.emplace_back("CGpred");
    names__.emplace_back("Cmetpred");
    names__.emplace_back("CGobs_out");
    names__.emplace_back("Cmet_out");
    names__.emplace_back("Cexp_interpol");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(n_exp)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(n_out)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(n_met)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(n_met)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(n_out)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(n_met)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(gmax_1dim__)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(G0_1dim__)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(n_exp)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(n_out)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(n_met)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(n_met)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(lentp)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(lentp)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(n_met)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(lentp),
                                             static_cast<size_t>(n_out)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(lentp),
                                             static_cast<size_t>(n_met)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(lentp),
                                             static_cast<size_t>(n_out)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(lentp),
                                             static_cast<size_t>(n_met)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(len_vt),
                                             static_cast<size_t>(n_exp)});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= n_exp; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "log10ku" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= n_out; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "log10ke" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= n_met; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "log10km" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= n_met; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "log10kem" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= n_out; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "sigmaCGpred" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= n_met; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "sigmaCmetpred" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= gmax_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "gmax" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= G0_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "G0" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= n_exp; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "ku" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= n_out; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "ke" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= n_met; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "km" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= n_met; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "kem" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= lentp; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "U" + '.' + std::to_string(sym1__));
        }}
      param_names__.emplace_back(std::string() + "M");
      param_names__.emplace_back(std::string() + "E");
      for (int sym1__ = 1; sym1__ <= lentp; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "R" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= n_met; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "D" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= n_out; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= lentp; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "CGpred" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= n_met; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= lentp; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "Cmetpred" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= n_out; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= lentp; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "CGobs_out" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= n_met; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= lentp; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "Cmet_out" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= n_exp; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= len_vt; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "Cexp_interpol" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= n_exp; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "log10ku" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= n_out; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "log10ke" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= n_met; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "log10km" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= n_met; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "log10kem" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= n_out; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "sigmaCGpred" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= n_met; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "sigmaCmetpred" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= gmax_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "gmax" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= G0_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "G0" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= n_exp; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "ku" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= n_out; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "ke" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= n_met; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "km" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= n_met; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "kem" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= lentp; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "U" + '.' + std::to_string(sym1__));
        }}
      param_names__.emplace_back(std::string() + "M");
      param_names__.emplace_back(std::string() + "E");
      for (int sym1__ = 1; sym1__ <= lentp; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "R" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= n_met; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "D" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= n_out; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= lentp; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "CGpred" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= n_met; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= lentp; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "Cmetpred" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= n_out; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= lentp; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "CGobs_out" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= n_met; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= lentp; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "Cmet_out" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= n_exp; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= len_vt; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "Cexp_interpol" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"log10ku\",\"type\":{\"name\":\"vector\",\"length\":" << n_exp << "},\"block\":\"parameters\"},{\"name\":\"log10ke\",\"type\":{\"name\":\"vector\",\"length\":" << n_out << "},\"block\":\"parameters\"},{\"name\":\"log10km\",\"type\":{\"name\":\"vector\",\"length\":" << n_met << "},\"block\":\"parameters\"},{\"name\":\"log10kem\",\"type\":{\"name\":\"vector\",\"length\":" << n_met << "},\"block\":\"parameters\"},{\"name\":\"sigmaCGpred\",\"type\":{\"name\":\"array\",\"length\":" << n_out << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"sigmaCmetpred\",\"type\":{\"name\":\"vector\",\"length\":" << n_met << "},\"block\":\"parameters\"},{\"name\":\"gmax\",\"type\":{\"name\":\"array\",\"length\":" << gmax_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"G0\",\"type\":{\"name\":\"array\",\"length\":" << G0_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"ku\",\"type\":{\"name\":\"vector\",\"length\":" << n_exp << "},\"block\":\"transformed_parameters\"},{\"name\":\"ke\",\"type\":{\"name\":\"vector\",\"length\":" << n_out << "},\"block\":\"transformed_parameters\"},{\"name\":\"km\",\"type\":{\"name\":\"vector\",\"length\":" << n_met << "},\"block\":\"transformed_parameters\"},{\"name\":\"kem\",\"type\":{\"name\":\"vector\",\"length\":" << n_met << "},\"block\":\"transformed_parameters\"},{\"name\":\"U\",\"type\":{\"name\":\"vector\",\"length\":" << lentp << "},\"block\":\"transformed_parameters\"},{\"name\":\"M\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"E\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"R\",\"type\":{\"name\":\"vector\",\"length\":" << lentp << "},\"block\":\"transformed_parameters\"},{\"name\":\"D\",\"type\":{\"name\":\"vector\",\"length\":" << n_met << "},\"block\":\"transformed_parameters\"},{\"name\":\"CGpred\",\"type\":{\"name\":\"matrix\",\"rows\":" << lentp << ",\"cols\":" << n_out << "},\"block\":\"transformed_parameters\"},{\"name\":\"Cmetpred\",\"type\":{\"name\":\"matrix\",\"rows\":" << lentp << ",\"cols\":" << n_met << "},\"block\":\"transformed_parameters\"},{\"name\":\"CGobs_out\",\"type\":{\"name\":\"array\",\"length\":" << lentp << ",\"element_type\":{\"name\":\"array\",\"length\":" << n_out << ",\"element_type\":{\"name\":\"real\"}}},\"block\":\"generated_quantities\"},{\"name\":\"Cmet_out\",\"type\":{\"name\":\"array\",\"length\":" << lentp << ",\"element_type\":{\"name\":\"array\",\"length\":" << n_met << ",\"element_type\":{\"name\":\"real\"}}},\"block\":\"generated_quantities\"},{\"name\":\"Cexp_interpol\",\"type\":{\"name\":\"array\",\"length\":" << len_vt << ",\"element_type\":{\"name\":\"array\",\"length\":" << n_exp << ",\"element_type\":{\"name\":\"real\"}}},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"log10ku\",\"type\":{\"name\":\"vector\",\"length\":" << n_exp << "},\"block\":\"parameters\"},{\"name\":\"log10ke\",\"type\":{\"name\":\"vector\",\"length\":" << n_out << "},\"block\":\"parameters\"},{\"name\":\"log10km\",\"type\":{\"name\":\"vector\",\"length\":" << n_met << "},\"block\":\"parameters\"},{\"name\":\"log10kem\",\"type\":{\"name\":\"vector\",\"length\":" << n_met << "},\"block\":\"parameters\"},{\"name\":\"sigmaCGpred\",\"type\":{\"name\":\"array\",\"length\":" << n_out << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"sigmaCmetpred\",\"type\":{\"name\":\"vector\",\"length\":" << n_met << "},\"block\":\"parameters\"},{\"name\":\"gmax\",\"type\":{\"name\":\"array\",\"length\":" << gmax_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"G0\",\"type\":{\"name\":\"array\",\"length\":" << G0_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"ku\",\"type\":{\"name\":\"vector\",\"length\":" << n_exp << "},\"block\":\"transformed_parameters\"},{\"name\":\"ke\",\"type\":{\"name\":\"vector\",\"length\":" << n_out << "},\"block\":\"transformed_parameters\"},{\"name\":\"km\",\"type\":{\"name\":\"vector\",\"length\":" << n_met << "},\"block\":\"transformed_parameters\"},{\"name\":\"kem\",\"type\":{\"name\":\"vector\",\"length\":" << n_met << "},\"block\":\"transformed_parameters\"},{\"name\":\"U\",\"type\":{\"name\":\"vector\",\"length\":" << lentp << "},\"block\":\"transformed_parameters\"},{\"name\":\"M\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"E\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"R\",\"type\":{\"name\":\"vector\",\"length\":" << lentp << "},\"block\":\"transformed_parameters\"},{\"name\":\"D\",\"type\":{\"name\":\"vector\",\"length\":" << n_met << "},\"block\":\"transformed_parameters\"},{\"name\":\"CGpred\",\"type\":{\"name\":\"matrix\",\"rows\":" << lentp << ",\"cols\":" << n_out << "},\"block\":\"transformed_parameters\"},{\"name\":\"Cmetpred\",\"type\":{\"name\":\"matrix\",\"rows\":" << lentp << ",\"cols\":" << n_met << "},\"block\":\"transformed_parameters\"},{\"name\":\"CGobs_out\",\"type\":{\"name\":\"array\",\"length\":" << lentp << ",\"element_type\":{\"name\":\"array\",\"length\":" << n_out << ",\"element_type\":{\"name\":\"real\"}}},\"block\":\"generated_quantities\"},{\"name\":\"Cmet_out\",\"type\":{\"name\":\"array\",\"length\":" << lentp << ",\"element_type\":{\"name\":\"array\",\"length\":" << n_met << ",\"element_type\":{\"name\":\"real\"}}},\"block\":\"generated_quantities\"},{\"name\":\"Cexp_interpol\",\"type\":{\"name\":\"array\",\"length\":" << len_vt << ",\"element_type\":{\"name\":\"array\",\"length\":" << n_exp << ",\"element_type\":{\"name\":\"real\"}}},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_TK_namespace::model_TK;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_TK_namespace::profiles__;
}
#endif
#endif
