% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reactome_content.R
\name{rba_reactome_participant_of}
\alias{rba_reactome_participant_of}
\title{Get Larger Reactome Structures Which Include an Entity}
\usage{
rba_reactome_participant_of(entity_id, ...)
}
\arguments{
\item{entity_id}{Reactome's entity ID.}

\item{...}{rbioapi option(s). Refer to \code{\link{rba_options}}'s
arguments documentation for more information on available options.}
}
\value{
List of Reactome database Entities which Your provided ID is a
  participant in them.
}
\description{
This function will retrieve a list of complexes and sets that Your
  provided entity ID participates in (e.g. as a complex component,
  reaction output).
}
\section{Corresponding API Resources}{

 "GET https://reactome.org/ContentService/data/entity/{id}/componentOf"
}

\examples{
\donttest{
rba_reactome_participant_of(entity_id = "R-HSA-199420")
}

}
\references{
\itemize{
  \item Jassal B, Matthews L, Viteri G, Gong C, Lorente P, Fabregat A,
  Sidiropoulos K, Cook J, Gillespie M, Haw R, Loney F, May B, Milacic M,
  Rothfels K, Sevilla C, Shamovsky V, Shorser S, Varusai T, Weiser J, Wu G,
  Stein L, Hermjakob H, D'Eustachio P. The reactome pathway knowledgebase.
  Nucleic Acids Res. 2020 Jan 8;48(D1):D498-D503. doi: 10.1093/nar/gkz1031.
  PubMed PMID: 31691815.
  \item \href{https://reactome.org/ContentService/}{Reactome Content
  Services API Documentation}
  }
}
\seealso{
\code{\link{rba_reactome_participants}}

Other "Reactome Content Service - Physical Entity Queries": 
\code{\link{rba_reactome_complex_list}()},
\code{\link{rba_reactome_complex_subunits}()},
\code{\link{rba_reactome_entity_other_forms}()}
}
\concept{"Reactome Content Service - Physical Entity Queries"}
