% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reactome_content.R
\name{rba_reactome_xref}
\alias{rba_reactome_xref}
\title{Map Cross References IDs to Reactome ReferenceEntity}
\usage{
rba_reactome_xref(xref_id, ...)
}
\arguments{
\item{xref_id}{molecule's cross-reference (external) identifier.}

\item{...}{rbioapi option(s). Refer to \code{\link{rba_options}}'s
arguments documentation for more information on available options.}
}
\value{
List containing the ReferenceEntity corresponding to your
  provided cross-reference (external) ID.
}
\description{
Use this function To retrieve a list of Reactome ReferenceEntity associated
  to your provided Cross Reference (i.e. External) ID.
}
\details{
Reactome cross-references external database's identifiers to it's database
  Entries named ReferenceEntity, which resembles the invariant aspect of
  a molecule. Thus there is a one-to-many relationship between Reactome's
  ReferenceEntity object and the molecule's ID in external databases,
  which in Reactome's terms is called Cross Reference.
  \cr Refer to \code{\link{rba_reactome_participants}}'s "Details section"
  to learn more about how Reactome classifies molecules.
}
\section{Corresponding API Resources}{

 "GET https://reactome.org/ContentService/references/mapping/{identifier}"
}

\examples{
\donttest{
rba_reactome_xref("CD40")
}
\donttest{
rba_reactome_xref("ENSP00000361350")
}

}
\references{
\itemize{
  \item Jassal B, Matthews L, Viteri G, Gong C, Lorente P, Fabregat A,
  Sidiropoulos K, Cook J, Gillespie M, Haw R, Loney F, May B, Milacic M,
  Rothfels K, Sevilla C, Shamovsky V, Shorser S, Varusai T, Weiser J, Wu G,
  Stein L, Hermjakob H, D'Eustachio P. The reactome pathway knowledgebase.
  Nucleic Acids Res. 2020 Jan 8;48(D1):D498-D503. doi: 10.1093/nar/gkz1031.
  PubMed PMID: 31691815.
  \item \href{https://reactome.org/ContentService/}{Reactome Content
  Services API Documentation}
  }
}
\concept{"Reactome Content Service - ReferenceEntity Queries"}
