% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichr.R
\name{rba_enrichr_libs}
\alias{rba_enrichr_libs}
\title{Retrieve a List of available libraries from Enrichr}
\usage{
rba_enrichr_libs(store_in_options = FALSE, organism = "human", ...)
}
\arguments{
\item{store_in_options}{logical: (default = TRUE) Should a list of available
Enrichr libraries be saved as a global option?}

\item{organism}{(default = "human") Which model organism version of Enrichr
to use? Available options are: "human", (H. sapiens & M. musculus),
"fly" (D. melanogaster), "yeast" (S. cerevisiae), "worm" (C. elegans)
and "fish" (D. rerio).}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
A data frame with the names of available library in Enrichr and their
  statistics.
}
\description{
This function will retrieve a list of available libraries in Enrichr with
  their statistics. And by default, will save those names as a global option
  ("rba_enrichr_libs") to be available for other Enrichr functions that
  internally require the names of Enrichr libraries.
}
\details{
You should call this function once per R session with the argument
  'store_in_options = TRUE' before using \code{\link{rba_enrichr_enrich}}
  or \code{\link{rba_enrichr}}.
  \cr Nevertheless, rbioapi will do this for you in the background at the
  first time you call any function which requires this.
 \cr Note that using \code{\link{rba_enrichr}} is a more convenient way to
   automatically perform this and other required function calls to enrich
   your input gene-set.
}
\section{Corresponding API Resources}{

 "GET https://maayanlab.cloud/Enrichr/datasetStatistics"
}

\examples{
\donttest{
rba_enrichr_libs()
}

}
\references{
\itemize{
  \item Chen, E.Y., Tan, C.M., Kou, Y. et al. Enrichr: interactive and
  collaborative HTML5 gene list enrichment analysis tool. Bioinformatics
  14, 128 (2013). https://doi.org/10.1186/1471-2105-14-128
  \item Maxim V. Kuleshov, Matthew R. Jones, Andrew D. Rouillard, Nicolas
  F. Fernandez, Qiaonan Duan, Zichen Wang, Simon Koplev, Sherry L. Jenkins,
  Kathleen M. Jagodnik, Alexander Lachmann, Michael G. McDermott,
  Caroline D. Monteiro, Gregory W. Gundersen, Avi Ma’ayan, Enrichr: a
  comprehensive gene set enrichment analysis web server 2016 update,
  Nucleic Acids Research, Volume 44, Issue W1, 8 July 2016, Pages W90–W97,
  https://doi.org/10.1093/nar/gkw377
  \item Xie, Z., Bailey, A., Kuleshov, M. V., Clarke, D. J. B.,
  Evangelista, J. E., Jenkins, S. L., Lachmann, A., Wojciechowicz, M. L.,
  Kropiwnicki, E., Jagodnik, K. M., Jeon, M., & Ma’ayan, A. (2021). Gene
  set knowledge discovery with Enrichr. Current Protocols, 1, e90.
  doi: 10.1002/cpz1.90
  \item \href{https://maayanlab.cloud/Enrichr/help#api}{Enrichr API
  Documentation}
  \item \href{https://maayanlab.cloud/Enrichr/help#terms}{Citations note
  on Enrichr website}
  }
}
\seealso{
\code{\link{rba_enrichr}}

Other "Enrichr": 
\code{\link{rba_enrichr_add_list}()},
\code{\link{rba_enrichr_enrich}()},
\code{\link{rba_enrichr_gene_map}()},
\code{\link{rba_enrichr_view_list}()},
\code{\link{rba_enrichr}()}
}
\concept{"Enrichr"}
