% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reactome_content.R
\name{rba_reactome_event_ancestors}
\alias{rba_reactome_event_ancestors}
\title{Get Reactome Events Ancestors}
\usage{
rba_reactome_event_ancestors(event_id, ...)
}
\arguments{
\item{event_id}{Reactome event's identifier.}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
List which every element is a Data frame listing your supplied
  event along with it's ancestor events. Because any given event can be
  part of more than one pathway hierarchy, the list may contain multiple
  data frames.
}
\description{
Along with Reactome's events hierarchy, This function will retrieve all the
 events beginning from your supplied event up to the "Top level Pathway".
 see "Details section" for more information.
}
\details{
By Reactome's definition, Events are the building blocks of biological
  processes and could be of two main classes: "Pathway" or
  "Reaction-like events". The events are organized in a hierarchical
  structure; and each event could be child or parent to another event; The
  hierarchy will always begin with a "Top level pathway" event. Also note
  that a given event could be part of more that one hierarchies.
}
\section{Corresponding API Resources}{

 "GET https://reactome.org/ContentService/data/event/{id}/ancestors"
}

\examples{
\donttest{
rba_reactome_event_ancestors("R-HSA-5673001")
}

}
\references{
\itemize{
  \item Marc Gillespie, Bijay Jassal, Ralf Stephan, Marija Milacic, Karen
  Rothfels, Andrea Senff-Ribeiro, Johannes Griss, Cristoffer Sevilla, Lisa
  Matthews, Chuqiao Gong, Chuan Deng, Thawfeek Varusai, Eliot Ragueneau,
  Yusra Haider, Bruce May, Veronica Shamovsky, Joel Weiser, Timothy Brunson,
  Nasim Sanati, Liam Beckman, Xiang Shao, Antonio Fabregat, Konstantinos
  Sidiropoulos, Julieth Murillo, Guilherme Viteri, Justin Cook, Solomon
  Shorser, Gary Bader, Emek Demir, Chris Sander, Robin Haw, Guanming Wu,
  Lincoln Stein, Henning Hermjakob, Peter D’Eustachio, The reactome
  pathway knowledgebase 2022, Nucleic Acids Research, 2021;, kab1028,
  https://doi.org/10.1093/nar/gkab1028
  \item Griss J, Viteri G, Sidiropoulos K, Nguyen V, Fabregat A,
  Hermjakob H. ReactomeGSA - Efficient Multi-Omics Comparative Pathway
  Analysis. Mol Cell Proteomics. 2020 Sep 9. doi: 10.1074/mcp. PubMed
  PMID: 32907876.
  \item \href{https://reactome.org/ContentService/}{Reactome Content
  Services API Documentation}
  \item \href{https://reactome.org/cite/}{Citations note on Reactome website}
  }
}
\seealso{
Other "Reactome Content Service - Queries Related to Events": 
\code{\link{rba_reactome_event_hierarchy}()}
}
\concept{"Reactome Content Service - Queries Related to Events"}
