% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reactome_content.R
\name{rba_reactome_complex_subunits}
\alias{rba_reactome_complex_subunits}
\title{Get a Complex's Subunits}
\usage{
rba_reactome_complex_subunits(complex_id, exclude_structures = FALSE, ...)
}
\arguments{
\item{complex_id}{Reactome stable Identifier of the complex.}

\item{exclude_structures}{(logical) Should the contained complexes and
entity sets be excluded from the results? (default = FALSE)}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
Data frame which each row is a subunit of your supplied complex
and the columns are pertinent information of that subunit.
}
\description{
This function will return a list of subunits which are participants of
your supplied complex.
}
\details{
Subunits will be returned recursively; Which means that if a subunit was
  itself a complex, subunit of that complex will be also returned in the
  results.
}
\section{Corresponding API Resources}{

 "GET https://reactome.org/ContentService/data/complex/\{id\}/subunits"
}

\examples{
\donttest{
rba_reactome_complex_subunits(complex_id = "R-HSA-5674003",
    exclude_structures = FALSE)
}
\donttest{
rba_reactome_complex_subunits(complex_id = "R-HSA-109783",
    exclude_structures = TRUE)
}

}
\references{
\itemize{
  \item Marc Gillespie, Bijay Jassal, Ralf Stephan, Marija Milacic, Karen
  Rothfels, Andrea Senff-Ribeiro, Johannes Griss, Cristoffer Sevilla, Lisa
  Matthews, Chuqiao Gong, Chuan Deng, Thawfeek Varusai, Eliot Ragueneau,
  Yusra Haider, Bruce May, Veronica Shamovsky, Joel Weiser, Timothy Brunson,
  Nasim Sanati, Liam Beckman, Xiang Shao, Antonio Fabregat, Konstantinos
  Sidiropoulos, Julieth Murillo, Guilherme Viteri, Justin Cook, Solomon
  Shorser, Gary Bader, Emek Demir, Chris Sander, Robin Haw, Guanming Wu,
  Lincoln Stein, Henning Hermjakob, Peter D’Eustachio, The reactome
  pathway knowledgebase 2022, Nucleic Acids Research, 2021;, kab1028,
  https://doi.org/10.1093/nar/gkab1028
  \item Griss J, Viteri G, Sidiropoulos K, Nguyen V, Fabregat A,
  Hermjakob H. ReactomeGSA - Efficient Multi-Omics Comparative Pathway
  Analysis. Mol Cell Proteomics. 2020 Sep 9. doi: 10.1074/mcp. PubMed
  PMID: 32907876.
  \item \href{https://reactome.org/ContentService/}{Reactome Content
  Services API Documentation}
  \item \href{https://reactome.org/cite/}{Citations note on Reactome website}
  }
}
\seealso{
Other "Reactome Content Service - Physical Entity Queries": 
\code{\link{rba_reactome_complex_list}()},
\code{\link{rba_reactome_entity_other_forms}()},
\code{\link{rba_reactome_participant_of}()}
}
\concept{"Reactome Content Service - Physical Entity Queries"}
