% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichr.R
\name{rba_enrichr_enrich}
\alias{rba_enrichr_enrich}
\title{Get Enrichr Enrichment Results}
\usage{
rba_enrichr_enrich(
  user_list_id,
  gene_set_library = "all",
  regex_library_name = TRUE,
  organism = "human",
  background_id = NULL,
  progress_bar = TRUE,
  ...
)
}
\arguments{
\item{user_list_id}{An ID returned after uploading a gene list
using \code{\link{rba_enrichr_add_list}}, with the `speedrichr` set to
TRUE or FALSE depending on whether you intend to analyze this gene list
with or without a background gene list, respectively.}

\item{gene_set_library}{One of the:
\enumerate{
\item "all" to select all of the available Enrichr gene-set libraries.
\item A gene-set library name. You can retrieve the available options
for a given species using \code{\link{rba_enrichr_libs}}.
\item If regex_library_name = TRUE, A partially-matching name a regex
pattern that correspond to one or more of Enrichr library names.
}}

\item{regex_library_name}{logical: if TRUE (default) the supplied
gene_set_library will be considered as a regex pattern.
If FALSE, gene_set_library will be considered as an exact match.}

\item{organism}{(default = "human") Which model organism version of Enrichr
to use? Available options are: "human", (H. sapiens & M. musculus),
"fly" (D. melanogaster), "yeast" (S. cerevisiae), "worm" (C. elegans)
and "fish" (D. rerio). If `background_id` is provided, the only available
option is "human".}

\item{background_id}{An ID returned after uploading a background gene
list using \code{\link{rba_enrichr_add_background}}}

\item{progress_bar}{logical: (default = TRUE) if multiple Enrichr libraries
are selected, should a progress bar be displayed?}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
A list containing data frames of the enrichment results of your
  supplied gene-list against the selected Enrichr libraries.
}
\description{
This function retrieves enrichment analysis results for your supplied
  `user_list_id` against one or multiple Enrichr libraries.
}
\details{
If `background_id` is supplied, this function will interact with the
  speedrichr API. In this case, `user_list_id` must have been obtained
  from a \code{\link{rba_enrichr_add_list}} call with the `speedrichr`
  parameter set to `TRUE`. Additionally, this feature is only available
  for "human" organism.

Please note that \code{\link{rba_enrichr}} provides a one-step and
  more convenient way to automatically handle this and other required
  function calls needed to perform gene set enrichment analysis with Enrichr.
}
\section{Corresponding API Resources}{

 "GET https://maayanlab.cloud/Enrichr/enrich"
 \cr "POST https://maayanlab.cloud/speedrichr/api/backgroundenrich"
}

\examples{
\dontrun{
rba_enrichr_enrich(user_list_id = 11111)
}
\dontrun{
rba_enrichr_enrich(user_list_id = 11111,
    gene_set_library = "GO_Molecular_Function_2017",
    regex_library_name = FALSE)
}
\dontrun{
rba_enrichr_enrich(user_list_id = 11111,
    gene_set_library = "go",
    regex_library_name = TRUE)
}

}
\references{
\itemize{
  \item Chen, E.Y., Tan, C.M., Kou, Y. et al. Enrichr: interactive and
  collaborative HTML5 gene list enrichment analysis tool. Bioinformatics
  14, 128 (2013). https://doi.org/10.1186/1471-2105-14-128
  \item Maxim V. Kuleshov, Matthew R. Jones, Andrew D. Rouillard, Nicolas
  F. Fernandez, Qiaonan Duan, Zichen Wang, Simon Koplev, Sherry L. Jenkins,
  Kathleen M. Jagodnik, Alexander Lachmann, Michael G. McDermott,
  Caroline D. Monteiro, Gregory W. Gundersen, Avi Ma’ayan, Enrichr: a
  comprehensive gene set enrichment analysis web server 2016 update,
  Nucleic Acids Research, Volume 44, Issue W1, 8 July 2016, Pages W90–W97,
  https://doi.org/10.1093/nar/gkw377
  \item Xie, Z., Bailey, A., Kuleshov, M. V., Clarke, D. J. B.,
  Evangelista, J. E., Jenkins, S. L., Lachmann, A., Wojciechowicz, M. L.,
  Kropiwnicki, E., Jagodnik, K. M., Jeon, M., & Ma’ayan, A. (2021). Gene
  set knowledge discovery with Enrichr. Current Protocols, 1, e90.
  doi: 10.1002/cpz1.90
  \item \href{https://maayanlab.cloud/Enrichr/help#api}{Enrichr API
  Documentation}
  \item \href{https://maayanlab.cloud/Enrichr/help#terms}{Citations note
  on Enrichr website}
  }
}
\seealso{
\code{\link{rba_enrichr}}

Other "Enrichr": 
\code{\link{rba_enrichr}()},
\code{\link{rba_enrichr_add_background}()},
\code{\link{rba_enrichr_add_list}()},
\code{\link{rba_enrichr_gene_map}()},
\code{\link{rba_enrichr_libs}()},
\code{\link{rba_enrichr_view_list}()}
}
\concept{"Enrichr"}
