% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxa.rollup.r
\name{taxa.rollup}
\alias{taxa.rollup}
\title{Generate a matrix of samples by taxa, at the specified taxonomic rank.}
\usage{
taxa.rollup(biom, rank = "OTU", map = NULL, lineage = FALSE, sparse = FALSE)
}
\arguments{
\item{biom}{A \code{matrix}, \code{simple_triplet_matrix}, or \code{BIOM} 
object, as returned from \link{read.biom}. For matrices, the rows and 
columns are assumed to be the taxa and samples, respectively.}

\item{rank}{The taxonomic rank. E.g. \bold{\dQuote{OTU}}, 
\bold{\dQuote{Phylum}}, etc. May also be given numerically: 0 for
OTU, 1 for the highest level (i.e. Kingdom), and extending to the number
of taxonomic ranks encoded in the original biom file. See example below
to fetch the names of all available ranks.}

\item{map}{A character matrix defining the value that each taxa IDs is
assigned for each taxonomic rank. If \code{map=NULL} and \code{biom} is a
\code{BIOM} class object, the map will be automatically loaded from 
\code{biom$taxonomy}. \code{map} must not be \code{null} when \code{biom}
is a \code{matrix} or \code{simple_triplet_matrix}. See the example below
for an example of \code{map}'s structure.}

\item{lineage}{Include all ranks in the name of the taxa. For instance,
setting to \code{TRUE} will produce 
\code{Bacteria; Actinobacteria; Coriobacteriia; Coriobacteriales}. 
Whereas setting to \code{FALSE} (the default) will return simply
\code{Coriobacteriales}. You want to set this to TRUE if you have
genus names (such as \emph{Incertae_Sedis}) that map to multiple higher
level ranks.}

\item{sparse}{If true, returns a sparse matrix as described by 
\code{slam::simple_triplet_matrix}, otherwise returns a normal R
matrix object. Sparse matrices will likely be considerably more
memory efficient in this scenario.}
}
\value{
A numeric matrix with samples as column names, and taxonomic
    identifiers as row names.
}
\description{
Generate a matrix of samples by taxa, at the specified taxonomic rank.
}
\examples{
    library(rbiom)
    
    infile <- system.file("extdata", "hmp50.biom", package = "rbiom")
    biom <- read.biom(infile)
    
    colnames(biom$taxonomy)
    
    phyla <- taxa.rollup(biom, 'Phylum')
    phyla[1:4,1:6]
    
    # Custom matrices should be formatted like so:
    counts <- as.matrix(biom$counts)
    map    <- biom$taxonomy
    
    counts[1:3,1:6]
    map[1:3,1:4]
    
    phyla <- taxa.rollup(counts, 'Phylum', map=map)
    phyla[1:3,1:6]

}
