% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_data.R
\name{generate_data_single}
\alias{generate_data_single}
\title{Generate data for a single group}
\usage{
generate_data_single(pars_group, strategy_fun = NULL, distr_pars_ref = NULL)
}
\arguments{
\item{pars_group}{A \code{simul_pars} object as generated by \code{\link[=set_simul_pars]{set_simul_pars()}}. It specifies
the simulation parameters of the given group.}

\item{strategy_fun}{Function implementing trajectories after the intercurrent event (ICE).
Must be one of \code{\link[=getStrategies]{getStrategies()}}. See \code{\link[=getStrategies]{getStrategies()}} for details. If \code{NULL} then post-ICE
outcomes are untouched.}

\item{distr_pars_ref}{Optional. Named list containing the simulation parameters of the
reference arm. It contains the following elements:
\itemize{
\item \code{mu}: Numeric vector indicating the mean outcome trajectory assuming no ICEs. It should
include the outcome at baseline.
\item \code{sigma} Covariance matrix of the outcome trajectory assuming no ICEs.
If \code{NULL}, then these parameters are inherited from \code{pars_group}.
}}
}
\value{
A \code{data.frame} containing the simulated data. It includes the following variables:
\itemize{
\item \code{id}: Factor variable that specifies the id of each subject.
\item \code{visit}: Factor variable that specifies the visit of each assessment. Visit \code{0} denotes
the baseline visit.
\item \code{group}: Factor variable that specifies which treatment group each subject belongs to.
\item \code{outcome_bl}: Numeric variable that specifies the baseline outcome.
\item \code{outcome_noICE}: Numeric variable that specifies the longitudinal outcome assuming
no ICEs.
\item \code{ind_ice1}: Binary variable that takes value \code{1} if the corresponding visit is
affected by ICE1 and \code{0} otherwise.
\item \code{dropout_ice1}: Binary variable that takes value \code{1} if the corresponding visit is
affected by the drop-out following ICE1 and \code{0} otherwise.
\item \code{ind_ice2}: Binary variable that takes value \code{1} if the corresponding visit is affected
by ICE2.
\item \code{outcome}: Numeric variable that specifies the longitudinal outcome including ICE1, ICE2
and the intermittent missing values.
}
}
\description{
Generate data for a single group
}
\seealso{
\code{\link[=simulate_data]{simulate_data()}}.
}
