% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_title.R
\name{theme_title}
\alias{theme_title}
\title{Override theme parameters for general plot attributes}
\usage{
theme_title(fig, pars = NULL, background_fill_color = "white",
  background_fill_alpha = 1, border_fill_color = "white",
  border_fill_alpha = 1, text_align = "left", text_alpha = 1,
  text_baseline = "bottom", text_color = "#444444",
  text_font = "Helvetica", text_font_size = "12pt",
  text_font_style = "normal")
}
\arguments{
\item{fig}{figure to modify}

\item{pars}{optionally specify a named list of all parameters - useful when dealing with theme lists}

\item{background_fill_color}{(color) background color of plot}

\item{background_fill_alpha}{(numeric) background color alpha of plot}

\item{border_fill_color}{(color) fill color of border area of plot}

\item{border_fill_alpha}{(numeric) fill color alpha of border area of plot}

\item{text_align}{('left', 'right', 'center') The text align for the plot title.}

\item{text_alpha}{The text alpha for the plot title.}

\item{text_baseline}{('top', 'middle', 'bottom', 'alphabetic', 'hanging') The text baseline for the plot title.}

\item{text_color}{(color) The text color for the plot title.}

\item{text_font}{(string) The text font for the plot title.}

\item{text_font_size}{(string - e.g. '12pt') The text font size for the plot title.}

\item{text_font_style}{('normal', 'italic', 'bold') The text font style for the plot title.}
}
\description{
Override theme parameters for general plot attributes
}
\examples{
figure(title = "asdf") \%>\%
  ly_points(1:10) \%>\%
  theme_title(text_color = "red")
}

