% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output_gist.R
\name{widget2gist}
\alias{widget2gist}
\title{Export htmlwidget plot to a gist}
\usage{
widget2gist(
  widget_string,
  name,
  created = NULL,
  description = "",
  license = c("none", "apache-2.0", "bsd-2-clause", "bsd-3-clause", "cc-by-4.0",
    "cc-by-nc-4.0", "cc-by-nc-nd-4.0", "cc-by-nc-sa-4.0", "cc-by-nd-4.0", "cc-by-sa-4.0",
    "cddl-1.0", "epl-1.0", "gpl-2.0", "gpl-3.0", "lgpl-2.1", "lgpl-3.0", "mit",
    "mpl-2.0"),
  border = TRUE,
  scrolling = FALSE,
  secure = TRUE,
  view = TRUE
)
}
\arguments{
\item{widget_string}{a string containing R code to create an htmlwidget}

\item{name}{name of the gist}

\item{created}{optional string for a "Created by" to preceed the README}

\item{description}{optional text to go in README.md to describe the gist}

\item{license}{license under which gist is released - one of those accepted here: \url{https://bl.ocks.org/licenses.txt}}

\item{border}{should the bl.ocks.org iframe have a border?}

\item{scrolling}{should the bl.ocks.org iframe scroll?}

\item{secure}{should https be used for cdn links?}

\item{view}{should the resulting gist be opened in the browser on bl.ocks.org?}
}
\description{
Export htmlwidget plot to a gist
}
\note{
This requires that you have a github personal access token stored as an environment variable \code{GITHUB_PAT}.  See \code{\link[gistr]{gist_create}} for more information.

Also note that this currently can't handle thumbnails but we are looking into ways to do that.
}
\examples{
\dontrun{
widget2gist("figure() \%>\% ly_points(1:10)", name = "test")
}
}
