% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/row_col_from_zenith_azimuth.R
\name{row_col_from_zenith_azimuth}
\alias{row_col_from_zenith_azimuth}
\title{Row and col numbers from zenith and azimuth angles}
\usage{
row_col_from_zenith_azimuth(z, za, lens_coef)
}
\arguments{
\item{z}{\linkS4class{SpatRaster} built with \code{\link{zenith_image}}.}

\item{za}{Numeric vector of length two. Zenith and azimuth angles in degrees.}

\item{lens_coef}{Numeric vector. Polynomial coefficients of the lens
projection function.}
}
\value{
Numeric vector of length two.
}
\description{
Row and col numbers from zenith and azimuth angles
}
\examples{
z <- zenith_image(1000, lens())
row_col_from_zenith_azimuth(z, c(45, 270), lens())
}
\seealso{
Other HSP Functions: 
\code{\link{read_manual_input}()},
\code{\link{read_opt_sky_coef}()},
\code{\link{write_sky_points}()},
\code{\link{write_sun_coord}()},
\code{\link{zenith_azimuth_from_row_col}()}
}
\concept{HSP Functions}
