% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot.CalSPD}
\alias{plot.CalSPD}
\title{Plot a summed probability distribution}
\usage{
\method{plot}{CalSPD}(x, runm = NA, calendar = "BP",
  type = "standard", xlim = NA, ylim = NA,
  ylab = "Summed Probability", spdnormalised = FALSE,
  rescale = FALSE, fill.p = "grey75", border.p = NA, xaxt = "s",
  yaxt = "s", add = FALSE, ...)
}
\arguments{
\item{x}{A \code{CalSPD} class object.}

\item{runm}{A number indicating the window size of the moving average to smooth the SPD. If set to \code{NA} no moving average is applied. Default is NA}

\item{calendar}{Either \code{'BP'} or \code{'BCAD'}. Indicate whether the calibrated date should be displayed in BP or BC/AD. Default is  \code{'BP'}.}

\item{type}{Either \code{'standard'} or \code{'simple'}. The former visualise the SPD as an area graph, while the latter as line chart.}

\item{xlim}{the x limits of the plot. In BP or in BC/AD depending on the choice of the parameter \code{calender}. Notice that if BC/AD is selected BC ages should have a minus sign (e.g. \code{c(-5000,200)} for 5000 BC to 200 AD).}

\item{ylim}{the y limits of the plot.}

\item{ylab}{(optional) Label for the y axis. If unspecified the default setting will be applied ("Summed Probability")}

\item{spdnormalised}{A logical variable indicating whether the total probability mass of the SPD is normalised to sum to unity.}

\item{rescale}{A logical variable indicating whether the SPD should be rescaled to range 0 to 1.}

\item{fill.p}{Fill colour for the SPD}

\item{border.p}{Border colour for the SPD}

\item{xaxt}{Whether the x-axis tick marks should be displayed (\code{xaxt='s'}, default) or not (\code{xaxt='n'}).}

\item{yaxt}{Whether the y-axis tick marks should be displayed (\code{xaxt='s'}, default) or not (\code{xaxt='n'}).}

\item{add}{Whether or not the new graphic should be added to an existing plot.}

\item{...}{Additional arguments affecting the plot}
}
\description{
Plot a summed probability distribution (SPD) of radiocarbon dates
}
\examples{
\dontrun{
data(emedyd)
levant <- emedyd[emedyd$Region=="1"|emedyd$Region=="2",]
bins <- binPrep(levant$SiteName, levant$CRA, h=50)
x <- calibrate(levant$CRA, levant$Error, normalised=FALSE)
spd.levant <- spd(x, bins=bins, timeRange=c(17000,8000))
spd.northernlevant <- spd(x[levant$Region=="2"], bins=bins[levant$Region=="2"],
timeRange=c(17000,8000))
plot(spd.levant, runm=50, xlim=c(16000,9000))
plot(spd.northernlevant, runm=50, add=TRUE, fill.p="black")
legend("topleft", legend=c("All Levant dates","Northern Levant only"), 
fill=c("grey75","black"), border=NA)
plot(spd.levant, runm=50, xlim=c(16000,9000), type="simple")
plot(spd.northernlevant, runm=50, col="red", type="simple", add=TRUE)
}
}
\seealso{
\code{\link{spd}}; \code{\link{plot.CalGrid}}
}
