% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibration.R
\name{uncalibrate}
\alias{uncalibrate}
\alias{uncalibrate.default}
\alias{uncalibrate.CalGrid}
\title{Uncalibrate (back-calibrate) a calibrated radiocarbon date (or summed probability distribution).}
\usage{
uncalibrate(x, ...)

\method{uncalibrate}{default}(x, CRAerrors = 0, roundyear = TRUE, calCurves = "intcal20", ...)

\method{uncalibrate}{CalGrid}(
  x,
  calCurves = "intcal20",
  eps = 1e-05,
  compact = TRUE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{x}{Either a vector of calibrated radiocarbon ages or an object of class CalGrid.}

\item{...}{ignored}

\item{CRAerrors}{A vector of standard deviations corresponding to each estimated radiocarbon age (ignored if x is a CalGrid object).}

\item{roundyear}{An optional vector of IDs for each date (ignored if x is a CalGrid object).}

\item{calCurves}{A string naming a calibration curve already provided with the rcarbon package (currently 'intcal20','intcal13','intcal13nhpine16','shcal20','shcal13','shcal13shkauri16',''marine13','marine20' and 'normal') or a custom curve provided as matrix/data.frame in three columns ("CALBP","C14BP","Error"). The default is the 'intcal20' curve and only one curve can currently be specified for all dates.}

\item{eps}{Cut-off value for density calculation (for CalGrid objects only).}

\item{compact}{A logical variable indicating whether only uncalibrated ages with non-zero probabilities should be returned (for CalGrid objects only).}

\item{verbose}{A logical variable indicating whether extra information on progress should be reported (for CalGrid objects only).}
}
\value{
A data.frame with specifying the original data, the uncalibrated age without the calibration curve error (ccCRA), the calibration curve error at this point in the curve (ccError), a randomised uncalibrated age (rCRA) given both the stated ccError and any further hypothesised instrumental error provided by the CRAerrors argument (rError).
}
\description{
Function for uncalibrating one or more radiocarbon dates.
}
\details{
This function takes one or more calibrated calendars and looks-up the corresponding uncalibrated age, error of the stated calibration curve at that point. It also provides a randomised estimate of the uncalibrate age based on the curve error (and optionally also a hypothetical measurement error.
}
\examples{
# Uncalibrate two calendar dates
uncalibrate(c(3050,2950))
}
