% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exceed_threshold.R
\name{exceed_threshold}
\alias{exceed_threshold}
\title{Check if transformation/coercing of a vector is good enaough}
\usage{
exceed_threshold(original, transformed, threshold = 0.9, force = FALSE,
  ask = FALSE, var_name = "the input vector")
}
\arguments{
\item{original}{the original vector}

\item{transformed}{the transformed vector with NA-values for non transformed values}

\item{threshold}{is a numeric value in [0,1] specifying the proportion of cells in \code{transformed} that should be recognised as correctly coerced to accept the new class. 
This does not effect the function output (except when \code{force = TRUE}) 
but will have some diagnostic benefits.}

\item{force}{Should a candidate vector (candidate according to \code{threshold}) be forced to its suggested class (with non-coercable elements set to NA). 
\code{FALSE} by default but if the function is called interactivelly, the user will also have the option to set force = TRUE on the fly.}

\item{ask}{this argument gives you the chance to interactively inspect your data and specify if a column is a date or not,
on the fly. This is \code{FALSE} by default for \code{as.Dates.default} but \code{TRUE} for  
\code{as.Dates.dataframe}. It only applies when the function is runed interactively and only when \code{force == FALSE}.}

\item{var_name}{a name for the object to be used in messages (you could probably just leave this as default, NULL; it is mostly used for internal purposes!).}
}
\value{
Either \code{original} or \code{transformed}.
}
\description{
This function is primarly aimed to check if the transformation of a  vector was 
succesfull enough to return the transformed value instead of the original.
}
\examples{

x <- c(rep("2012-01-01", 9), "foo")
exceed_threshold(x, as.Date(x))
exceed_threshold(x, as.Date(x), force = TRUE)
exceed_threshold(x, as.Date(x), ask = TRUE)
exceed_threshold(x, as.Date(x), threshold = 1)
exceed_threshold(x, as.Date(x), var_name = "bar", force = TRUE)

x <- c(1:9, "baz")
exceed_threshold(x, suppressWarnings(as.numeric(x)))
}

