/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.applications.jchempaint.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class TextViewDialog
extends JDialog {
    private static final long serialVersionUID = -1900643115385413976L;
    private JTextArea textArea;
    private JLabel textCaption;

    public TextViewDialog(JFrame fr, String title) {
        this(fr, title, null);
    }

    public TextViewDialog(JFrame fr, String title, Dimension dim) {
        this(fr, title, dim, true);
    }

    public TextViewDialog(JFrame fr, String title, Dimension dim, boolean wrap) {
        this(fr, title, dim, wrap, 20, 60);
    }

    public TextViewDialog(JFrame fr, String title, Dimension dim, boolean wrap, int width, int height) {
        super(fr, title, true);
        this.textArea = new JTextArea(width, height);
        this.textArea.setEditable(false);
        if (wrap) {
            this.textArea.setLineWrap(wrap);
            this.textArea.setWrapStyleWord(true);
        }
        JScrollPane scroller = new JScrollPane();
        if (dim != null) {
            scroller.setPreferredSize(dim);
        } else {
            scroller.setPreferredSize(new Dimension(400, 200));
        }
        scroller.getViewport().add(this.textArea);
        JPanel textViewer = new JPanel(new BorderLayout());
        textViewer.add((Component)scroller, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        JButton ok = new JButton("OK");
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TextViewDialog.this.OKPressed();
            }
        });
        buttonPanel.add(ok);
        this.getRootPane().setDefaultButton(ok);
        JPanel container = new JPanel();
        container.setLayout(new BorderLayout());
        container.validate();
        this.textCaption = new JLabel("");
        container.add((Component)this.textCaption, "North");
        container.add((Component)textViewer, "Center");
        container.add((Component)buttonPanel, "South");
        this.getContentPane().add(container);
        this.pack();
    }

    public void OKPressed() {
        this.setVisible(false);
    }

    public void setText(String text) {
        this.textArea.setText(text);
    }

    public void setMessage(String caption, String text) {
        this.textCaption.setText(caption);
        this.textArea.setText(text);
    }
}

