/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.bspt;

import org.jmol.bspt.Bspt;
import org.jmol.bspt.Element;
import org.jmol.bspt.Leaf;
import org.jmol.bspt.Tuple;
import org.jmol.util.Logger;

class Node
extends Element {
    int dim;
    float minLeft;
    float maxLeft;
    Element eleLeft;
    float minRight;
    float maxRight;
    Element eleRight;

    Node(Bspt bspt, int level, Leaf leafLeft) {
        this.bspt = bspt;
        if (level == bspt.treeDepth) {
            bspt.treeDepth = level + 1;
            if (bspt.treeDepth >= 100) {
                Logger.error("BSPT tree depth too great:" + bspt.treeDepth);
            }
        }
        if (leafLeft.count != 2) {
            throw new NullPointerException();
        }
        this.dim = level % bspt.dimMax;
        leafLeft.sort(this.dim);
        Leaf leafRight = new Leaf(bspt, leafLeft, 1);
        this.minLeft = leafLeft.tuples[0].getDimensionValue(this.dim);
        this.maxLeft = leafLeft.tuples[leafLeft.count - 1].getDimensionValue(this.dim);
        this.minRight = leafRight.tuples[0].getDimensionValue(this.dim);
        this.maxRight = leafRight.tuples[leafRight.count - 1].getDimensionValue(this.dim);
        this.eleLeft = leafLeft;
        this.eleRight = leafRight;
        this.count = 2;
    }

    Element addTuple(int level, Tuple tuple) {
        float dimValue = tuple.getDimensionValue(this.dim);
        ++this.count;
        boolean addLeft = dimValue < this.maxLeft ? true : (dimValue > this.minRight ? false : (dimValue == this.maxLeft ? (dimValue == this.minRight ? this.eleLeft.count < this.eleRight.count : true) : (dimValue == this.minRight ? false : this.eleLeft.count < this.eleRight.count)));
        if (addLeft) {
            if (dimValue < this.minLeft) {
                this.minLeft = dimValue;
            } else if (dimValue > this.maxLeft) {
                this.maxLeft = dimValue;
            }
            this.eleLeft = this.eleLeft.addTuple(level + 1, tuple);
        } else {
            if (dimValue < this.minRight) {
                this.minRight = dimValue;
            } else if (dimValue > this.maxRight) {
                this.maxRight = dimValue;
            }
            this.eleRight = this.eleRight.addTuple(level + 1, tuple);
        }
        return this;
    }
}

