/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import org.jmol.g3d.Graphics3D;
import org.jmol.viewer.Atom;
import org.jmol.viewer.Shape;

class Halos
extends Shape {
    short[] mads;
    short[] colixes;

    Halos() {
    }

    void setSize(int size, BitSet bsSelected) {
        Atom[] atoms = this.frame.atoms;
        int i = this.frame.atomCount;
        while (--i >= 0) {
            if (!bsSelected.get(i)) continue;
            if (this.mads == null) {
                this.mads = new short[this.frame.atomCount];
            }
            Atom atom = atoms[i];
            this.mads[i] = atom.convertEncodedMad(size);
        }
    }

    void setProperty(String propertyName, Object value, BitSet bs) {
        int atomCount = this.frame.atomCount;
        Atom[] atoms = this.frame.atoms;
        if ("color" == propertyName) {
            short colix = Graphics3D.getColix(value);
            int i = atomCount;
            while (--i >= 0) {
                if (!bs.get(i)) continue;
                if (this.colixes == null) {
                    this.colixes = new short[atomCount];
                }
                this.colixes[i] = colix != 3 ? colix : this.viewer.getColixAtomPalette(atoms[i], (String)value);
            }
            return;
        }
        if ("translucency" == propertyName) {
            return;
        }
    }

    void setVisibilityFlags() {
        BitSet bsSelected = this.viewer.getSelectionHaloEnabled() ? this.viewer.getSelectionSet() : null;
        int i = this.frame.atomCount;
        while (--i >= 0) {
            Atom atom = this.frame.atoms[i];
            boolean isVisible = bsSelected != null && bsSelected.get(i) || this.mads != null && this.mads[i] != 0;
            atom.setShapeVisibility(this.myVisibilityFlag, isVisible);
        }
    }

    void setModelClickability() {
        if (this.mads == null) {
            return;
        }
        int i = this.frame.atomCount;
        while (--i >= 0) {
            Atom atom = this.frame.atoms[i];
            if ((atom.shapeVisibilityFlags & this.myVisibilityFlag) != 0) continue;
            atom.clickabilityFlags |= this.myVisibilityFlag;
        }
    }
}

