/*
 * Decompiled with CFR 0.152.
 */
package org.guha.rcdk.view;

import java.awt.Container;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.JFrame;
import org.guha.rcdk.util.Misc;
import org.guha.rcdk.view.panels.JmolPanel;
import org.jmol.api.JmolViewer;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.ChemFile;
import org.openscience.cdk.ChemModel;
import org.openscience.cdk.ChemSequence;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.Molecule;
import org.openscience.cdk.MoleculeSet;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.interfaces.IMoleculeSet;

public class ViewMolecule3D {
    JmolPanel jmolPanel;
    IAtomContainer molecule = null;
    String filename = null;
    static final String strScript = "";

    public ViewMolecule3D(IAtomContainer molecule) {
        this.molecule = molecule;
    }

    public ViewMolecule3D(String filename) {
        this.filename = filename;
    }

    public void show() {
        JFrame frame = new JFrame("Molecule Viewer");
        frame.addWindowListener(new ApplicationCloser());
        Container contentPane = frame.getContentPane();
        this.jmolPanel = new JmolPanel();
        contentPane.add(this.jmolPanel);
        frame.setSize(300, 300);
        frame.setVisible(true);
        JmolViewer viewer = this.jmolPanel.getViewer();
        this.setScript("set loglevel 4");
        if (this.molecule != null) {
            MoleculeSet moleculeSet = new MoleculeSet();
            moleculeSet.addMolecule((IMolecule)new Molecule(this.molecule));
            ChemModel model = new ChemModel();
            model.setMoleculeSet((IMoleculeSet)moleculeSet);
            ChemSequence sequence = new ChemSequence();
            sequence.addChemModel((IChemModel)model);
            ChemFile chemFile = new ChemFile();
            chemFile.addChemSequence((IChemSequence)sequence);
            viewer.openClientFile(strScript, strScript, (Object)chemFile);
        } else if (this.filename != null) {
            // empty if block
        }
        String strError = viewer.getOpenFileError();
        if (strError != null) {
            System.out.println(strError);
        }
    }

    public void setScript(String script) {
        JmolViewer viewer = this.jmolPanel.getViewer();
        viewer.evalString(script);
    }

    public static void main(String[] args) {
        try {
            IAtomContainer[] acs = Misc.loadMolecules(new String[]{"/home/rajarshi/src/Rrepo/trunk/rcdk/data/dan007.hin"}, true, true, true);
            AtomContainer ac = (AtomContainer)DefaultChemObjectBuilder.getInstance().newAtomContainer(acs[0]);
            ViewMolecule3D vm3d = new ViewMolecule3D((IAtomContainer)ac);
            vm3d.show();
        }
        catch (CDKException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static class ApplicationCloser
    extends WindowAdapter {
        ApplicationCloser() {
        }

        public void windowClosing(WindowEvent e) {
        }
    }
}

