/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.libio.cml;

import java.util.Iterator;
import java.util.Map;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.ParentNode;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.libio.cml.ICMLCustomizer;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.result.BooleanResult;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleResult;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.qsar.result.IntegerArrayResult;
import org.openscience.cdk.qsar.result.IntegerResult;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.element.CMLArray;
import org.xmlcml.cml.element.CMLMetadata;
import org.xmlcml.cml.element.CMLMetadataList;
import org.xmlcml.cml.element.CMLProperty;
import org.xmlcml.cml.element.CMLPropertyList;
import org.xmlcml.cml.element.CMLScalar;

public class QSARCustomizer
implements ICMLCustomizer {
    private static final String QSAR_NAMESPACE = "qsar";
    private static final String QSAR_URI = "http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/";

    @Override
    public void customize(IBond bond, Object nodeToAdd) throws Exception {
        this.customizeIChemObject(bond, nodeToAdd);
    }

    @Override
    public void customize(IAtom atom, Object nodeToAdd) throws Exception {
        this.customizeIChemObject(atom, nodeToAdd);
    }

    @Override
    public void customize(IAtomContainer molecule, Object nodeToAdd) throws Exception {
        this.customizeIChemObject(molecule, nodeToAdd);
    }

    private Element createScalar(IDescriptorResult value) {
        CMLElement scalar = null;
        if (value instanceof DoubleResult) {
            scalar = new CMLScalar();
            scalar.addAttribute(new Attribute("dataType", "xsd:double"));
            scalar.appendChild("" + ((DoubleResult)value).doubleValue());
        } else if (value instanceof IntegerResult) {
            scalar = new CMLScalar();
            scalar.addAttribute(new Attribute("dataType", "xsd:int"));
            scalar.appendChild("" + ((IntegerResult)value).intValue());
        } else if (value instanceof BooleanResult) {
            scalar = new CMLScalar();
            scalar.addAttribute(new Attribute("dataType", "xsd:boolean"));
            scalar.appendChild("" + ((BooleanResult)value).booleanValue());
        } else if (value instanceof IntegerArrayResult) {
            IntegerArrayResult result = (IntegerArrayResult)value;
            scalar = new CMLArray();
            scalar.addAttribute(new Attribute("dataType", "xsd:int"));
            scalar.addAttribute(new Attribute("size", "" + result.length()));
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < result.length(); ++i) {
                buffer.append(result.get(i) + " ");
            }
            scalar.appendChild(buffer.toString());
        } else if (value instanceof DoubleArrayResult) {
            DoubleArrayResult result = (DoubleArrayResult)value;
            scalar = new CMLArray();
            scalar.addAttribute(new Attribute("dataType", "xsd:double"));
            scalar.addAttribute(new Attribute("size", "" + result.length()));
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < result.length(); ++i) {
                buffer.append(result.get(i) + " ");
            }
            scalar.appendChild(buffer.toString());
        } else {
            scalar.appendChild(((Object)value).toString());
        }
        return scalar;
    }

    private void customizeIChemObject(IChemObject object, Object nodeToAdd) throws Exception {
        if (!(nodeToAdd instanceof Element)) {
            throw new CDKException("NodeToAdd must be of type nu.xom.Element!");
        }
        Element element = (Element)nodeToAdd;
        Map<Object, Object> props = object.getProperties();
        Iterator<Object> keys = props.keySet().iterator();
        CMLPropertyList propList = null;
        while (keys.hasNext()) {
            Object key = keys.next();
            if (!(key instanceof DescriptorSpecification)) continue;
            DescriptorSpecification specs = (DescriptorSpecification)key;
            DescriptorValue value = (DescriptorValue)props.get(key);
            IDescriptorResult result = value.getValue();
            if (propList == null) {
                propList = new CMLPropertyList();
            }
            CMLProperty property = new CMLProperty();
            CMLMetadataList metadataList = new CMLMetadataList();
            ((Element)metadataList).addNamespaceDeclaration(QSAR_NAMESPACE, QSAR_URI);
            ((Element)property).addAttribute(new Attribute("convention", "qsar:DescriptorValue"));
            String specsRef = specs.getSpecificationReference();
            if (specsRef.startsWith(QSAR_URI)) {
                ((Element)property).addNamespaceDeclaration(QSAR_NAMESPACE, QSAR_URI);
            }
            CMLMetadata metaData = new CMLMetadata();
            metaData.addAttribute(new Attribute("dictRef", "qsar:specificationReference"));
            metaData.addAttribute(new Attribute("content", specsRef));
            ((ParentNode)metadataList).appendChild(metaData);
            metaData = new CMLMetadata();
            metaData.addAttribute(new Attribute("dictRef", "qsar:implementationTitle"));
            metaData.addAttribute(new Attribute("content", specs.getImplementationTitle()));
            ((ParentNode)metadataList).appendChild(metaData);
            metaData = new CMLMetadata();
            metaData.addAttribute(new Attribute("dictRef", "qsar:implementationIdentifier"));
            metaData.addAttribute(new Attribute("content", specs.getImplementationIdentifier()));
            ((ParentNode)metadataList).appendChild(metaData);
            metaData = new CMLMetadata();
            metaData.addAttribute(new Attribute("dictRef", "qsar:implementationVendor"));
            metaData.addAttribute(new Attribute("content", specs.getImplementationVendor()));
            ((ParentNode)metadataList).appendChild(metaData);
            Object[] params = value.getParameters();
            if (params != null && params.length > 0) {
                String[] paramNames = value.getParameterNames();
                CMLMetadataList paramSettings = new CMLMetadataList();
                ((Element)paramSettings).addAttribute(new Attribute("title", "qsar:descriptorParameters"));
                for (int i = 0; i < params.length; ++i) {
                    CMLMetadata paramSetting = new CMLMetadata();
                    String paramName = paramNames[i];
                    Object paramVal = params[i];
                    if (paramName == null || paramVal == null) continue;
                    ((Element)paramSetting).addAttribute(new Attribute("title", paramNames[i]));
                    ((Element)paramSetting).addAttribute(new Attribute("content", params[i].toString()));
                    ((ParentNode)paramSettings).appendChild(paramSetting);
                }
                ((ParentNode)metadataList).appendChild(paramSettings);
            }
            ((ParentNode)property).appendChild(metadataList);
            Element scalar = this.createScalar(result);
            scalar.addAttribute(new Attribute("dictRef", specsRef));
            ((ParentNode)property).appendChild(scalar);
            ((ParentNode)propList).appendChild(property);
        }
        if (propList != null) {
            element.appendChild(propList);
        }
    }
}

