/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators;

import java.awt.Color;
import javax.vecmath.Point2d;
import javax.vecmath.Vector2d;
import org.openscience.cdk.geometry.GeometryTools;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.elements.ElementGroup;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.elements.path.PathBuilder;
import org.openscience.cdk.renderer.generators.BasicAtomGenerator;
import org.openscience.cdk.renderer.generators.BasicSceneGenerator;
import org.openscience.cdk.renderer.generators.HighlightAtomGenerator;
import org.openscience.cdk.renderer.generators.IGenerator;

public class MergeAtomsGenerator
extends BasicAtomGenerator
implements IGenerator<IAtomContainer> {
    private boolean isNAN(Point2d ... point) {
        for (Point2d p : point) {
            if (!Double.isNaN(p.x) && !Double.isNaN(p.y)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IRenderingElement generate(IAtomContainer ac, RendererModel model) {
        ElementGroup selectionElements = new ElementGroup();
        double mergeDistance = (Double)model.getParameter(HighlightAtomGenerator.HighlightAtomDistance.class).getValue();
        double radius = mergeDistance / (Double)model.getParameter(BasicSceneGenerator.Scale.class).getValue();
        radius /= 2.0;
        for (IAtom atom : model.getMerge().keySet()) {
            Point2d p1 = atom.getPoint2d();
            Point2d p2 = model.getMerge().get(atom).getPoint2d();
            if (this.isNAN(p1, p2)) break;
            PathBuilder pb = new PathBuilder();
            pb.color(Color.RED);
            Vector2d vec = new Vector2d();
            vec.sub(p2, p1);
            Vector2d per = GeometryTools.calculatePerpendicularUnitVector((Point2d)p1, (Point2d)p2);
            if (vec.lengthSquared() < 1.0E-6) {
                vec = new Vector2d(radius, 0.0);
                per = new Vector2d(0.0, radius);
            } else {
                per.scale(radius);
            }
            Vector2d per2 = new Vector2d();
            per2.scale(-1.0, per);
            Vector2d v1 = new Vector2d(vec);
            Vector2d v2 = new Vector2d();
            v1.normalize();
            v1.scale(radius);
            v2.scale(-1.0, v1);
            Point2d f1 = new Point2d();
            Point2d f2 = new Point2d();
            Point2d f3 = new Point2d();
            Point2d s1 = new Point2d();
            Point2d s2 = new Point2d();
            Point2d s3 = new Point2d();
            f1.add(p1, per);
            f2.add(p1, v2);
            f3.add(p1, per2);
            s1.add(p2, per2);
            s2.add(p2, v1);
            s3.add(p2, per);
            pb.moveTo(f1).quadTo(f2, f3).lineTo(s1).quadTo(s2, s3).close();
            selectionElements.add(pb.createPath());
        }
        return selectionElements;
    }
}

