/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.selection;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.vecmath.Point2d;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.elements.RectangleElement;
import org.openscience.cdk.renderer.selection.ShapeSelection;

public class RectangleSelection
extends ShapeSelection {
    private Rectangle2D rectangle = new Rectangle2D.Double();

    @Override
    public IRenderingElement generate(Color color) {
        return new RectangleElement(this.rectangle.getMinX(), this.rectangle.getMinY(), this.rectangle.getMaxX(), this.rectangle.getMaxY(), color);
    }

    @Override
    public boolean contains(Point2d p) {
        return this.rectangle.contains(p.x, p.y);
    }

    @Override
    public void addPoint(Point2d p) {
        if (this.rectangle.getHeight() == 0.0 && this.rectangle.getWidth() == 0.0) {
            this.rectangle = new Rectangle2D.Double(p.x, p.y, 1.0, 1.0);
        } else if (this.rectangle.contains(new Point2D.Double(p.x, p.y))) {
            double x = this.rectangle.getX();
            double y = this.rectangle.getY();
            this.rectangle.setRect(x, y, p.x - x, p.y - y);
        } else {
            this.rectangle.add(new Point2D.Double(p.x, p.y));
        }
    }

    @Override
    public boolean isEmpty() {
        return this.rectangle.isEmpty();
    }

    @Override
    public void reset() {
        this.finished = true;
        this.rectangle.setRect(this.rectangle.getX(), this.rectangle.getY(), 0.0, 0.0);
    }
}

