/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.formula;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IIsotope;

@TestClass(value="org.openscience.cdk.formula.MolecularFormulaRangeTest")
public class MolecularFormulaRange
implements Cloneable {
    private Map<IIsotope, Integer> isotopesMax = new HashMap<IIsotope, Integer>();
    private Map<IIsotope, Integer> isotopesMin = new HashMap<IIsotope, Integer>();

    @TestMethod(value="testAddIsotope_IIsotope_int_int")
    public void addIsotope(IIsotope isotope, int countMin, int countMax) {
        boolean flag = false;
        for (IIsotope thisIsotope : this.isotopes()) {
            if (!this.isTheSame(thisIsotope, isotope)) continue;
            this.isotopesMax.put(thisIsotope, countMax);
            this.isotopesMin.put(thisIsotope, countMin);
            flag = true;
            break;
        }
        if (!flag) {
            this.isotopesMax.put(isotope, countMax);
            this.isotopesMin.put(isotope, countMin);
        }
    }

    @TestMethod(value="testContains_IIsotope")
    public boolean contains(IIsotope isotope) {
        for (IIsotope thisIsotope : this.isotopes()) {
            if (!this.isTheSame(thisIsotope, isotope)) continue;
            return true;
        }
        return false;
    }

    @TestMethod(value="testGetIsotopeCountMax_IIsotope")
    public int getIsotopeCountMax(IIsotope isotope) {
        return !this.contains(isotope) ? -1 : this.isotopesMax.get(this.getIsotope(isotope));
    }

    @TestMethod(value="testGetIsotopeCountMin_IIsotope")
    public int getIsotopeCountMin(IIsotope isotope) {
        return !this.contains(isotope) ? -1 : this.isotopesMin.get(this.getIsotope(isotope));
    }

    @TestMethod(value="testGetIsotopeCount")
    public int getIsotopeCount() {
        return this.isotopesMax.size();
    }

    private IIsotope getIsotope(IIsotope isotope) {
        for (IIsotope thisIsotope : this.isotopes()) {
            if (!this.isTheSame(isotope, thisIsotope)) continue;
            return thisIsotope;
        }
        return null;
    }

    @TestMethod(value="testIsotopes")
    public Iterable<IIsotope> isotopes() {
        return new Iterable<IIsotope>(){

            @Override
            public Iterator<IIsotope> iterator() {
                return MolecularFormulaRange.this.isotopesMax.keySet().iterator();
            }
        };
    }

    @TestMethod(value="testRemoveAllIsotopes")
    public void removeAllIsotopes() {
        this.isotopesMax.clear();
        this.isotopesMin.clear();
    }

    @TestMethod(value="testRemoveIsotope_IIsotope")
    public void removeIsotope(IIsotope isotope) {
        this.isotopesMax.remove(this.getIsotope(isotope));
        this.isotopesMin.remove(this.getIsotope(isotope));
    }

    @TestMethod(value="testClone")
    public Object clone() throws CloneNotSupportedException {
        MolecularFormulaRange clone = new MolecularFormulaRange();
        for (IIsotope isotope : this.isotopes()) {
            clone.addIsotope((IIsotope)isotope.clone(), this.getIsotopeCountMin(isotope), this.getIsotopeCountMax(isotope));
        }
        return clone;
    }

    private boolean isTheSame(IIsotope isotopeOne, IIsotope isotopeTwo) {
        if (isotopeOne.getSymbol() != isotopeTwo.getSymbol()) {
            return false;
        }
        if (isotopeOne.getNaturalAbundance() != isotopeTwo.getNaturalAbundance()) {
            return false;
        }
        return isotopeOne.getExactMass() == isotopeTwo.getExactMass();
    }
}

