/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.controller.edit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openscience.cdk.controller.Changed;
import org.openscience.cdk.controller.edit.IEdit;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;

public abstract class AbstractEdit
implements IEdit {
    protected IAtomContainer model;
    private Collection<IAtom> atomsToUpdate;

    static Set<Changed> changed(Changed ... changed) {
        List<Changed> ch = Arrays.asList(changed);
        HashSet<Changed> changes = new HashSet<Changed>();
        changes.addAll(ch);
        return changes;
    }

    void updateHydrogenCount(Collection<IAtom> atomsToUpdate) {
        if (this.atomsToUpdate == null) {
            this.atomsToUpdate = new ArrayList<IAtom>();
        }
        this.atomsToUpdate = atomsToUpdate;
    }

    void updateHydrogenCount(IBond bond) {
        this.updateHydrogenCount(bond.getAtom(0), bond.getAtom(1));
    }

    void updateHydrogenCount(IAtom ... atoms) {
        this.updateHydrogenCount(Arrays.asList(atoms));
    }

    @Override
    public Collection<IAtom> getAtomsToUpdate() {
        if (this.atomsToUpdate == null) {
            return Collections.emptySet();
        }
        return this.atomsToUpdate;
    }

    @Override
    public void execute(IAtomContainer ac) {
        this.model = ac;
        this.redo();
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }
}

