/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.visitor;

import java.awt.geom.AffineTransform;
import org.openscience.cdk.renderer.elements.ElementGroup;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.elements.IRenderingVisitor;
import org.openscience.cdk.renderer.elements.LineElement;
import org.openscience.cdk.renderer.elements.OvalElement;
import org.openscience.cdk.renderer.elements.TextElement;
import org.openscience.cdk.renderer.elements.WedgeLineElement;

public class PrintVisitor
implements IRenderingVisitor {
    private int depth = 0;

    public void visitElementGroup(ElementGroup elementGroup) {
        ++this.depth;
        System.out.println("Group");
        elementGroup.visitChildren(this);
        --this.depth;
    }

    public void visitLine(LineElement lineElement) {
        System.out.println("Line [" + lineElement.x1 + " " + lineElement.y1 + "]-[" + lineElement.x2 + " " + lineElement.y2 + "]");
    }

    public void visitOval(OvalElement ovalElement) {
        System.out.println("Oval [" + ovalElement.x + "," + ovalElement.y + " " + ovalElement.radius + "]");
    }

    public void visitText(TextElement textElement) {
        System.out.println("Text " + textElement.text);
    }

    public void visitWedge(WedgeLineElement wedgeElement) {
        System.out.println("Wedge");
    }

    @Override
    public void visit(IRenderingElement element) {
        if (element instanceof ElementGroup) {
            this.visitElementGroup((ElementGroup)element);
        } else if (element instanceof LineElement) {
            this.visitLine((LineElement)element);
        } else if (element instanceof OvalElement) {
            this.visitOval((OvalElement)element);
        } else if (element instanceof TextElement) {
            this.visitText((TextElement)element);
        } else {
            System.err.println("Visitor method for " + element.getClass().getName() + " is not implemented");
        }
    }

    @Override
    public void setTransform(AffineTransform transform) {
    }
}

