/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.formula;

import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.formula.IsotopeContainer;
import org.openscience.cdk.formula.IsotopePattern;

@TestClass(value="org.openscience.cdk.formula.IsotopePatternManipulatorTest")
public class IsotopePatternManipulator {
    @TestMethod(value="testNormalize_IsotopePattern")
    public static IsotopePattern normalize(IsotopePattern isotopeP) {
        IsotopeContainer isoHighest = null;
        double biggestAbundance = 0.0;
        for (IsotopeContainer isoContainer : isotopeP.getIsotopes()) {
            double abundance = isoContainer.getIntensity();
            if (!(biggestAbundance < abundance)) continue;
            biggestAbundance = abundance;
            isoHighest = isoContainer;
        }
        IsotopePattern isoNormalized = new IsotopePattern();
        for (IsotopeContainer isoContainer : isotopeP.getIsotopes()) {
            double inten = isoContainer.getIntensity() / isoHighest.getIntensity();
            try {
                IsotopeContainer icClone = (IsotopeContainer)isoContainer.clone();
                icClone.setIntensity(inten);
                if (isoHighest.equals(isoContainer)) {
                    isoNormalized.setMonoIsotope(icClone);
                    continue;
                }
                isoNormalized.addIsotope(icClone);
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }
        isoNormalized.setCharge(isotopeP.getCharge());
        return isoNormalized;
    }

    @TestMethod(value="testSortAndNormalizedByIntensity_IsotopePattern")
    public static IsotopePattern sortAndNormalizedByIntensity(IsotopePattern isotopeP) {
        IsotopePattern isoNorma = IsotopePatternManipulator.normalize(isotopeP);
        return IsotopePatternManipulator.sortByIntensity(isoNorma);
    }

    @TestMethod(value="testSortByIntensity_IsotopePattern")
    public static IsotopePattern sortByIntensity(IsotopePattern isotopeP) {
        try {
            int length;
            IsotopePattern isoSort = new IsotopePattern();
            List<IsotopeContainer> listISO = ((IsotopePattern)isotopeP.clone()).getIsotopes();
            for (int i = length = listISO.size() - 1; i >= 0; --i) {
                double intensity = 0.0;
                IsotopeContainer isoHighest = null;
                for (IsotopeContainer isoContainer : listISO) {
                    if (!(isoContainer.getIntensity() > intensity)) continue;
                    isoHighest = isoContainer;
                    intensity = isoContainer.getIntensity();
                }
                if (i == length) {
                    isoSort.setMonoIsotope((IsotopeContainer)isoHighest.clone());
                } else {
                    isoSort.addIsotope((IsotopeContainer)isoHighest.clone());
                }
                listISO.remove(isoHighest);
            }
            isoSort.setCharge(isotopeP.getCharge());
            return isoSort;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    @TestMethod(value="testSortByMass_IsotopePattern")
    public static IsotopePattern sortByMass(IsotopePattern isotopeP) {
        try {
            int length;
            IsotopePattern isoSort = new IsotopePattern();
            List<IsotopeContainer> listISO = ((IsotopePattern)isotopeP.clone()).getIsotopes();
            for (int i = length = listISO.size() - 1; i >= 0; --i) {
                double mass = 100000.0;
                IsotopeContainer isoHighest = null;
                for (IsotopeContainer isoContainer : listISO) {
                    if (!(isoContainer.getMass() < mass)) continue;
                    isoHighest = isoContainer;
                    mass = isoContainer.getMass();
                }
                if (i == length) {
                    isoSort.setMonoIsotope((IsotopeContainer)isoHighest.clone());
                } else {
                    isoSort.addIsotope((IsotopeContainer)isoHighest.clone());
                }
                listISO.remove(isoHighest);
            }
            isoSort.setCharge(isotopeP.getCharge());
            return isoSort;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }
}

