/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.structgen.stochastic.operator;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.math.RandomNumbersTool;
import org.openscience.cdk.structgen.stochastic.PartialFilledStructureMerger;
import org.openscience.cdk.structgen.stochastic.operator.ChemGraph;
import org.openscience.cdk.tools.SaturationChecker;

public class CrossoverMachine {
    PartialFilledStructureMerger pfsm = new PartialFilledStructureMerger();
    int splitMode = 2;
    int numatoms = 5;
    public static final int SPLIT_MODE_RADNDOM = 0;
    public static final int SPLIT_MODE_DEPTH_FIRST = 1;
    public static final int SPLIT_MODE_BREADTH_FIRST = 2;

    public List<IAtomContainer> doCrossover(IAtomContainer dad, IAtomContainer mom) throws CDKException {
        int tries = 0;
        do {
            int j;
            int j2;
            int j3;
            int j4;
            int dim = dad.getAtomCount();
            IAtomContainer[] redChild = new IAtomContainer[2];
            IAtomContainer[] blueChild = new IAtomContainer[2];
            List<Object> redAtoms = new ArrayList<Integer>();
            ArrayList<Integer> blueAtoms = new ArrayList<Integer>();
            if (this.splitMode == 0) {
                int i;
                for (i = 0; i < dim; ++i) {
                    redAtoms.add(i);
                }
                for (i = 0; i < dim - this.numatoms; ++i) {
                    int ranInt = RandomNumbersTool.randomInt(0, redAtoms.size() - 1);
                    redAtoms.remove((Object)ranInt);
                    blueAtoms.add(ranInt);
                }
            } else {
                ChemGraph graph = new ChemGraph(dad);
                graph.setNumAtoms(this.numatoms);
                redAtoms = this.splitMode == 1 ? graph.pickDFgraph() : graph.pickBFgraph();
                for (int i = 0; i < dim; ++i) {
                    Integer element = i;
                    if (redAtoms.contains(element)) continue;
                    blueAtoms.add(element);
                }
            }
            redChild[0] = dad.getBuilder().newInstance(IAtomContainer.class, dad);
            blueChild[0] = dad.getBuilder().newInstance(IAtomContainer.class, dad);
            redChild[1] = dad.getBuilder().newInstance(IAtomContainer.class, mom);
            blueChild[1] = dad.getBuilder().newInstance(IAtomContainer.class, mom);
            ArrayList<IAtom> blueAtomsInRedChild0 = new ArrayList<IAtom>();
            for (j4 = 0; j4 < blueAtoms.size(); ++j4) {
                blueAtomsInRedChild0.add(redChild[0].getAtom((Integer)blueAtoms.get(j4)));
            }
            for (j4 = 0; j4 < blueAtomsInRedChild0.size(); ++j4) {
                redChild[0].removeAtomAndConnectedElectronContainers((IAtom)blueAtomsInRedChild0.get(j4));
            }
            ArrayList<IAtom> blueAtomsInRedChild1 = new ArrayList<IAtom>();
            for (j3 = 0; j3 < blueAtoms.size(); ++j3) {
                blueAtomsInRedChild1.add(redChild[1].getAtom((Integer)blueAtoms.get(j3)));
            }
            for (j3 = 0; j3 < blueAtomsInRedChild1.size(); ++j3) {
                redChild[1].removeAtomAndConnectedElectronContainers((IAtom)blueAtomsInRedChild1.get(j3));
            }
            ArrayList<IAtom> redAtomsInBlueChild0 = new ArrayList<IAtom>();
            for (j2 = 0; j2 < redAtoms.size(); ++j2) {
                redAtomsInBlueChild0.add(blueChild[0].getAtom((Integer)redAtoms.get(j2)));
            }
            for (j2 = 0; j2 < redAtomsInBlueChild0.size(); ++j2) {
                blueChild[0].removeAtomAndConnectedElectronContainers((IAtom)redAtomsInBlueChild0.get(j2));
            }
            ArrayList<IAtom> redAtomsInBlueChild1 = new ArrayList<IAtom>();
            for (j = 0; j < redAtoms.size(); ++j) {
                redAtomsInBlueChild1.add(blueChild[1].getAtom((Integer)redAtoms.get(j)));
            }
            for (j = 0; j < redAtomsInBlueChild1.size(); ++j) {
                blueChild[1].removeAtomAndConnectedElectronContainers((IAtom)redAtomsInBlueChild1.get(j));
            }
            SaturationChecker satCheck = new SaturationChecker();
            double red1attachpoints = 0.0;
            for (int i = 0; i < redChild[0].getAtomCount(); ++i) {
                red1attachpoints += satCheck.getCurrentMaxBondOrder(redChild[0].getAtom(i), redChild[0]);
            }
            double red2attachpoints = 0.0;
            for (int i = 0; i < redChild[1].getAtomCount(); ++i) {
                red2attachpoints += satCheck.getCurrentMaxBondOrder(redChild[1].getAtom(i), redChild[1]);
            }
            boolean isok = true;
            if (red1attachpoints % 2.0 == 1.0 ^ red2attachpoints % 2.0 == 1.0) {
                isok = false;
                IAtomContainer firstToBalance = redChild[1];
                IAtomContainer secondToBalance = blueChild[0];
                if (red1attachpoints % 2.0 == 1.0) {
                    firstToBalance = redChild[0];
                    secondToBalance = blueChild[1];
                }
                for (IAtom atom : firstToBalance.atoms()) {
                    if (satCheck.getCurrentMaxBondOrder(atom, firstToBalance) % 2.0 != 1.0 || firstToBalance.getBondOrderSum(atom) % 2.0 != 0.0) continue;
                    firstToBalance.removeAtomAndConnectedElectronContainers(atom);
                    secondToBalance.addAtom(atom);
                    isok = true;
                    break;
                }
            }
            if (!isok) continue;
            IAtomContainerSet[] newstrucs = new IAtomContainerSet[2];
            newstrucs[0] = dad.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
            newstrucs[0].add(ConnectivityChecker.partitionIntoMolecules(redChild[0]));
            newstrucs[0].add(ConnectivityChecker.partitionIntoMolecules(blueChild[1]));
            newstrucs[1] = dad.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
            newstrucs[1].add(ConnectivityChecker.partitionIntoMolecules(redChild[1]));
            newstrucs[1].add(ConnectivityChecker.partitionIntoMolecules(blueChild[0]));
            ArrayList<IAtomContainer> children = new ArrayList<IAtomContainer>(2);
            for (int f = 0; f < 2; ++f) {
                try {
                    children.add(f, this.pfsm.generate(newstrucs[f]));
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (children.size() != 2 || !ConnectivityChecker.isConnected((IAtomContainer)children.get(0)) || !ConnectivityChecker.isConnected((IAtomContainer)children.get(1))) continue;
            return children;
        } while (++tries <= 20);
        throw new CDKException("Could not mate these properly");
    }
}

