/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.layout;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.Vector;
import javax.vecmath.Point2d;
import javax.vecmath.Vector2d;
import org.openscience.cdk.geometry.GeometryUtil;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

@Deprecated
public class OverlapResolver {
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(OverlapResolver.class);
    int maxSteps = 10000;

    public double resolveOverlap(IAtomContainer ac, IRingSet sssr) {
        Vector overlappingAtoms = new Vector();
        Vector overlappingBonds = new Vector();
        logger.debug("Start of resolveOverlap");
        double overlapScore = this.getOverlapScore(ac, overlappingAtoms, overlappingBonds);
        if (overlapScore > 0.0) {
            overlapScore = this.displace(ac, overlappingAtoms, overlappingBonds);
        }
        logger.debug("overlapScore = " + overlapScore);
        logger.debug("End of resolveOverlap");
        return overlapScore;
    }

    public double displace(IAtomContainer ac, Vector overlappingAtoms, Vector overlappingBonds) {
        double bondLength = GeometryUtil.getBondLengthAverage(ac);
        OverlapPair op = null;
        IAtom a1 = null;
        IAtom a2 = null;
        Vector2d v1 = null;
        Vector2d v2 = null;
        int steps = 0;
        int p = 0;
        double overlapScore = 0.0;
        double choice = 0.0;
        logger.debug("We are here because of an overlap situation.");
        do {
            p = (int)(Math.random() * (double)overlappingAtoms.size());
            logger.debug("Taking overlap pair no. " + p);
            op = (OverlapPair)overlappingAtoms.elementAt(p);
            a1 = (IAtom)op.chemObject1;
            a2 = (IAtom)op.chemObject2;
            v1 = new Vector2d(a1.getPoint2d());
            v2 = new Vector2d(a2.getPoint2d());
            v2.sub(v1);
            v2.normalize();
            if (Double.isNaN(v2.x)) {
                v2.x = 0.01;
            }
            if (Double.isNaN(v2.y)) {
                v2.y = 0.01;
            }
            v2.scale(bondLength / 20.0);
            logger.debug("Calculation translation vector " + v2);
            choice = Math.random();
            if (choice > 0.5) {
                a2.getPoint2d().add(v2);
                logger.debug("Random variable: " + choice + ", displacing first atom");
                continue;
            }
            a1.getPoint2d().sub(v2);
            logger.debug("Random variable: " + choice + ", displacing second atom");
        } while ((overlapScore = this.getOverlapScore(ac, overlappingAtoms, overlappingBonds)) > 0.0 && ++steps <= this.maxSteps);
        if (steps < 100) {
            logger.debug("Overlap situation resolved");
            logger.debug("Overlap score: " + overlapScore);
            logger.debug(steps + " steps needed to clear situation");
        } else {
            logger.debug("Could not resolve overlap situation");
            logger.debug("Number of " + steps + " steps taken exceeds limit of " + this.maxSteps);
            logger.debug("Overlap score: " + overlapScore);
        }
        return overlapScore;
    }

    public double getOverlapScore(IAtomContainer ac, Vector overlappingAtoms, Vector overlappingBonds) {
        double overlapScore = 0.0;
        overlapScore = this.getAtomOverlapScore(ac, overlappingAtoms);
        return overlapScore;
    }

    public double getAtomOverlapScore(IAtomContainer ac, Vector overlappingAtoms) {
        overlappingAtoms.removeAllElements();
        IAtom atom1 = null;
        IAtom atom2 = null;
        Point2d p1 = null;
        Point2d p2 = null;
        double distance = 0.0;
        double overlapScore = 0.0;
        double bondLength = GeometryUtil.getBondLengthAverage(ac);
        double overlapCutoff = bondLength / 4.0;
        logger.debug("Bond length is set to " + bondLength);
        logger.debug("Now cyling through all pairs of atoms");
        for (int f = 0; f < ac.getAtomCount(); ++f) {
            atom1 = ac.getAtom(f);
            p1 = atom1.getPoint2d();
            for (int g = f + 1; g < ac.getAtomCount(); ++g) {
                atom2 = ac.getAtom(g);
                p2 = atom2.getPoint2d();
                distance = p1.distance(p2);
                if (!(distance < overlapCutoff)) continue;
                logger.debug("Detected atom clash with distance: " + distance + ", which is smaller than overlapCutoff " + overlapCutoff);
                overlapScore += overlapCutoff;
                overlappingAtoms.addElement(new OverlapPair(atom1, atom2));
            }
        }
        return overlapScore;
    }

    public double getBondOverlapScore(IAtomContainer ac, Vector overlappingBonds) {
        overlappingBonds.removeAllElements();
        double overlapScore = 0.0;
        IBond bond1 = null;
        IBond bond2 = null;
        double bondLength = GeometryUtil.getBondLengthAverage(ac);
        double overlapCutoff = bondLength / 2.0;
        for (int f = 0; f < ac.getBondCount(); ++f) {
            bond1 = ac.getBond(f);
            for (int g = f; g < ac.getBondCount(); ++g) {
                bond2 = ac.getBond(g);
                if (bond1.isConnectedTo(bond2) || !this.areIntersected(bond1, bond2)) continue;
                overlapScore += overlapCutoff;
                overlappingBonds.addElement(new OverlapPair(bond1, bond2));
            }
        }
        return overlapScore;
    }

    public boolean areIntersected(IBond bond1, IBond bond2) {
        double x1 = 0.0;
        double x2 = 0.0;
        double x3 = 0.0;
        double x4 = 0.0;
        double y1 = 0.0;
        double y2 = 0.0;
        double y3 = 0.0;
        double y4 = 0.0;
        x1 = bond1.getAtom((int)0).getPoint2d().x;
        y1 = bond1.getAtom((int)0).getPoint2d().y;
        x2 = bond1.getAtom((int)1).getPoint2d().x;
        y2 = bond1.getAtom((int)1).getPoint2d().y;
        Line2D.Double line1 = new Line2D.Double(new Point2D.Double(x1, y1), new Point2D.Double(x2, y2));
        x3 = bond2.getAtom((int)0).getPoint2d().x;
        y3 = bond2.getAtom((int)0).getPoint2d().y;
        x4 = bond2.getAtom((int)1).getPoint2d().x;
        y4 = bond2.getAtom((int)1).getPoint2d().y;
        Line2D.Double line2 = new Line2D.Double(new Point2D.Double(x3, y3), new Point2D.Double(x4, y4));
        if (line1.intersectsLine(line2)) {
            logger.debug("Two intersecting bonds detected.");
            return true;
        }
        return false;
    }

    public class OverlapPair {
        IChemObject chemObject1 = null;
        IChemObject chemObject2 = null;

        public OverlapPair(IChemObject co1, IChemObject co2) {
            this.chemObject1 = co1;
            this.chemObject2 = co2;
        }
    }
}

