/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import java.util.ArrayList;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.qsar.AbstractMolecularDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleResult;
import org.openscience.cdk.qsar.result.DoubleResultType;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.tools.IonizationPotentialTool;
import org.openscience.cdk.tools.LonePairElectronChecker;

@Deprecated
public class IPMolecularLearningDescriptor
extends AbstractMolecularDescriptor
implements IMolecularDescriptor {
    private boolean addlp = true;
    private static final String[] names = new String[]{"MolIP"};

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#ip", this.getClass().getName(), "The Chemistry Development Kit");
    }

    @Override
    public void setParameters(Object[] params) throws CDKException {
        if (params.length != 1) {
            throw new CDKException("One parameter expected");
        }
        if (!(params[0] instanceof Boolean)) {
            throw new CDKException("Boolean parameter expected");
        }
        this.addlp = (Boolean)params[0];
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.addlp};
    }

    @Override
    public String[] getDescriptorNames() {
        return names;
    }

    @Override
    public DescriptorValue calculate(IAtomContainer atomContainer) {
        DoubleResult value;
        IAtomContainer local;
        if (this.addlp) {
            try {
                local = atomContainer.clone();
                LonePairElectronChecker lpcheck = new LonePairElectronChecker();
                lpcheck.saturate(local);
            }
            catch (CloneNotSupportedException e) {
                return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(Double.NaN), this.getDescriptorNames(), e);
            }
            catch (CDKException e) {
                return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(Double.NaN), this.getDescriptorNames(), e);
            }
        } else {
            local = atomContainer;
        }
        try {
            value = new DoubleResult(((DoubleArrayResult)this.calculatePlus(local).getValue()).get(0));
        }
        catch (CDKException e) {
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(Double.NaN), this.getDescriptorNames(), e);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), value, this.getDescriptorNames());
    }

    public DescriptorValue calculatePlus(IAtomContainer container) throws CDKException {
        double value;
        ArrayList<Double> dar = new ArrayList<Double>();
        for (IAtom atom : container.atoms()) {
            value = IonizationPotentialTool.predictIP(container, atom);
            if (value == 0.0) continue;
            dar.add(value);
        }
        for (IBond bond : container.bonds()) {
            if (!(bond.getOrder() == IBond.Order.DOUBLE & bond.getAtom(0).getSymbol().equals("C") & bond.getAtom(1).getSymbol().equals("C")) || (value = IonizationPotentialTool.predictIP(container, bond)) == 0.0) continue;
            dar.add(value);
        }
        DoubleArrayResult results = this.arrangingEnergy(dar);
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), results, this.getDescriptorNames(), null);
    }

    private DoubleArrayResult arrangingEnergy(ArrayList<Double> array) {
        DoubleArrayResult results = new DoubleArrayResult();
        int count = array.size();
        for (int i = 0; i < count; ++i) {
            double min = array.get(0);
            int pos = 0;
            for (int j = 0; j < array.size(); ++j) {
                double value = array.get(j);
                if (!(value < min)) continue;
                min = value;
                pos = j;
            }
            array.remove(pos);
            results.add(min);
        }
        return results;
    }

    @Override
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleResultType();
    }

    @Override
    public String[] getParameterNames() {
        return new String[]{"addlp"};
    }

    @Override
    public Object getParameterType(String name) {
        return this.addlp;
    }
}

