/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators.standard;

import java.awt.Color;
import java.awt.Font;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Point2d;
import javax.vecmath.Vector2d;
import org.openscience.cdk.geometry.GeometryUtil;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.elements.ElementGroup;
import org.openscience.cdk.renderer.elements.GeneralPath;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.elements.MarkedElement;
import org.openscience.cdk.renderer.generators.BasicSceneGenerator;
import org.openscience.cdk.renderer.generators.standard.AtomSymbol;
import org.openscience.cdk.renderer.generators.standard.HydrogenPosition;
import org.openscience.cdk.renderer.generators.standard.StandardAtomGenerator;
import org.openscience.cdk.renderer.generators.standard.StandardGenerator;
import org.openscience.cdk.renderer.generators.standard.TextOutline;
import org.openscience.cdk.renderer.generators.standard.VecmathUtil;
import org.openscience.cdk.sgroup.Sgroup;
import org.openscience.cdk.sgroup.SgroupBracket;
import org.openscience.cdk.sgroup.SgroupKey;
import org.openscience.cdk.sgroup.SgroupType;

final class StandardSgroupGenerator {
    public static final double EQUIV_THRESHOLD = 0.1;
    private final double stroke;
    private final double scale;
    private final double bracketDepth;
    private final Font font;
    private final Color foreground;
    private final double labelScale;
    private final StandardAtomGenerator atomGenerator;
    private final RendererModel parameters;

    private StandardSgroupGenerator(RendererModel parameters, StandardAtomGenerator atomGenerator, double stroke, Font font, Color foreground) {
        this.font = font;
        this.scale = (Double)parameters.get(BasicSceneGenerator.Scale.class);
        this.stroke = stroke;
        double length = (Double)parameters.get(BasicSceneGenerator.BondLength.class) / this.scale;
        this.bracketDepth = (Double)parameters.get(StandardGenerator.SgroupBracketDepth.class) * length;
        this.labelScale = (Double)parameters.get(StandardGenerator.SgroupFontScale.class);
        this.foreground = foreground;
        this.atomGenerator = atomGenerator;
        this.parameters = parameters;
    }

    static IRenderingElement generate(RendererModel parameters, double stroke, Font font, Color foreground, StandardAtomGenerator atomGenerator, AtomSymbol[] symbols, IAtomContainer container) {
        return new StandardSgroupGenerator(parameters, atomGenerator, stroke, font, foreground).generateSgroups(container, symbols);
    }

    static void prepareDisplayShortcuts(IAtomContainer container, Map<IAtom, String> symbolRemap) {
        List sgroups = (List)container.getProperty("cdk:CtabSgroups");
        if (sgroups == null || sgroups.isEmpty()) {
            return;
        }
        for (Sgroup sgroup : sgroups) {
            if (sgroup.getType() == SgroupType.CtabAbbreviation) {
                Boolean expansion = (Boolean)sgroup.getValue(SgroupKey.CtabExpansion);
                if (expansion != null && expansion == Boolean.TRUE || sgroup.getSubscript() == null || sgroup.getSubscript().isEmpty() || !StandardSgroupGenerator.checkAbbreviationHighlight(container, sgroup)) continue;
                StandardSgroupGenerator.contractAbbreviation(container, symbolRemap, sgroup);
                continue;
            }
            if (sgroup.getType() == SgroupType.CtabMultipleGroup) {
                StandardSgroupGenerator.hideMultipleParts(container, sgroup);
                continue;
            }
            if (sgroup.getType() != SgroupType.ExtMulticenter) continue;
            Set<IAtom> atoms = sgroup.getAtoms();
            for (IBond bond : sgroup.getBonds()) {
                IAtom beg = bond.getAtom(0);
                IAtom end = bond.getAtom(1);
                if (atoms.contains(beg)) {
                    StandardGenerator.hideFully(beg);
                    continue;
                }
                StandardGenerator.hideFully(end);
            }
        }
    }

    private static boolean checkAbbreviationHighlight(IAtomContainer container, Sgroup sgroup) {
        assert (sgroup.getType() == SgroupType.CtabAbbreviation);
        Set<IAtom> sgroupAtoms = sgroup.getAtoms();
        int atomHighlight = 0;
        int bondHighlight = 0;
        int numSgroupAtoms = sgroupAtoms.size();
        int numSgroupBonds = 0;
        Color color = null;
        Color refcolor = null;
        for (IAtom atom : sgroupAtoms) {
            color = (Color)atom.getProperty("stdgen.highlight.color");
            if (color != null) {
                ++atomHighlight;
                if (refcolor == null) {
                    refcolor = color;
                    continue;
                }
                if (color.equals(refcolor)) continue;
                return false;
            }
            if (atomHighlight == 0) continue;
            return false;
        }
        for (IBond bond : container.bonds()) {
            IAtom beg = bond.getAtom(0);
            IAtom end = bond.getAtom(1);
            if (!sgroupAtoms.contains(beg) || !sgroupAtoms.contains(end)) continue;
            ++numSgroupBonds;
            color = (Color)bond.getProperty("stdgen.highlight.color");
            if (color != null) {
                ++bondHighlight;
                if (refcolor == null) {
                    refcolor = color;
                    continue;
                }
                if (color.equals(refcolor)) continue;
                return false;
            }
            if (bondHighlight == 0) continue;
            return false;
        }
        return atomHighlight + bondHighlight == 0 || atomHighlight == numSgroupAtoms && bondHighlight == numSgroupBonds;
    }

    private static void hideMultipleParts(IAtomContainer container, Sgroup sgroup) {
        Set<IBond> crossing = sgroup.getBonds();
        Set<IAtom> atoms = sgroup.getAtoms();
        Set parentAtoms = (Set)sgroup.getValue(SgroupKey.CtabParentAtomList);
        for (IBond bond : container.bonds()) {
            if (parentAtoms.contains(bond.getAtom(0)) && parentAtoms.contains(bond.getAtom(1)) || !atoms.contains(bond.getAtom(0)) && !atoms.contains(bond.getAtom(1))) continue;
            StandardGenerator.hide(bond);
        }
        for (IAtom atom : atoms) {
            if (parentAtoms.contains(atom)) continue;
            StandardGenerator.hide(atom);
        }
        for (IBond bond : crossing) {
            StandardGenerator.unhide(bond);
        }
    }

    private static void contractAbbreviation(IAtomContainer container, Map<IAtom, String> symbolRemap, Sgroup sgroup) {
        Set<IBond> crossing = sgroup.getBonds();
        Set<IAtom> atoms = sgroup.getAtoms();
        if (crossing.size() > 1) {
            return;
        }
        for (IAtom atom : atoms) {
            StandardGenerator.hide(atom);
        }
        for (IBond bond : container.bonds()) {
            if (!atoms.contains(bond.getAtom(0)) && !atoms.contains(bond.getAtom(1))) continue;
            StandardGenerator.hide(bond);
        }
        for (IBond bond : crossing) {
            StandardGenerator.unhide(bond);
            IAtom a1 = bond.getAtom(0);
            IAtom a2 = bond.getAtom(1);
            StandardGenerator.unhide(a1);
            if (atoms.contains(a1)) {
                symbolRemap.put(a1, sgroup.getSubscript());
            }
            StandardGenerator.unhide(a2);
            if (!atoms.contains(a2)) continue;
            symbolRemap.put(a2, sgroup.getSubscript());
        }
    }

    IRenderingElement generateSgroups(IAtomContainer container, AtomSymbol[] symbols) {
        ElementGroup result = new ElementGroup();
        List sgroups = (List)container.getProperty("cdk:CtabSgroups");
        if (sgroups == null || sgroups.isEmpty()) {
            return result;
        }
        HashMap<IAtom, AtomSymbol> symbolMap = new HashMap<IAtom, AtomSymbol>();
        for (int i = 0; i < symbols.length; ++i) {
            if (symbols[i] == null) continue;
            symbolMap.put(container.getAtom(i), symbols[i]);
        }
        for (Sgroup sgroup : sgroups) {
            switch (sgroup.getType()) {
                case CtabAbbreviation: {
                    result.add(this.generateAbbreviationSgroup(container, sgroup));
                    break;
                }
                case CtabMultipleGroup: {
                    result.add(this.generateMultipleSgroup(sgroup));
                    break;
                }
                case CtabAnyPolymer: 
                case CtabMonomer: 
                case CtabCrossLink: 
                case CtabCopolymer: 
                case CtabStructureRepeatUnit: 
                case CtabMer: 
                case CtabGraft: 
                case CtabModified: {
                    result.add(this.generatePolymerSgroup(sgroup, symbolMap));
                    break;
                }
                case CtabComponent: 
                case CtabMixture: 
                case CtabFormulation: {
                    result.add(this.generateMixtureSgroup(sgroup));
                    break;
                }
                case CtabGeneric: {
                    result.add(this.generatePolymerSgroup(sgroup, null));
                }
            }
        }
        return result;
    }

    private IRenderingElement generateMultipleSgroup(Sgroup sgroup) {
        List brackets = (List)sgroup.getValue(SgroupKey.CtabBracket);
        if (brackets != null) {
            return this.generateSgroupBrackets(sgroup, brackets, Collections.emptyMap(), (String)sgroup.getValue(SgroupKey.CtabSubScript), null);
        }
        return new ElementGroup();
    }

    private IRenderingElement generateAbbreviationSgroup(IAtomContainer mol, Sgroup sgroup) {
        String label = sgroup.getSubscript();
        if (sgroup.getBonds().size() > 0 || label == null || label.isEmpty()) {
            return new ElementGroup();
        }
        if (!StandardSgroupGenerator.checkAbbreviationHighlight(mol, sgroup)) {
            return new ElementGroup();
        }
        Set<IAtom> sgroupAtoms = sgroup.getAtoms();
        assert (!sgroupAtoms.isEmpty());
        Color highlight = (Color)sgroupAtoms.iterator().next().getProperty("stdgen.highlight.color");
        StandardGenerator.HighlightStyle style = (StandardGenerator.HighlightStyle)((Object)this.parameters.get(StandardGenerator.Highlighting.class));
        double glowWidth = (Double)this.parameters.get(StandardGenerator.OuterGlowWidth.class);
        Point2d labelCoords = GeometryUtil.get2DCenter(sgroupAtoms);
        ElementGroup labelgroup = new ElementGroup();
        for (Shape outline : this.atomGenerator.generateAbbreviatedSymbol(label, HydrogenPosition.Right).resize(1.0 / this.scale, 1.0 / -this.scale).getOutlines()) {
            if (highlight != null && style == StandardGenerator.HighlightStyle.Colored) {
                labelgroup.add(GeneralPath.shapeOf(outline, highlight));
                continue;
            }
            labelgroup.add(GeneralPath.shapeOf(outline, this.foreground));
        }
        if (highlight != null && style == StandardGenerator.HighlightStyle.OuterGlow) {
            ElementGroup group = new ElementGroup();
            group.add(StandardGenerator.outerGlow(labelgroup, highlight, glowWidth, this.stroke));
            group.add(labelgroup);
            return group;
        }
        return MarkedElement.markupAtom(labelgroup, null);
    }

    private IRenderingElement generatePolymerSgroup(Sgroup sgroup, Map<IAtom, AtomSymbol> symbolMap) {
        List brackets = (List)sgroup.getValue(SgroupKey.CtabBracket);
        if (brackets != null) {
            SgroupType type = sgroup.getType();
            String subscript = (String)sgroup.getValue(SgroupKey.CtabSubScript);
            String connectivity = (String)sgroup.getValue(SgroupKey.CtabConnectivity);
            switch (type) {
                case CtabCopolymer: {
                    subscript = "co";
                    String subtype = (String)sgroup.getValue(SgroupKey.CtabSubType);
                    if ("RAN".equals(subtype)) {
                        subscript = "ran";
                        break;
                    }
                    if ("BLK".equals(subtype)) {
                        subscript = "blk";
                        break;
                    }
                    if (!"ALT".equals(subtype)) break;
                    subscript = "alt";
                    break;
                }
                case CtabCrossLink: {
                    subscript = "xl";
                    break;
                }
                case CtabAnyPolymer: {
                    subscript = "any";
                    break;
                }
                case CtabGraft: {
                    subscript = "grf";
                    break;
                }
                case CtabMer: {
                    subscript = "mer";
                    break;
                }
                case CtabMonomer: {
                    subscript = "mon";
                    break;
                }
                case CtabModified: {
                    subscript = "mod";
                    break;
                }
                case CtabStructureRepeatUnit: {
                    if (subscript == null) {
                        subscript = "n";
                    }
                    if (connectivity != null) break;
                    connectivity = "eu";
                }
            }
            if ("ht".equals(connectivity) || sgroup.getAtoms().size() == 1) {
                connectivity = null;
            }
            return this.generateSgroupBrackets(sgroup, brackets, symbolMap, subscript, connectivity);
        }
        return new ElementGroup();
    }

    private IRenderingElement generateMixtureSgroup(Sgroup sgroup) {
        List brackets = (List)sgroup.getValue(SgroupKey.CtabBracket);
        if (brackets != null) {
            SgroupType type = sgroup.getType();
            String subscript = "?";
            switch (type) {
                case CtabComponent: {
                    Integer compNum = (Integer)sgroup.getValue(SgroupKey.CtabComponentNumber);
                    if (compNum != null) {
                        subscript = "c" + Integer.toString(compNum);
                        break;
                    }
                    subscript = "c";
                    break;
                }
                case CtabMixture: {
                    subscript = "mix";
                    break;
                }
                case CtabFormulation: {
                    subscript = "f";
                }
            }
            return this.generateSgroupBrackets(sgroup, brackets, null, subscript, null);
        }
        return new ElementGroup();
    }

    private IRenderingElement generateSgroupBrackets(Sgroup sgroup, List<SgroupBracket> brackets, Map<IAtom, AtomSymbol> symbols, String subscriptSuffix, String superscriptSuffix) {
        Map pairs;
        Integer style = (Integer)sgroup.getValue(SgroupKey.CtabBracketStyle);
        boolean round = style != null && style == 1;
        ElementGroup result = new ElementGroup();
        Set<IAtom> atoms = sgroup.getAtoms();
        Set<IBond> crossingBonds = sgroup.getBonds();
        Map<Object, Object> map = pairs = crossingBonds.size() == brackets.size() ? StandardSgroupGenerator.bracketBondPairs(brackets, crossingBonds) : Collections.emptyMap();
        if (atoms.size() == 1) {
            double scriptscale = this.labelScale;
            TextOutline leftBracket = new TextOutline("(", this.font).resize(1.0 / this.scale, 1.0 / -this.scale);
            TextOutline rightBracket = new TextOutline(")", this.font).resize(1.0 / this.scale, 1.0 / -this.scale);
            Point2D leftCenter = leftBracket.getCenter();
            Point2D rightCenter = rightBracket.getCenter();
            if (symbols.containsKey(atoms.iterator().next())) {
                AtomSymbol symbol = symbols.get(atoms.iterator().next());
                Rectangle2D bounds = symbol.getConvexHull().outline().getBounds2D();
                bounds.setRect(bounds.getMinX() - 2.0 * this.stroke, bounds.getMinY() - 2.0 * this.stroke, bounds.getWidth() + 4.0 * this.stroke, bounds.getHeight() + 4.0 * this.stroke);
                leftBracket = leftBracket.translate(bounds.getMinX() - 0.1 - leftCenter.getX(), symbol.getAlignmentCenter().getY() - leftCenter.getY());
                rightBracket = rightBracket.translate(bounds.getMaxX() + 0.1 - rightCenter.getX(), symbol.getAlignmentCenter().getY() - rightCenter.getY());
            } else {
                Point2d p = atoms.iterator().next().getPoint2d();
                leftBracket = leftBracket.translate(p.x - 0.2 - leftCenter.getX(), p.y - leftCenter.getY());
                rightBracket = rightBracket.translate(p.x + 0.2 - rightCenter.getX(), p.y - rightCenter.getY());
            }
            result.add(GeneralPath.shapeOf(leftBracket.getOutline(), this.foreground));
            result.add(GeneralPath.shapeOf(rightBracket.getOutline(), this.foreground));
            Rectangle2D rightBracketBounds = rightBracket.getBounds();
            if (subscriptSuffix != null && !subscriptSuffix.isEmpty()) {
                TextOutline subscriptOutline = this.leftAlign(this.makeText(subscriptSuffix.toLowerCase(Locale.ROOT), new Point2d(rightBracketBounds.getMaxX(), rightBracketBounds.getMinY() - 0.1), new Vector2d(-0.5 * rightBracketBounds.getWidth(), 0.0), scriptscale));
                result.add(GeneralPath.shapeOf(subscriptOutline.getOutline(), this.foreground));
            }
            if (superscriptSuffix != null && !superscriptSuffix.isEmpty()) {
                TextOutline superscriptOutline = this.leftAlign(this.makeText(superscriptSuffix.toLowerCase(Locale.ROOT), new Point2d(rightBracketBounds.getMaxX(), rightBracketBounds.getMaxY() + 0.1), new Vector2d(-rightBracketBounds.getWidth(), 0.0), scriptscale));
                result.add(GeneralPath.shapeOf(superscriptOutline.getOutline(), this.foreground));
            }
        } else if (!pairs.isEmpty()) {
            SgroupBracket suffixBracket = null;
            Vector2d suffixBracketPerp = null;
            for (Map.Entry e : pairs.entrySet()) {
                Point2d midpoint;
                Point2d p2;
                SgroupBracket bracket = (SgroupBracket)e.getKey();
                IBond bond = (IBond)e.getValue();
                IAtom inGroupAtom = atoms.contains(bond.getAtom(0)) ? bond.getAtom(0) : bond.getAtom(1);
                Point2d p1 = bracket.getFirstPoint();
                Vector2d perp = VecmathUtil.newPerpendicularVector(VecmathUtil.newUnitVector(p1, p2 = bracket.getSecondPoint()));
                if (perp.dot(VecmathUtil.newUnitVector(midpoint = VecmathUtil.midpoint(p1, p2), inGroupAtom.getPoint2d())) < 0.0) {
                    perp.negate();
                }
                perp.scale(this.bracketDepth);
                if (round) {
                    result.add(this.createRoundBracket(p1, p2, perp, midpoint));
                } else {
                    result.add(this.createSquareBracket(p1, p2, perp));
                }
                if (suffixBracket == null) {
                    suffixBracket = bracket;
                    suffixBracketPerp = perp;
                    continue;
                }
                Point2d sp1 = suffixBracket.getFirstPoint();
                Point2d sp2 = suffixBracket.getSecondPoint();
                double bestMaxX = Math.max(sp1.x, sp2.x);
                double thisMaxX = Math.max(p1.x, p2.x);
                double bestMaxY = Math.max(sp1.y, sp2.y);
                double thisMaxY = Math.max(p1.y, p2.y);
                double xDiff = thisMaxX - bestMaxX;
                double yDiff = thisMaxY - bestMaxY;
                if (!(xDiff > 0.1) && (!(xDiff > -0.1) || !(yDiff < -0.1))) continue;
                suffixBracket = bracket;
                suffixBracketPerp = perp;
            }
            if (suffixBracket != null) {
                Point2d subSufPnt = suffixBracket.getFirstPoint();
                Point2d supSufPnt = suffixBracket.getSecondPoint();
                double xDiff = subSufPnt.x - supSufPnt.x;
                double yDiff = subSufPnt.y - supSufPnt.y;
                if (yDiff > 0.1 || yDiff > -0.1 && xDiff > 0.1) {
                    Point2d tmpP = subSufPnt;
                    subSufPnt = supSufPnt;
                    supSufPnt = tmpP;
                }
                if (subscriptSuffix != null && !subscriptSuffix.isEmpty()) {
                    TextOutline subscriptOutline = this.leftAlign(this.makeText(subscriptSuffix.toLowerCase(Locale.ROOT), subSufPnt, suffixBracketPerp, this.labelScale));
                    result.add(GeneralPath.shapeOf(subscriptOutline.getOutline(), this.foreground));
                }
                if (superscriptSuffix != null && !superscriptSuffix.isEmpty()) {
                    TextOutline superscriptOutline = this.leftAlign(this.makeText(superscriptSuffix.toLowerCase(Locale.ROOT), supSufPnt, suffixBracketPerp, this.labelScale));
                    result.add(GeneralPath.shapeOf(superscriptOutline.getOutline(), this.foreground));
                }
            }
        } else if (brackets.size() == 2) {
            Point2d b1p1 = brackets.get(0).getFirstPoint();
            Point2d b1p2 = brackets.get(0).getSecondPoint();
            Point2d b2p1 = brackets.get(1).getFirstPoint();
            Point2d b2p2 = brackets.get(1).getSecondPoint();
            Vector2d b1vec = VecmathUtil.newUnitVector(b1p1, b1p2);
            Vector2d b2vec = VecmathUtil.newUnitVector(b2p1, b2p2);
            Vector2d b1pvec = VecmathUtil.newPerpendicularVector(b1vec);
            Vector2d b2pvec = VecmathUtil.newPerpendicularVector(b2vec);
            if (b1pvec.dot(VecmathUtil.newUnitVector(b1p1, b2p1)) < 0.0) {
                b1pvec.negate();
            }
            if (b2pvec.dot(VecmathUtil.newUnitVector(b2p1, b1p1)) < 0.0) {
                b2pvec.negate();
            }
            b1pvec.scale(this.bracketDepth);
            b2pvec.scale(this.bracketDepth);
            if (Double.isNaN(b1pvec.x) || Double.isNaN(b1pvec.y) || Double.isNaN(b2pvec.x) || Double.isNaN(b2pvec.y)) {
                return result;
            }
            Path2D.Double path = new Path2D.Double();
            if (round) {
                ((Path2D)path).moveTo(b1p1.x + b1pvec.x, b1p1.y + b1pvec.y);
                Point2d cpb1 = VecmathUtil.midpoint(b1p1, b1p2);
                cpb1.add(VecmathUtil.negate(b1pvec));
                ((Path2D)path).quadTo(cpb1.x, cpb1.y, b1p2.x + b1pvec.x, b1p2.y + b1pvec.y);
                ((Path2D)path).moveTo(b2p1.x + b2pvec.x, b2p1.y + b2pvec.y);
                Point2d cpb2 = VecmathUtil.midpoint(b2p1, b2p2);
                cpb2.add(VecmathUtil.negate(b2pvec));
                ((Path2D)path).quadTo(cpb2.x, cpb2.y, b2p2.x + b2pvec.x, b2p2.y + b2pvec.y);
            } else {
                ((Path2D)path).moveTo(b1p1.x + b1pvec.x, b1p1.y + b1pvec.y);
                ((Path2D)path).lineTo(b1p1.x, b1p1.y);
                ((Path2D)path).lineTo(b1p2.x, b1p2.y);
                ((Path2D)path).lineTo(b1p2.x + b1pvec.x, b1p2.y + b1pvec.y);
                ((Path2D)path).moveTo(b2p1.x + b2pvec.x, b2p1.y + b2pvec.y);
                ((Path2D)path).lineTo(b2p1.x, b2p1.y);
                ((Path2D)path).lineTo(b2p2.x, b2p2.y);
                ((Path2D)path).lineTo(b2p2.x + b2pvec.x, b2p2.y + b2pvec.y);
            }
            result.add(GeneralPath.outlineOf(path, this.stroke, this.foreground));
            double b1MaxX = Math.max(b1p1.x, b1p2.x);
            double b2MaxX = Math.max(b2p1.x, b2p2.x);
            double b1MaxY = Math.max(b1p1.y, b1p2.y);
            double b2MaxY = Math.max(b2p1.y, b2p2.y);
            Point2d subSufPnt = b2p2;
            Point2d supSufPnt = b2p1;
            Vector2d subpvec = b2pvec;
            double bXDiff = b1MaxX - b2MaxX;
            double bYDiff = b1MaxY - b2MaxY;
            if (bXDiff > 0.1 || bXDiff > -0.1 && bYDiff < -0.1) {
                subSufPnt = b1p2;
                supSufPnt = b1p1;
                subpvec = b1pvec;
            }
            double xDiff = subSufPnt.x - supSufPnt.x;
            double yDiff = subSufPnt.y - supSufPnt.y;
            if (yDiff > 0.1 || yDiff > -0.1 && xDiff > 0.1) {
                Point2d tmpP = subSufPnt;
                subSufPnt = supSufPnt;
                supSufPnt = tmpP;
            }
            if (subscriptSuffix != null && !subscriptSuffix.isEmpty()) {
                TextOutline subscriptOutline = this.leftAlign(this.makeText(subscriptSuffix.toLowerCase(Locale.ROOT), subSufPnt, subpvec, this.labelScale));
                result.add(GeneralPath.shapeOf(subscriptOutline.getOutline(), this.foreground));
            }
            if (superscriptSuffix != null && !superscriptSuffix.isEmpty()) {
                TextOutline superscriptOutline = this.leftAlign(this.makeText(superscriptSuffix.toLowerCase(Locale.ROOT), supSufPnt, subpvec, this.labelScale));
                result.add(GeneralPath.shapeOf(superscriptOutline.getOutline(), this.foreground));
            }
        }
        return result;
    }

    private GeneralPath createRoundBracket(Point2d p1, Point2d p2, Vector2d perp, Point2d midpoint) {
        Path2D.Double path = new Path2D.Double();
        ((Path2D)path).moveTo(p1.x + perp.x, p1.y + perp.y);
        Point2d cpb1 = new Point2d(midpoint);
        cpb1.add(VecmathUtil.negate(perp));
        ((Path2D)path).quadTo(cpb1.x, cpb1.y, p2.x + perp.x, p2.y + perp.y);
        return GeneralPath.outlineOf(path, this.stroke, this.foreground);
    }

    private GeneralPath createSquareBracket(Point2d p1, Point2d p2, Vector2d perp) {
        Path2D.Double path = new Path2D.Double();
        ((Path2D)path).moveTo(p1.x + perp.x, p1.y + perp.y);
        ((Path2D)path).lineTo(p1.x, p1.y);
        ((Path2D)path).lineTo(p2.x, p2.y);
        ((Path2D)path).lineTo(p2.x + perp.x, p2.y + perp.y);
        return GeneralPath.outlineOf(path, this.stroke, this.foreground);
    }

    private static Map<SgroupBracket, IBond> bracketBondPairs(Collection<SgroupBracket> brackets, Collection<IBond> bonds) {
        HashMap<SgroupBracket, IBond> pairs = new HashMap<SgroupBracket, IBond>();
        for (SgroupBracket bracket : brackets) {
            IBond crossingBond = null;
            for (IBond bond : bonds) {
                IAtom a1 = bond.getAtom(0);
                IAtom a2 = bond.getAtom(1);
                if (!Line2D.linesIntersect(bracket.getFirstPoint().x, bracket.getFirstPoint().y, bracket.getSecondPoint().x, bracket.getSecondPoint().y, a1.getPoint2d().x, a1.getPoint2d().y, a2.getPoint2d().x, a2.getPoint2d().y)) continue;
                if (crossingBond != null) {
                    return new HashMap<SgroupBracket, IBond>();
                }
                crossingBond = bond;
            }
            if (crossingBond == null) {
                return new HashMap<SgroupBracket, IBond>();
            }
            pairs.put(bracket, crossingBond);
        }
        return pairs;
    }

    private TextOutline makeText(String subscriptSuffix, Point2d b1p2, Vector2d b1pvec, double labelScale) {
        return StandardGenerator.generateAnnotation(b1p2, subscriptSuffix, VecmathUtil.negate(b1pvec), 1.0, labelScale, this.font, null).resize(1.0 / this.scale, 1.0 / this.scale);
    }

    private TextOutline leftAlign(TextOutline outline) {
        Point2D center = outline.getCenter();
        Point2D first = outline.getFirstGlyphCenter();
        return outline.translate(center.getX() - first.getX(), center.getY() - first.getY());
    }
}

