/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.element;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import org.apache.log4j.Logger;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.base.CMLElements;
import org.xmlcml.cml.element.AbstractMap;
import org.xmlcml.cml.element.CMLLink;
import org.xmlcml.cml.element.CMLMolecule;
import org.xmlcml.euclid.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMLMap
extends AbstractMap {
    private static Logger LOG = Logger.getLogger(CMLMap.class);
    static Logger logger = Logger.getLogger(CMLMap.class.getName());
    protected CMLMolecule molecule;
    protected Map<String, String> toFromTable;
    protected Map<String, String> fromToTable;
    protected Map<String, CMLLink> toLinkTable;
    protected Map<String, CMLLink> fromLinkTable;

    public CMLMap() {
    }

    public CMLMap(CMLMap old) {
        super(old);
        this.copyFields(old);
    }

    @Override
    public Node copy() {
        return new CMLMap(this);
    }

    private void copyFields(CMLMap old) {
        this.molecule = old.molecule;
    }

    @Override
    public CMLElement makeElementInContext(Element parent) {
        return new CMLMap();
    }

    @Override
    public void finishMakingElement(Element parent) {
        super.finishMakingElement(parent);
        this.makeTables();
        this.addLinks();
    }

    void addLinks() {
        CMLElements<CMLLink> links = this.getLinkElements();
        for (CMLLink link : links) {
            this.addLink(link);
        }
    }

    void checkAndCreateTablesAndAddLinks() {
        if (this.fromToTable == null || this.toFromTable == null || this.toLinkTable == null || this.fromLinkTable == null) {
            this.makeTables();
            this.addLinks();
        }
    }

    public static Direction getReverseToFrom(Direction toFrom) {
        Direction d = null;
        if (toFrom.equals((Object)Direction.TO)) {
            d = Direction.FROM;
        } else if (toFrom.equals((Object)Direction.FROM)) {
            d = Direction.TO;
        }
        return d;
    }

    void clearTables() {
        this.makeTables();
        this.toFromTable.clear();
        this.fromToTable.clear();
        this.toLinkTable.clear();
        this.fromLinkTable.clear();
    }

    void makeTables() {
        if (this.toFromTable == null) {
            this.toFromTable = new HashMap<String, String>();
        }
        if (this.fromToTable == null) {
            this.fromToTable = new HashMap<String, String>();
        }
        if (this.toLinkTable == null) {
            this.toLinkTable = new HashMap<String, CMLLink>();
        }
        if (this.fromLinkTable == null) {
            this.fromLinkTable = new HashMap<String, CMLLink>();
        }
    }

    public void appendChild(CMLLink link) {
        this.addLink(link);
    }

    public void addLink(CMLLink link) {
        if (link != null) {
            this.addLinkToTable(link);
            super.addLink(link);
        }
    }

    private String getFromLink(CMLLink link) {
        return "".equals(link.getFrom()) ? Util.concatenate(link.getFromSet(), " ") : link.getFrom();
    }

    private String getToLink(CMLLink link) {
        return "".equals(link.getTo()) ? Util.concatenate(link.getToSet(), " ") : link.getTo();
    }

    public void addUniqueLink(CMLLink link, Direction control) {
        String toLinkS = this.getToLink(link);
        String fromLinkS = this.getFromLink(link);
        if (control.equals((Object)Direction.BOTH)) {
            CMLLink oldLink = this.getFromToLink(fromLinkS, toLinkS);
            if (oldLink != null) {
                this.removeLink(oldLink);
            }
            this.addLink(link);
        } else {
            if (control.equals((Object)Direction.FROM)) {
                throw new RuntimeException("FROM not implemented");
            }
            if (control.equals((Object)Direction.TO)) {
                throw new RuntimeException("TO not implemented");
            }
            if (control.equals((Object)Direction.EITHER)) {
                CMLLink toLink = this.getLink(toLinkS, Direction.TO);
                CMLLink fromLink = this.getLink(fromLinkS, Direction.FROM);
                if (fromLink == null) {
                    this.removeLink(fromLink);
                }
                if (toLink != null) {
                    this.removeLink(fromLink);
                }
                this.addLink(link);
            } else if (control.equals((Object)Direction.NEITHER)) {
                CMLLink toLink = this.getLink(toLinkS, Direction.TO);
                CMLLink fromLink = this.getLink(fromLinkS, Direction.FROM);
                if (toLink != null) {
                    if (fromLink != null) {
                        // empty if block
                    }
                } else if (fromLink == null) {
                    this.addLink(link);
                }
            }
        }
    }

    public void addMap(CMLMap map2) {
        for (CMLLink link : map2.getLinkElements()) {
            CMLLink newLink = new CMLLink();
            CMLMap.copyAttributesFromTo(link, newLink);
            this.addLink(newLink);
        }
    }

    void addLinkToTable(CMLLink link) {
        this.makeTables();
        if (link != null) {
            String toLinkS = this.getToLink(link);
            String fromLinkS = this.getFromLink(link);
            this.fromToTable.put(fromLinkS, toLinkS);
            this.toFromTable.put(toLinkS, fromLinkS);
            this.fromLinkTable.put(fromLinkS, link);
            this.toLinkTable.put(toLinkS, link);
        }
    }

    public void removeLink(CMLLink link) {
        if (link != null) {
            String to = this.getToLink(link);
            String from = this.getFromLink(link);
            this.toFromTable.remove(to);
            this.toLinkTable.remove(to);
            this.fromLinkTable.remove(from);
            this.fromToTable.remove(from);
            link.detach();
        }
    }

    public List<String> getToRefs() {
        this.makeTables();
        ArrayList<String> toRefs = new ArrayList<String>();
        for (CMLLink link : this.getLinkElements()) {
            if (link.getTo() == null) continue;
            toRefs.add(link.getTo());
        }
        return toRefs;
    }

    public List<String[]> getToSetRefs() {
        this.makeTables();
        ArrayList<String[]> toSetRefs = new ArrayList<String[]>();
        for (CMLLink link : this.getLinkElements()) {
            if (link.getToSet() == null) continue;
            toSetRefs.add(link.getToSet());
        }
        return toSetRefs;
    }

    public List<String> getFromRefs() {
        this.makeTables();
        ArrayList<String> fromRefs = new ArrayList<String>();
        for (CMLLink link : this.getLinkElements()) {
            if (link.getFrom() == null) continue;
            fromRefs.add(link.getFrom());
        }
        return fromRefs;
    }

    public List<String[]> getFromSetRefs() {
        this.makeTables();
        ArrayList<String[]> fromSetRefs = new ArrayList<String[]>();
        for (CMLLink link : this.getLinkElements()) {
            if (link.getFromSet() == null) continue;
            fromSetRefs.add(link.getFromSet());
        }
        return fromSetRefs;
    }

    public String getToRef(String fromId) {
        this.makeTables();
        return this.fromToTable == null ? null : this.fromToTable.get(fromId);
    }

    public String getFromRef(String toId) {
        this.makeTables();
        return this.fromToTable == null ? null : this.toFromTable.get(toId);
    }

    public List<String> getToRefs(List<String> fromIds) {
        this.makeTables();
        ArrayList<String> toRefs = new ArrayList<String>();
        for (String fromId : fromIds) {
            String toRef = this.getToRef(fromId);
            toRefs.add(toRef);
        }
        return toRefs;
    }

    public List<String> getFromRefs(List<String> toIds) {
        this.makeTables();
        ArrayList<String> fromRefs = new ArrayList<String>();
        for (String toId : toIds) {
            fromRefs.add(this.getFromRef(toId));
        }
        return fromRefs;
    }

    public List<String> getRefs(Direction toFrom) {
        this.makeTables();
        ArrayList<String> refs = new ArrayList<String>();
        for (CMLLink link : this.getLinkElements()) {
            refs.add(toFrom.equals((Object)Direction.TO) ? link.getTo() : link.getFrom());
        }
        return refs;
    }

    public List<String> getRefs(List<String> ids, Direction toFrom) {
        this.makeTables();
        ArrayList<String> ref = new ArrayList<String>();
        for (String id : ids) {
            ref.add(toFrom == Direction.FROM ? this.getFromRef(id) : this.getToRef(id));
        }
        return ref;
    }

    public String getRef(String id, Direction toFrom) {
        this.makeTables();
        this.checkAndCreateTablesAndAddLinks();
        Map<String, String> table = toFrom == Direction.FROM ? this.fromToTable : this.toFromTable;
        return table == null || id == null ? null : table.get(id);
    }

    public CMLLink getLink(String id, Direction toFrom) {
        this.makeTables();
        this.checkAndCreateTablesAndAddLinks();
        String ref = this.getRef(id, toFrom);
        return id == null || ref == null ? null : (toFrom.equals((Object)Direction.FROM) ? this.toLinkTable.get(ref) : this.fromLinkTable.get(ref));
    }

    public CMLLink getFromToLink(String from, String to) {
        this.makeTables();
        CMLLink link = this.getLink(to, Direction.TO);
        if (link != null) {
            link = link.getFrom().equals(from) ? link : null;
        }
        return link;
    }

    public void mergeMap(CMLMap addMap, Direction control) {
        if (addMap != null) {
            for (CMLLink link : addMap.getLinkElements()) {
                this.addUniqueLink(new CMLLink(link), control);
            }
        }
    }

    public void setLinkFromContext(String context) {
        for (CMLLink link : this.getLinkElements()) {
            link.setFromContext(context);
        }
    }

    public void setLinkToContext(String context) {
        for (CMLLink link : this.getLinkElements()) {
            link.setToContext(context);
        }
    }

    public void setLinkFromType(String type) {
        for (CMLLink link : this.getLinkElements()) {
            link.setFromType(type);
        }
    }

    public void setLinkToType(String type) {
        for (CMLLink link : this.getLinkElements()) {
            link.setToType(type);
        }
    }

    public List<CMLLink> getElementLinks(String tag) {
        ArrayList<CMLLink> linkList = new ArrayList<CMLLink>();
        for (CMLLink link : this.getLinkElements()) {
            String toType = CMLMap.getType(link, Direction.TO);
            String fromType = CMLMap.getType(link, Direction.FROM);
            if (!tag.equals(toType) || !tag.equals(fromType)) continue;
            String toSet = Util.concatenate(link.getToSet(), " ");
            String fromSet = Util.concatenate(link.getFromSet(), " ");
            if (toSet == null || "".equals(toSet.trim()) || fromSet == null || "".equals(fromSet.trim())) continue;
            linkList.add(link);
        }
        return linkList;
    }

    public static String getType(CMLLink link, Direction toFrom) {
        ParentNode parent;
        String type;
        String string = type = toFrom.equals((Object)Direction.TO) ? link.getToType() : link.getFromType();
        if ((type == null || type.trim().equals("")) && (parent = link.getParent()) != null && parent instanceof CMLMap) {
            CMLMap map = (CMLMap)parent;
            type = toFrom.equals((Object)Direction.TO) ? map.getToType() : map.getFromType();
        }
        return type;
    }

    public void annotateLinks(String fromType, String fromContext, String toType, String toContext) {
        this.setLinkToContext(toContext);
        this.setLinkFromContext(fromContext);
        this.setLinkToType(toType);
        this.setLinkFromType(fromType);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        TO("to"),
        FROM("from"),
        BOTH("both"),
        EITHER("either"),
        NEITHER("neither");

        public final String value;

        private Direction(String s) {
            this.value = s;
        }

        public String toString() {
            return this.value;
        }

        public Direction opposite() {
            Direction o = null;
            if (this.equals((Object)TO)) {
                o = FROM;
            } else if (this.equals((Object)FROM)) {
                o = TO;
            }
            return o;
        }
    }
}

