/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.hash;

import java.util.Arrays;
import java.util.Set;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.hash.AbstractAtomHashGenerator;
import org.openscience.cdk.hash.AbstractHashGenerator;
import org.openscience.cdk.hash.AtomHashGenerator;
import org.openscience.cdk.hash.AtomSuppression;
import org.openscience.cdk.hash.EquivalentSetFinder;
import org.openscience.cdk.hash.Pseudorandom;
import org.openscience.cdk.hash.SeedGenerator;
import org.openscience.cdk.hash.Suppressed;
import org.openscience.cdk.hash.stereo.StereoEncoder;
import org.openscience.cdk.hash.stereo.StereoEncoderFactory;
import org.openscience.cdk.interfaces.IAtomContainer;

@TestClass(value="org.openscience.cdk.hash.PerturbedAtomHashGeneratorTest")
final class PerturbedAtomHashGenerator
extends AbstractHashGenerator
implements AtomHashGenerator {
    private final StereoEncoderFactory factory;
    private final AbstractAtomHashGenerator simple;
    private final AtomHashGenerator seeds;
    private final EquivalentSetFinder finder;
    private final AtomSuppression suppression;

    public PerturbedAtomHashGenerator(SeedGenerator seeds, AbstractAtomHashGenerator simple, Pseudorandom pseudorandom, StereoEncoderFactory factory, EquivalentSetFinder finder, AtomSuppression suppression) {
        super(pseudorandom);
        if (simple == null) {
            throw new NullPointerException("no simple generator provided");
        }
        if (seeds == null) {
            throw new NullPointerException("no seed generator provided");
        }
        if (suppression == null) {
            throw new NullPointerException("no suppression provided, use AtomSuppression.none()");
        }
        this.finder = finder;
        this.factory = factory;
        this.simple = simple;
        this.seeds = seeds;
        this.suppression = suppression;
    }

    @TestMethod(value="testGenerate")
    public long[] generate(IAtomContainer container) {
        int[][] graph = PerturbedAtomHashGenerator.toAdjList(container);
        return this.generate(container, this.seeds.generate(container), this.factory.create(container, graph), graph);
    }

    private long[] generate(IAtomContainer container, long[] seeds, StereoEncoder encoder, int[][] graph) {
        int i;
        Suppressed suppressed = this.suppression.suppress(container);
        long[] original = this.simple.generate(seeds, encoder, graph, suppressed);
        Set<Integer> equivalentSet = this.finder.find(original, container, graph);
        Integer[] equivalents = equivalentSet.toArray(new Integer[equivalentSet.size()]);
        int n = original.length;
        int m = equivalents.length;
        if (m < 2) {
            return original;
        }
        long[][] perturbed = new long[n][m + 1];
        for (i = 0; i < n; ++i) {
            perturbed[i][0] = original[i];
        }
        for (i = 0; i < m; ++i) {
            int equivalentIndex = equivalents[i];
            original[equivalentIndex] = this.rotate(original[equivalentIndex]);
            encoder.reset();
            long[] tmp = this.simple.generate(PerturbedAtomHashGenerator.copy(original), encoder, graph, suppressed);
            for (int j = 0; j < n; ++j) {
                perturbed[j][i + 1] = tmp[j];
            }
            original[equivalentIndex] = perturbed[equivalentIndex][0];
        }
        return this.combine(perturbed);
    }

    @TestMethod(value="testCombine")
    long[] combine(long[][] perturbed) {
        int n = perturbed.length;
        int m = perturbed[0].length;
        long[] combined = new long[n];
        long[] rotated = new long[m];
        for (int i = 0; i < n; ++i) {
            Arrays.sort(perturbed[i]);
            for (int j = 0; j < m; ++j) {
                if (j > 0 && perturbed[i][j] == perturbed[i][j - 1]) {
                    int n2 = i;
                    rotated[j] = this.rotate(rotated[j - 1]);
                    combined[n2] = combined[n2] ^ rotated[j];
                    continue;
                }
                int n3 = i;
                rotated[j] = perturbed[i][j];
                combined[n3] = combined[n3] ^ rotated[j];
            }
        }
        return combined;
    }
}

