/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.formats;

import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.io.formats.IChemFormatMatcher;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.SimpleChemFormatMatcher;

@TestClass(value="org.openscience.cdk.io.formats.INChIFormatTest")
public class INChIFormat
extends SimpleChemFormatMatcher
implements IChemFormatMatcher {
    private static IResourceFormat myself = null;

    @TestMethod(value="testResourceFormatSet")
    public static IResourceFormat getInstance() {
        if (myself == null) {
            myself = new INChIFormat();
        }
        return myself;
    }

    @TestMethod(value="testGetFormatName")
    public String getFormatName() {
        return "IUPAC-NIST Chemical Identifier (XML)";
    }

    @TestMethod(value="testGetMIMEType")
    public String getMIMEType() {
        return null;
    }

    @TestMethod(value="testGetPreferredNameExtension")
    public String getPreferredNameExtension() {
        return this.getNameExtensions()[0];
    }

    @TestMethod(value="testGetNameExtensions")
    public String[] getNameExtensions() {
        return new String[]{"inchi"};
    }

    @TestMethod(value="testGetReaderClassName")
    public String getReaderClassName() {
        return "org.openscience.cdk.io.INChIReader";
    }

    @TestMethod(value="testGetWriterClassName")
    public String getWriterClassName() {
        return null;
    }

    @TestMethod(value="testMatches")
    public boolean matches(int lineNumber, String line) {
        return line.indexOf("<INChI") != -1;
    }

    @TestMethod(value="testIsXMLBased")
    public boolean isXMLBased() {
        return true;
    }

    @TestMethod(value="testGetSupportedDataFeatures")
    public int getSupportedDataFeatures() {
        return 0;
    }

    @TestMethod(value="testGetRequiredDataFeatures")
    public int getRequiredDataFeatures() {
        return 0;
    }
}

