/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators;

import java.awt.Color;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.vecmath.Point2d;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.geometry.GeometryTools;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.ISingleElectron;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.elements.ElementGroup;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.elements.OvalElement;
import org.openscience.cdk.renderer.generators.BasicAtomGenerator;
import org.openscience.cdk.renderer.generators.BasicSceneGenerator;
import org.openscience.cdk.renderer.generators.IGenerator;
import org.openscience.cdk.renderer.generators.IGeneratorParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.renderer.generators.RadicalGeneratorTest")
public class RadicalGenerator
implements IGenerator<IAtomContainer> {
    @Override
    @TestMethod(value="testEmptyContainer")
    public IRenderingElement generate(IAtomContainer container, RendererModel model) {
        ElementGroup group = new ElementGroup();
        double SCREEN_RADIUS = 2.0;
        Color RADICAL_COLOR = Color.BLACK;
        double ATOM_RADIUS = (Double)model.getParameter(BasicAtomGenerator.AtomRadius.class).getValue() / (Double)model.getParameter(BasicSceneGenerator.Scale.class).getValue();
        double modelRadius = 2.0 / (Double)model.getParameter(BasicSceneGenerator.Scale.class).getValue();
        double modelSpacing = modelRadius * 2.5;
        HashMap<IAtom, Integer> singleElectronsPerAtom = new HashMap<IAtom, Integer>();
        for (ISingleElectron electron : container.singleElectrons()) {
            IAtom atom = electron.getAtom();
            if (singleElectronsPerAtom.get(atom) == null) {
                singleElectronsPerAtom.put(atom, 0);
            }
            Point2d point = atom.getPoint2d();
            int align = GeometryTools.getBestAlignmentForLabelXY(container, atom);
            double xRadius = point.x;
            double yRadius = point.y;
            if (align == 1) {
                xRadius += ATOM_RADIUS * 4.0 + (double)((Integer)singleElectronsPerAtom.get(atom)).intValue() * modelSpacing;
            } else if (align == -1) {
                xRadius -= ATOM_RADIUS * 4.0 + (double)((Integer)singleElectronsPerAtom.get(atom)).intValue() * modelSpacing;
            } else if (align == 2) {
                yRadius += ATOM_RADIUS * 4.0 + (double)((Integer)singleElectronsPerAtom.get(atom)).intValue() * modelSpacing;
            } else if (align == -2) {
                yRadius -= ATOM_RADIUS * 4.0 + (double)((Integer)singleElectronsPerAtom.get(atom)).intValue() * modelSpacing;
            }
            singleElectronsPerAtom.put(atom, (Integer)singleElectronsPerAtom.get(atom) + 1);
            group.add(new OvalElement(xRadius, yRadius, modelRadius, true, RADICAL_COLOR));
        }
        return group;
    }

    @Override
    @TestMethod(value="testGetParameters")
    public List<IGeneratorParameter<?>> getParameters() {
        return Collections.emptyList();
    }
}

