/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.beam;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import uk.ac.ebi.beam.Atom;
import uk.ac.ebi.beam.AtomBuilder;
import uk.ac.ebi.beam.Edge;
import uk.ac.ebi.beam.Element;
import uk.ac.ebi.beam.Generator;
import uk.ac.ebi.beam.Graph;

final class AtomImpl {
    static Atom EXPLICIT_HYDROGEN = new BracketAtom(Element.Hydrogen, 0, 0);
    static Atom DEUTERIUM = AtomBuilder.aliphatic(Element.Hydrogen).isotope(2).build();
    static Atom TRITIUM = AtomBuilder.aliphatic(Element.Hydrogen).isotope(3).build();

    AtomImpl() {
    }

    static class BracketAtom
    implements Atom {
        private final Element element;
        private final int hCount;
        private final int charge;
        private final int atomClass;
        private final int isotope;
        private final boolean aromatic;

        public BracketAtom(int isotope, Element element, int hCount, int charge, int atomClass, boolean aromatic) {
            this.element = element;
            this.hCount = hCount;
            this.charge = charge;
            this.atomClass = atomClass;
            this.isotope = isotope;
            this.aromatic = aromatic;
        }

        public BracketAtom(Element element, int hCount, int charge) {
            this(-1, element, hCount, charge, 0, false);
        }

        @Override
        public int isotope() {
            return this.isotope;
        }

        @Override
        public Element element() {
            return this.element;
        }

        @Override
        public boolean aromatic() {
            return this.aromatic;
        }

        @Override
        public int charge() {
            return this.charge;
        }

        @Override
        public int hydrogens() {
            return this.hCount;
        }

        @Override
        public int atomClass() {
            return this.atomClass;
        }

        @Override
        public Generator.AtomToken token() {
            return new Generator.BracketToken(this);
        }

        @Override
        public boolean subset() {
            return false;
        }

        @Override
        public int hydrogens(Graph g, int u) {
            return this.hydrogens();
        }

        @Override
        public Atom toAromatic() {
            return this.aromatic || !this.element.aromatic() ? this : new BracketAtom(this.isotope, this.element, this.hCount, this.charge, this.atomClass, true);
        }

        @Override
        public Atom toAliphatic() {
            return !this.aromatic ? this : new BracketAtom(this.isotope, this.element, this.hCount, this.charge, this.atomClass, false);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BracketAtom that = (BracketAtom)o;
            if (this.aromatic != that.aromatic) {
                return false;
            }
            if (this.atomClass != that.atomClass) {
                return false;
            }
            if (this.charge != that.charge) {
                return false;
            }
            if (this.hCount != that.hCount) {
                return false;
            }
            if (this.isotope != that.isotope) {
                return false;
            }
            return this.element == that.element;
        }

        public int hashCode() {
            int result = this.element != null ? this.element.hashCode() : 0;
            result = 31 * result + this.hCount;
            result = 31 * result + this.charge;
            result = 31 * result + this.atomClass;
            result = 31 * result + this.isotope;
            result = 31 * result + (this.aromatic ? 1 : 0);
            return result;
        }

        public String toString() {
            return "[" + this.isotope + this.element.symbol() + "H" + this.hCount + (this.charge != 0 ? Integer.valueOf(this.charge) : "") + ":" + this.atomClass + "]";
        }
    }

    static enum AromaticSubset implements Atom
    {
        Boron(Element.Boron),
        Carbon(Element.Carbon),
        Nitrogen(Element.Nitrogen),
        Oxygen(Element.Oxygen),
        Sulfur(Element.Sulfur),
        Phosphorus(Element.Phosphorus);

        private Element element;
        private final Generator.AtomToken token;
        private static final Map<Element, Atom> atoms;

        private AromaticSubset(Element element) {
            this.element = element;
            this.token = new Generator.SubsetToken(element.symbol().toLowerCase(Locale.ENGLISH));
        }

        @Override
        public int isotope() {
            return -1;
        }

        @Override
        public Element element() {
            return this.element;
        }

        @Override
        public boolean aromatic() {
            return true;
        }

        @Override
        public int charge() {
            return 0;
        }

        @Override
        public int hydrogens() {
            throw new IllegalArgumentException("use bond order sum to determine implicit hydrogen count");
        }

        @Override
        public int atomClass() {
            return 0;
        }

        @Override
        public Generator.AtomToken token() {
            return this.token;
        }

        @Override
        public boolean subset() {
            return true;
        }

        @Override
        public Atom toAromatic() {
            return this;
        }

        @Override
        public Atom toAliphatic() {
            return AliphaticSubset.ofElement(this.element);
        }

        @Override
        public int hydrogens(Graph g, int u) {
            int sum = 0;
            for (Edge e : g.edges(u)) {
                sum += e.bond().order();
            }
            if (sum == g.degree(u)) {
                ++sum;
            }
            return this.element.aromaticImplicitHydrogens(sum);
        }

        static Atom ofElement(Element e) {
            Atom a = atoms.get((Object)e);
            if (a == null) {
                throw new IllegalArgumentException((Object)((Object)e) + "can not be an aromatic subset atom");
            }
            return a;
        }

        static {
            atoms = new HashMap<Element, Atom>();
            for (AromaticSubset a : AromaticSubset.values()) {
                atoms.put(a.element(), a);
            }
        }
    }

    static enum AliphaticSubset implements Atom
    {
        Unknown(Element.Unknown),
        Boron(Element.Boron),
        Carbon(Element.Carbon),
        Nitrogen(Element.Nitrogen),
        Oxygen(Element.Oxygen),
        Sulfur(Element.Sulfur),
        Phosphorus(Element.Phosphorus),
        Fluorine(Element.Fluorine),
        Chlorine(Element.Chlorine),
        Bromine(Element.Bromine),
        Iodine(Element.Iodine);

        private Element element;
        private Generator.AtomToken token;
        private static final Map<Element, Atom> atoms;

        private AliphaticSubset(Element element) {
            this.element = element;
            this.token = new Generator.SubsetToken(element.symbol());
        }

        @Override
        public int isotope() {
            return -1;
        }

        @Override
        public Element element() {
            return this.element;
        }

        @Override
        public boolean aromatic() {
            return false;
        }

        @Override
        public int charge() {
            return 0;
        }

        @Override
        public int hydrogens() {
            throw new IllegalArgumentException("use bond order sum to determine implicit hydrogen count");
        }

        @Override
        public int atomClass() {
            return 0;
        }

        @Override
        public boolean subset() {
            return true;
        }

        @Override
        public Atom toAromatic() {
            return this.element.aromatic() ? AromaticSubset.ofElement(this.element) : this;
        }

        @Override
        public Atom toAliphatic() {
            return this;
        }

        @Override
        public int hydrogens(Graph g, int u) {
            int sum = 0;
            for (Edge e : g.edges(u)) {
                sum += e.bond().order();
            }
            return this.element.implicitHydrogens(sum);
        }

        @Override
        public Generator.AtomToken token() {
            return this.token;
        }

        static Atom ofElement(Element e) {
            Atom a = atoms.get((Object)e);
            if (a == null) {
                throw new IllegalArgumentException((Object)((Object)e) + "can not be an aliphatic subset atom");
            }
            return a;
        }

        static {
            atoms = new HashMap<Element, Atom>();
            for (AliphaticSubset a : AliphaticSubset.values()) {
                atoms.put(a.element(), a);
            }
        }
    }
}

