/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.hash;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.hash.AbstractAtomHashGenerator;
import org.openscience.cdk.hash.AtomEncoder;
import org.openscience.cdk.hash.AtomHashGenerator;
import org.openscience.cdk.hash.AtomSuppression;
import org.openscience.cdk.hash.BasicAtomEncoder;
import org.openscience.cdk.hash.BasicAtomHashGenerator;
import org.openscience.cdk.hash.BasicMoleculeHashGenerator;
import org.openscience.cdk.hash.ConjugatedAtomEncoder;
import org.openscience.cdk.hash.EnsembleHashGenerator;
import org.openscience.cdk.hash.EquivalentSetFinder;
import org.openscience.cdk.hash.MinimumEquivalentCyclicSet;
import org.openscience.cdk.hash.MoleculeHashGenerator;
import org.openscience.cdk.hash.PerturbedAtomHashGenerator;
import org.openscience.cdk.hash.SeedGenerator;
import org.openscience.cdk.hash.SuppressedAtomHashGenerator;
import org.openscience.cdk.hash.Xorshift;
import org.openscience.cdk.hash.stereo.DoubleBondElementEncoderFactory;
import org.openscience.cdk.hash.stereo.GeometricCumulativeDoubleBondFactory;
import org.openscience.cdk.hash.stereo.GeometricDoubleBondEncoderFactory;
import org.openscience.cdk.hash.stereo.GeometricTetrahedralEncoderFactory;
import org.openscience.cdk.hash.stereo.StereoEncoder;
import org.openscience.cdk.hash.stereo.StereoEncoderFactory;
import org.openscience.cdk.hash.stereo.TetrahedralElementEncoderFactory;
import org.openscience.cdk.interfaces.IAtomContainer;

@TestClass(value="org.openscience.cdk.hash.HashGeneratorMakerTest")
public final class HashGeneratorMaker {
    private int depth = -1;
    private List<AtomEncoder> customEncoders = new ArrayList<AtomEncoder>();
    private EnumSet<BasicAtomEncoder> encoderSet = EnumSet.noneOf(BasicAtomEncoder.class);
    private List<StereoEncoderFactory> stereoEncoders = new ArrayList<StereoEncoderFactory>();
    private EquivalentSetFinder equivSetFinder = null;
    private AtomSuppression suppression = AtomSuppression.unsuppressed();

    @TestMethod(value="testInvalidDepth,testDepth")
    public HashGeneratorMaker depth(int depth) {
        if (depth < 0) {
            throw new IllegalArgumentException("depth must not be less than 0");
        }
        this.depth = depth;
        return this;
    }

    @TestMethod(value="testElemental")
    public HashGeneratorMaker elemental() {
        this.encoderSet.add(BasicAtomEncoder.ATOMIC_NUMBER);
        return this;
    }

    @TestMethod(value="testIsotopic")
    public HashGeneratorMaker isotopic() {
        this.encoderSet.add(BasicAtomEncoder.MASS_NUMBER);
        return this;
    }

    @TestMethod(value="testCharged")
    public HashGeneratorMaker charged() {
        this.encoderSet.add(BasicAtomEncoder.FORMAL_CHARGE);
        return this;
    }

    @TestMethod(value="testOrbital")
    public HashGeneratorMaker orbital() {
        this.encoderSet.add(BasicAtomEncoder.ORBITAL_HYBRIDIZATION);
        return this;
    }

    @TestMethod(value="testRadical")
    public HashGeneratorMaker radical() {
        this.encoderSet.add(BasicAtomEncoder.FREE_RADICALS);
        return this;
    }

    @TestMethod(value="testChiral")
    public HashGeneratorMaker chiral() {
        this.stereoEncoders.add(new GeometricTetrahedralEncoderFactory());
        this.stereoEncoders.add(new GeometricDoubleBondEncoderFactory());
        this.stereoEncoders.add(new GeometricCumulativeDoubleBondFactory());
        this.stereoEncoders.add(new TetrahedralElementEncoderFactory());
        this.stereoEncoders.add(new DoubleBondElementEncoderFactory());
        return this;
    }

    @TestMethod(value="suppressHydrogens")
    public HashGeneratorMaker suppressHydrogens() {
        this.suppression = AtomSuppression.anyHydrogens();
        return this;
    }

    @TestMethod(value="testPerturbed")
    public HashGeneratorMaker perturbed() {
        return this.perturbWith(new MinimumEquivalentCyclicSet());
    }

    @TestMethod(value="testPerturbedWith")
    HashGeneratorMaker perturbWith(EquivalentSetFinder equivSetFinder) {
        this.equivSetFinder = equivSetFinder;
        return this;
    }

    @TestMethod(value="testEncode_Null,testEncode")
    public HashGeneratorMaker encode(AtomEncoder encoder) {
        if (encoder == null) {
            throw new NullPointerException("no encoder provided");
        }
        this.customEncoders.add(encoder);
        return this;
    }

    private StereoEncoderFactory makeStereoEncoderFactory() {
        if (this.stereoEncoders.isEmpty()) {
            return StereoEncoderFactory.EMPTY;
        }
        if (this.stereoEncoders.size() == 1) {
            return this.stereoEncoders.get(0);
        }
        ConjugatedEncoderFactory factory = new ConjugatedEncoderFactory(this.stereoEncoders.get(0), this.stereoEncoders.get(1));
        for (int i = 2; i < this.stereoEncoders.size(); ++i) {
            factory = new ConjugatedEncoderFactory(factory, this.stereoEncoders.get(i));
        }
        return factory;
    }

    @TestMethod(value="testEnsemble")
    public EnsembleHashGenerator ensemble() {
        throw new UnsupportedOperationException("not yet supported");
    }

    @TestMethod(value="testMolecular")
    public MoleculeHashGenerator molecular() {
        return new BasicMoleculeHashGenerator(this.atomic());
    }

    @TestMethod(value="testAtomic,testNoDepth")
    public AtomHashGenerator atomic() {
        AbstractAtomHashGenerator simple;
        AtomEncoder encoder2;
        if (this.depth < 0) {
            throw new IllegalArgumentException("no depth specified, use .depth(int)");
        }
        ArrayList<AtomEncoder> encoders = new ArrayList<AtomEncoder>();
        for (AtomEncoder encoder2 : this.encoderSet) {
            encoders.add(encoder2);
        }
        encoders.addAll(this.customEncoders);
        boolean suppress = this.suppression != AtomSuppression.unsuppressed();
        encoder2 = new ConjugatedAtomEncoder(encoders);
        SeedGenerator seeds = new SeedGenerator(encoder2, this.suppression);
        AbstractAtomHashGenerator abstractAtomHashGenerator = simple = suppress ? new SuppressedAtomHashGenerator(seeds, new Xorshift(), this.makeStereoEncoderFactory(), this.suppression, this.depth) : new BasicAtomHashGenerator(seeds, new Xorshift(), this.makeStereoEncoderFactory(), this.depth);
        if (this.equivSetFinder != null) {
            return new PerturbedAtomHashGenerator(seeds, simple, new Xorshift(), this.makeStereoEncoderFactory(), this.equivSetFinder, this.suppression);
        }
        return simple;
    }

    private final class ConjugatedEncoder
    implements StereoEncoder {
        private final StereoEncoder left;
        private final StereoEncoder right;

        private ConjugatedEncoder(StereoEncoder left, StereoEncoder right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean encode(long[] current, long[] next) {
            boolean modified = this.left.encode(current, next);
            return this.right.encode(current, next) || modified;
        }

        @Override
        public void reset() {
            this.left.reset();
            this.right.reset();
        }
    }

    private final class ConjugatedEncoderFactory
    implements StereoEncoderFactory {
        private final StereoEncoderFactory left;
        private final StereoEncoderFactory right;

        private ConjugatedEncoderFactory(StereoEncoderFactory left, StereoEncoderFactory right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public StereoEncoder create(IAtomContainer container, int[][] graph) {
            return new ConjugatedEncoder(this.left.create(container, graph), this.right.create(container, graph));
        }
    }
}

