/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smsd.tools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.openscience.cdk.Bond;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.aromaticity.Aromaticity;
import org.openscience.cdk.atomtype.CDKAtomTypeMatcher;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.ILonePair;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.interfaces.IRing;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.ringsearch.AllRingsFinder;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.AtomTypeManipulator;
import org.openscience.cdk.tools.manipulator.RingSetManipulator;

@TestClass(value="org.openscience.cdk.smsd.tools.ExtAtomContainerManipulatorTest")
public class ExtAtomContainerManipulator
extends AtomContainerManipulator {
    private static void printAtoms(IAtomContainer mol) {
        System.out.print("Atom: ");
        for (IAtom a : mol.atoms()) {
            System.out.print(a.getSymbol());
            System.out.print("[" + a.getFormalCharge() + "]");
            if (a.getID() == null) continue;
            System.out.print("[" + a.getID() + "]");
        }
        System.out.println();
        System.out.println();
    }

    @TestMethod(value="testMakeDeepCopy")
    public static IAtomContainer makeDeepCopy(IAtomContainer container) {
        int index;
        IAtomContainer newAtomContainer = container.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        IAtom[] atoms = ExtAtomContainerManipulator.copyAtoms(container, newAtomContainer);
        ExtAtomContainerManipulator.copyBonds(atoms, container, newAtomContainer);
        for (index = 0; index < container.getLonePairCount(); ++index) {
            if (container.getAtom(index).getSymbol().equalsIgnoreCase("R") || container.getAtom(index).getSymbol().equalsIgnoreCase("A")) {
                newAtomContainer.addLonePair(container.getBuilder().newInstance(ILonePair.class, container.getAtom(index)));
                continue;
            }
            newAtomContainer.addLonePair(index);
        }
        for (index = 0; index < container.getSingleElectronCount(); ++index) {
            newAtomContainer.addSingleElectron(index);
        }
        newAtomContainer.addProperties(container.getProperties());
        newAtomContainer.setFlags(container.getFlags());
        newAtomContainer.setID(container.getID());
        newAtomContainer.notifyChanged();
        return newAtomContainer;
    }

    @TestMethod(value="testAromatizeMolecule")
    public static void aromatizeMolecule(IAtomContainer mol) {
        IRingSet ringSet = null;
        try {
            AllRingsFinder arf = new AllRingsFinder();
            ringSet = arf.findAllRings(mol);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            ExtAtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(mol);
            Aromaticity.cdkLegacy().apply(mol);
            RingSetManipulator.markAromaticRings(ringSet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (int i = 0; i <= mol.getAtomCount() - 1; ++i) {
            mol.getAtom(i).setFlag(32, false);
            for (int j = 0; j <= ringSet.getAtomContainerCount() - 1; ++j) {
                boolean haveatom;
                IRing ring = (IRing)ringSet.getAtomContainer(j);
                if (!ring.getFlag(32) || !(haveatom = ring.contains(mol.getAtom(i))) || ring.getAtomCount() != 6) continue;
                mol.getAtom(i).setFlag(32, true);
            }
        }
    }

    @TestMethod(value="testGetExplicitHydrogenCount")
    public static int getExplicitHydrogenCount(IAtomContainer atomContainer, IAtom atom) {
        int hCount = 0;
        for (IAtom iAtom : atomContainer.getConnectedAtomsList(atom)) {
            IAtom connectedAtom = iAtom;
            if (!connectedAtom.getSymbol().equals("H")) continue;
            ++hCount;
        }
        return hCount;
    }

    @TestMethod(value="testGetImplicitHydrogenCount")
    public static int getImplicitHydrogenCount(IAtom atom) {
        return atom.getImplicitHydrogenCount() == CDKConstants.UNSET ? 0 : atom.getImplicitHydrogenCount();
    }

    @TestMethod(value="testGetHydrogenCount")
    public static int getHydrogenCount(IAtomContainer atomContainer, IAtom atom) {
        return ExtAtomContainerManipulator.getExplicitHydrogenCount(atomContainer, atom) + ExtAtomContainerManipulator.getImplicitHydrogenCount(atom);
    }

    @TestMethod(value="testRemoveHydrogensAndPreserveAtomID")
    public static IAtomContainer removeHydrogensExceptSingleAndPreserveAtomID(IAtomContainer atomContainer) {
        HashMap<IAtom, IAtom> map = new HashMap<IAtom, IAtom>();
        ArrayList<IAtom> remove = new ArrayList<IAtom>();
        IAtomContainer mol = null;
        if (atomContainer.getBondCount() > 0) {
            mol = atomContainer.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
            int count = atomContainer.getAtomCount();
            for (int i = 0; i < count; ++i) {
                IAtom atom = atomContainer.getAtom(i);
                if (!atom.getSymbol().equals("H")) {
                    IAtom clonedAtom = null;
                    try {
                        clonedAtom = atom.clone();
                    }
                    catch (CloneNotSupportedException e) {
                        e.printStackTrace();
                    }
                    clonedAtom.setID(atom.getID());
                    clonedAtom.setFlags(atom.getFlags());
                    int countH = 0;
                    if (atom.getImplicitHydrogenCount() != null) {
                        countH = atom.getImplicitHydrogenCount();
                    }
                    clonedAtom.setImplicitHydrogenCount(countH);
                    mol.addAtom(clonedAtom);
                    map.put(atom, clonedAtom);
                    continue;
                }
                remove.add(atom);
            }
            mol = ExtAtomContainerManipulator.cloneAndMarkNonHBonds(mol, atomContainer, remove, map);
            mol = ExtAtomContainerManipulator.reComputeHydrogens(mol, atomContainer, remove, map);
        } else {
            mol = atomContainer.getBuilder().newInstance(IAtomContainer.class, atomContainer);
            if (atomContainer.getAtom(0).getSymbol().equalsIgnoreCase("H")) {
                System.err.println("WARNING: single hydrogen atom removal not supported!");
            }
            mol.setFlags(atomContainer.getFlags());
        }
        mol.addProperties(atomContainer.getProperties());
        if (atomContainer.getID() != null) {
            mol.setID(atomContainer.getID());
        }
        return mol;
    }

    @TestMethod(value="testConvertExplicitToImplicitHydrogens")
    public static IAtomContainer convertExplicitToImplicitHydrogens(IAtomContainer atomContainer) {
        IAtomContainer mol = atomContainer.getBuilder().newInstance(IAtomContainer.class, atomContainer);
        ExtAtomContainerManipulator.convertImplicitToExplicitHydrogens(mol);
        if (mol.getAtomCount() > 1) {
            mol = ExtAtomContainerManipulator.removeHydrogens(mol);
        } else if (atomContainer.atoms().iterator().next().getSymbol().equalsIgnoreCase("H")) {
            System.err.println("WARNING: single hydrogen atom removal not supported!");
        }
        mol.addProperties(atomContainer.getProperties());
        mol.setFlags(atomContainer.getFlags());
        if (atomContainer.getID() != null) {
            mol.setID(atomContainer.getID());
        }
        return mol;
    }

    @TestMethod(value="testPercieveAtomTypesAndConfigureAtoms")
    public static void percieveAtomTypesAndConfigureAtoms(IAtomContainer container) throws CDKException {
        CDKAtomTypeMatcher matcher = CDKAtomTypeMatcher.getInstance(container.getBuilder());
        for (IAtom atom : container.atoms()) {
            IAtomType matched;
            if (atom instanceof IPseudoAtom || (matched = matcher.findMatchingAtomType(container, atom)) == null) continue;
            AtomTypeManipulator.configure(atom, matched);
        }
    }

    private static IAtom[] copyAtoms(IAtomContainer container, IAtomContainer newAtomContainer) {
        int atomCount = container.getAtomCount();
        IAtom[] atoms = new IAtom[atomCount];
        for (int index = 0; index < container.getAtomCount(); ++index) {
            atoms[index] = container.getAtom(index) instanceof IPseudoAtom ? (IAtom)container.getBuilder().newInstance(IPseudoAtom.class, container.getAtom(index)) : container.getBuilder().newInstance(IAtom.class, container.getAtom(index));
            ExtAtomContainerManipulator.set2D(container, index, atoms);
            ExtAtomContainerManipulator.set3D(container, index, atoms);
            ExtAtomContainerManipulator.setFractionalPoint3d(container, index, atoms);
            ExtAtomContainerManipulator.setID(container, index, atoms);
            ExtAtomContainerManipulator.setHydrogenCount(container, index, atoms);
            ExtAtomContainerManipulator.setCharge(container, index, atoms);
            newAtomContainer.addAtom(atoms[index]);
        }
        for (IStereoElement stereoElement : container.stereoElements()) {
            newAtomContainer.addStereoElement(stereoElement);
        }
        return atoms;
    }

    private static void copyBonds(IAtom[] atoms, IAtomContainer container, IAtomContainer newAtomContainer) {
        int bondCount = container.getBondCount();
        IBond[] bonds = new IBond[bondCount];
        for (int index = 0; index < container.getBondCount(); ++index) {
            bonds[index] = new Bond();
            int IndexI = 999;
            for (int i = 0; i < container.getAtomCount(); ++i) {
                if (container.getBond(index).getAtom(0) != container.getAtom(i)) continue;
                IndexI = i;
                break;
            }
            int IndexJ = 999;
            for (int j = 0; j < container.getAtomCount(); ++j) {
                if (container.getBond(index).getAtom(1) != container.getAtom(j)) continue;
                IndexJ = j;
                break;
            }
            IAtom atom1 = atoms[IndexI];
            IAtom atom2 = atoms[IndexJ];
            IBond.Order order = container.getBond(index).getOrder();
            IBond.Stereo stereo = container.getBond(index).getStereo();
            bonds[index] = new Bond(atom1, atom2, order, stereo);
            if (container.getBond(index).getID() != null) {
                bonds[index].setID(new String(container.getBond(index).getID()));
            }
            newAtomContainer.addBond(bonds[index]);
        }
    }

    private static IAtomContainer reComputeHydrogens(IAtomContainer mol, IAtomContainer atomContainer, List<IAtom> remove, Map<IAtom, IAtom> map) {
        for (IAtom aRemove : remove) {
            for (IAtom iAtom : atomContainer.getConnectedAtomsList(aRemove)) {
                IAtom neighb = map.get(iAtom);
                if (neighb == null) continue;
                if (!(neighb instanceof IPseudoAtom)) {
                    neighb.setImplicitHydrogenCount((neighb.getImplicitHydrogenCount() == null ? 0 : neighb.getImplicitHydrogenCount()) + 1);
                    continue;
                }
                neighb.setImplicitHydrogenCount(0);
            }
        }
        mol.addProperties(atomContainer.getProperties());
        mol.setFlags(atomContainer.getFlags());
        if (atomContainer.getID() != null) {
            mol.setID(atomContainer.getID());
        }
        return mol;
    }

    private static IAtomContainer cloneAndMarkNonHBonds(IAtomContainer mol, IAtomContainer atomContainer, List<IAtom> remove, Map<IAtom, IAtom> map) {
        int count = atomContainer.getBondCount();
        for (int i = 0; i < count; ++i) {
            IBond bond = atomContainer.getBond(i);
            boolean removedBond = false;
            int length = bond.getAtomCount();
            for (int k = 0; k < length; ++k) {
                if (!remove.contains(bond.getAtom(k))) continue;
                removedBond = true;
                break;
            }
            if (removedBond) continue;
            IBond clone = null;
            try {
                clone = atomContainer.getBond(i).clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
            assert (clone != null);
            clone.setAtoms(new IAtom[]{map.get(bond.getAtom(0)), map.get(bond.getAtom(1))});
            clone.setOrder(atomContainer.getBond(i).getOrder());
            clone.setStereo(atomContainer.getBond(i).getStereo());
            mol.addBond(clone);
        }
        return mol;
    }

    private static void set2D(IAtomContainer container, int index, IAtom[] atoms) {
        if (container.getAtom(index).getPoint2d() != null) {
            atoms[index].setPoint2d(new Point2d(container.getAtom(index).getPoint2d()));
        }
    }

    private static void set3D(IAtomContainer container, int index, IAtom[] atoms) {
        if (container.getAtom(index).getPoint3d() != null) {
            atoms[index].setPoint3d(new Point3d(container.getAtom(index).getPoint3d()));
        }
    }

    private static void setFractionalPoint3d(IAtomContainer container, int index, IAtom[] atoms) {
        if (container.getAtom(index).getFractionalPoint3d() != null) {
            atoms[index].setFractionalPoint3d(new Point3d(container.getAtom(index).getFractionalPoint3d()));
        }
    }

    private static void setID(IAtomContainer container, int index, IAtom[] atoms) {
        if (container.getAtom(index).getID() != null) {
            atoms[index].setID(container.getAtom(index).getID());
        }
    }

    private static void setHydrogenCount(IAtomContainer container, int index, IAtom[] atoms) {
        if (container.getAtom(index).getImplicitHydrogenCount() != null) {
            atoms[index].setImplicitHydrogenCount((int)container.getAtom(index).getImplicitHydrogenCount());
        }
    }

    private static void setCharge(IAtomContainer container, int index, IAtom[] atoms) {
        if (container.getAtom(index).getCharge() != null) {
            atoms[index].setCharge(new Double(container.getAtom(index).getCharge()));
        }
    }
}

