/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.charges;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openscience.cdk.charges.IChargeCalculator;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.modeling.builder3d.ForceFieldConfigurator;
import org.openscience.cdk.modeling.builder3d.MMFF94BasedParameterSetReader;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class MMFF94PartialCharges
implements IChargeCalculator {
    private final ILoggingTool LOG = LoggingToolFactory.createLoggingTool(MMFF94BasedParameterSetReader.class);

    public IAtomContainer assignMMFF94PartialCharges(IAtomContainer ac) throws Exception {
        ForceFieldConfigurator ffc = new ForceFieldConfigurator();
        ffc.setForceFieldConfigurator("mmff94", ac.getBuilder());
        ffc.assignAtomTyps(ac);
        Map<String, Object> parameterSet = ffc.getParameterSet();
        double charge = 0.0;
        double formalCharge = 0.0;
        double formalChargeNeigh = 0.0;
        double theta = 0.0;
        double sumOfFormalCharges = 0.0;
        double sumOfBondIncrements = 0.0;
        IAtom thisAtom2 = null;
        Object data = null;
        Object bondData = null;
        Object dataNeigh = null;
        for (IAtom thisAtom2 : ac.atoms()) {
            this.LOG.debug((Object)("Assigning MMFF94 Charge for atom " + thisAtom2.getAtomTypeName()));
            data = parameterSet.get("data" + thisAtom2.getAtomTypeName());
            this.LOG.debug((Object)"Atom data:");
            this.LOG.debug((Object)"WellD, Apol, Neff, DA, q, pbci, A_i, G_i");
            this.LOG.debug(data);
            List neighboors = ac.getConnectedAtomsList(thisAtom2);
            this.LOG.debug((Object)("Atom has  " + neighboors.size() + " neighbour(s)"));
            formalCharge = thisAtom2.getCharge();
            this.LOG.debug((Object)("Atom's formal charge is  " + formalCharge));
            theta = (Double)((List)data).get(5);
            charge = formalCharge * (1.0 - (double)neighboors.size() * theta);
            sumOfFormalCharges = 0.0;
            sumOfBondIncrements = 0.0;
            Iterator i$ = neighboors.iterator();
            while (i$.hasNext()) {
                IAtom neighboor;
                IAtom neighbour = neighboor = (IAtom)i$.next();
                this.LOG.debug((Object)("  neighbour of " + thisAtom2.getAtomTypeName() + " is " + neighbour.getAtomTypeName()));
                dataNeigh = parameterSet.get("data" + neighbour.getAtomTypeName());
                this.LOG.debug((Object)("     dataNeigh is " + dataNeigh));
                if (parameterSet.containsKey("bond" + thisAtom2.getAtomTypeName() + ";" + neighbour.getAtomTypeName())) {
                    bondData = parameterSet.get("bond" + thisAtom2.getAtomTypeName() + ";" + neighbour.getAtomTypeName());
                    sumOfBondIncrements -= ((Double)((List)bondData).get(4)).doubleValue();
                } else if (parameterSet.containsKey("bond" + neighbour.getAtomTypeName() + ";" + thisAtom2.getAtomTypeName())) {
                    bondData = parameterSet.get("bond" + neighbour.getAtomTypeName() + ";" + thisAtom2.getAtomTypeName());
                    sumOfBondIncrements += ((Double)((List)bondData).get(4)).doubleValue();
                } else {
                    sumOfBondIncrements += theta - (Double)((List)dataNeigh).get(5);
                }
                dataNeigh = parameterSet.get("data" + neighbour.getID());
                formalChargeNeigh = neighbour.getCharge();
                sumOfFormalCharges += formalChargeNeigh;
            }
            charge += sumOfFormalCharges * theta;
            thisAtom2.setProperty((Object)"MMFF94charge", (Object)(charge += sumOfBondIncrements));
            this.LOG.debug((Object)("Final MMFF94charge on : " + thisAtom2.getAtomTypeName() + " is " + thisAtom2.getProperty((Object)"MMFF94charge") + "\n"));
        }
        return ac;
    }

    public void calculateCharges(IAtomContainer container) throws CDKException {
        try {
            this.assignMMFF94PartialCharges(container);
        }
        catch (Exception exception) {
            throw new CDKException("Could not calculate MMFF94 partial charges: " + exception.getMessage(), (Throwable)exception);
        }
    }
}

