/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.formula;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.config.IsotopeFactory;
import org.openscience.cdk.config.Isotopes;
import org.openscience.cdk.formula.IsotopeContainer;
import org.openscience.cdk.formula.IsotopePattern;
import org.openscience.cdk.formula.IsotopePatternManipulator;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.interfaces.IMolecularFormula;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.MolecularFormulaManipulator;

@TestClass(value="org.openscience.cdk.formula.IsotopePatternGeneratorTest")
public class IsotopePatternGenerator {
    private IChemObjectBuilder builder = null;
    private IsotopeFactory isoFactory;
    private IsotopePattern abundance_Mass = null;
    private ILoggingTool logger = LoggingToolFactory.createLoggingTool(IsotopePatternGenerator.class);
    private double minAbundance = 0.1;

    public IsotopePatternGenerator() {
        this(0.1);
    }

    public IsotopePatternGenerator(double minAb) {
        this.minAbundance = minAb;
        this.logger.info((Object)"Generating all Isotope structures with IsotopeGenerator");
    }

    public IsotopePattern getIsotopes(IMolecularFormula molFor) {
        if (this.builder == null) {
            try {
                this.isoFactory = Isotopes.getInstance();
                this.builder = molFor.getBuilder();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String mf = MolecularFormulaManipulator.getString(molFor, true);
        HashMap<String, Integer> tokens = new HashMap<String, Integer>();
        IMolecularFormula molecularFormula = MolecularFormulaManipulator.getMajorIsotopeMolecularFormula(mf, this.builder);
        for (IIsotope isos : molecularFormula.isotopes()) {
            tokens.put(isos.getSymbol(), molecularFormula.getIsotopeCount(isos));
        }
        for (IIsotope isos : molecularFormula.isotopes()) {
            String elementSymbol = isos.getSymbol();
            int atomCount = (Integer)tokens.get(elementSymbol);
            for (int i = 0; i < atomCount; ++i) {
                if (this.calculateAbundanceAndMass(elementSymbol)) continue;
            }
        }
        IsotopePattern isoP = IsotopePatternManipulator.sortAndNormalizedByIntensity(this.abundance_Mass);
        isoP = this.cleanAbundance(isoP, this.minAbundance);
        IsotopePattern isoPattern = IsotopePatternManipulator.sortByMass(isoP);
        return isoPattern;
    }

    private boolean calculateAbundanceAndMass(String elementSymbol) {
        double abundance;
        double mass;
        int i;
        IIsotope[] isotopes = this.isoFactory.getIsotopes(elementSymbol);
        if (isotopes == null) {
            return false;
        }
        if (isotopes.length == 0) {
            return false;
        }
        HashMap<Double, Double> isotopeMassAndAbundance = new HashMap<Double, Double>();
        IsotopePattern currentISOPattern = new IsotopePattern();
        for (i = 0; i < isotopes.length; ++i) {
            mass = isotopes[i].getExactMass();
            abundance = isotopes[i].getNaturalAbundance();
            currentISOPattern.addIsotope(new IsotopeContainer(mass, abundance));
        }
        if (this.abundance_Mass == null) {
            this.abundance_Mass = currentISOPattern;
            return true;
        }
        for (i = 0; i < this.abundance_Mass.getNumberOfIsotopes(); ++i) {
            double totalAbundance = this.abundance_Mass.getIsotopes().get(i).getIntensity();
            if (totalAbundance == 0.0) continue;
            for (int j = 0; j < currentISOPattern.getNumberOfIsotopes(); ++j) {
                abundance = currentISOPattern.getIsotopes().get(j).getIntensity();
                mass = this.abundance_Mass.getIsotopes().get(i).getMass();
                if (abundance == 0.0) continue;
                double newAbundance = totalAbundance * abundance * (double)0.01f;
                double previousMass = this.searchMass(isotopeMassAndAbundance.keySet(), mass += currentISOPattern.getIsotopes().get(j).getMass());
                if (isotopeMassAndAbundance.containsKey(previousMass)) {
                    newAbundance += ((Double)isotopeMassAndAbundance.get(previousMass)).doubleValue();
                    mass = previousMass;
                }
                if (this.isNotZero(newAbundance)) {
                    isotopeMassAndAbundance.put(mass, newAbundance);
                }
                previousMass = 0.0;
            }
        }
        Iterator itr = isotopeMassAndAbundance.keySet().iterator();
        int i2 = 0;
        this.abundance_Mass = new IsotopePattern();
        while (itr.hasNext()) {
            mass = (Double)itr.next();
            this.abundance_Mass.addIsotope(new IsotopeContainer(mass, (double)((Double)isotopeMassAndAbundance.get(mass))));
            ++i2;
        }
        return true;
    }

    private double searchMass(Set<Double> keySet, double mass) {
        double TOLERANCE = 5.0E-5f;
        for (double key : keySet) {
            double diff = Math.abs(key - mass);
            if (!(diff < TOLERANCE)) continue;
            return key;
        }
        return 0.0;
    }

    private boolean isNotZero(double number) {
        double pow = Math.pow(10.0, 6.0);
        int fraction = (int)(number * pow);
        return fraction > 0;
    }

    private IsotopePattern cleanAbundance(IsotopePattern isopattern, double minAbundance) {
        double intensity;
        double biggestIntensity = 0.0;
        for (IsotopeContainer sc : isopattern.getIsotopes()) {
            intensity = sc.getIntensity();
            if (!(intensity > biggestIntensity)) continue;
            biggestIntensity = intensity;
        }
        for (IsotopeContainer sc : isopattern.getIsotopes()) {
            intensity = sc.getIntensity();
            if ((intensity /= biggestIntensity) < 0.0) {
                intensity = 0.0;
            }
            sc.setIntensity(intensity);
        }
        IsotopePattern sortedIsoPattern = new IsotopePattern();
        sortedIsoPattern.setMonoIsotope(new IsotopeContainer(isopattern.getIsotopes().get(0).getMass(), isopattern.getIsotopes().get(0).getIntensity()));
        for (int i = 1; i < isopattern.getNumberOfIsotopes(); ++i) {
            if (!(isopattern.getIsotopes().get(i).getIntensity() >= minAbundance)) continue;
            sortedIsoPattern.addIsotope(new IsotopeContainer(isopattern.getIsotopes().get(i).getMass(), isopattern.getIsotopes().get(i).getIntensity()));
        }
        return sortedIsoPattern;
    }
}

