/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.stereo;

import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.ITetrahedralChirality;

@TestClass(value="org.openscience.cdk.stereo.StereoToolTest")
public class StereoTool {
    public static final double MAX_AXIS_ANGLE = 0.95;
    public static final double MIN_COLINEAR_NORMAL = 0.05;
    public static final double PLANE_TOLERANCE = 0.05;

    @TestMethod(value="squarePlanarTest")
    public static boolean isSquarePlanar(IAtom atomA, IAtom atomB, IAtom atomC, IAtom atomD) {
        Point3d pointA = atomA.getPoint3d();
        Point3d pointB = atomB.getPoint3d();
        Point3d pointC = atomC.getPoint3d();
        Point3d pointD = atomD.getPoint3d();
        return StereoTool.isSquarePlanar(pointA, pointB, pointC, pointD);
    }

    private static boolean isSquarePlanar(Point3d pointA, Point3d pointB, Point3d pointC, Point3d pointD) {
        return StereoTool.isSquarePlanar(pointA, pointB, pointC, pointD, new Vector3d());
    }

    private static boolean isSquarePlanar(Point3d pointA, Point3d pointB, Point3d pointC, Point3d pointD, Vector3d normal) {
        Vector3d vectorAB = new Vector3d();
        Vector3d vectorAC = new Vector3d();
        StereoTool.getRawNormal(pointA, pointB, pointC, normal, vectorAB, vectorAC);
        if (StereoTool.isColinear(normal)) {
            return false;
        }
        return StereoTool.allCoplanar(normal, pointC, pointD);
    }

    @TestMethod(value="squarePlanarUShapeTest, squarePlanarZShapeTest, squarePlanar4ShapeTest")
    public static SquarePlanarShape getSquarePlanarShape(IAtom atomA, IAtom atomB, IAtom atomC, IAtom atomD) {
        Point3d pointA = atomA.getPoint3d();
        Point3d pointB = atomB.getPoint3d();
        Point3d pointC = atomC.getPoint3d();
        Point3d pointD = atomD.getPoint3d();
        Vector3d normalA = new Vector3d();
        Vector3d normalB = new Vector3d();
        Vector3d normalC = new Vector3d();
        Vector3d tmpX = new Vector3d();
        Vector3d tmpY = new Vector3d();
        StereoTool.getRawNormal(pointA, pointB, pointC, normalA, tmpX, tmpY);
        StereoTool.getRawNormal(pointB, pointC, pointD, normalB, tmpX, tmpY);
        StereoTool.getRawNormal(pointC, pointD, pointA, normalC, tmpX, tmpY);
        normalA.normalize();
        normalB.normalize();
        normalC.normalize();
        double aDotB = normalA.dot(normalB);
        double aDotC = normalA.dot(normalC);
        double bDotC = normalB.dot(normalC);
        if (aDotB > 0.0 && aDotC > 0.0 && bDotC > 0.0) {
            return SquarePlanarShape.U_SHAPE;
        }
        if (aDotB > 0.0 && aDotC < 0.0 && bDotC < 0.0) {
            return SquarePlanarShape.FOUR_SHAPE;
        }
        return SquarePlanarShape.Z_SHAPE;
    }

    @TestMethod(value="allCoplanarTest")
    public static boolean allCoplanar(Vector3d planeNormal, Point3d pointInPlane, Point3d ... points) {
        for (Point3d point : points) {
            double distance = StereoTool.signedDistanceToPlane(planeNormal, pointInPlane, point);
            if (distance < 0.05) continue;
            return false;
        }
        return true;
    }

    @TestMethod(value="octahedralTest")
    public static boolean isOctahedral(IAtom atomA, IAtom atomB, IAtom atomC, IAtom atomD, IAtom atomE, IAtom atomF, IAtom atomG) {
        Point3d pointA = atomA.getPoint3d();
        Point3d pointB = atomB.getPoint3d();
        Point3d pointC = atomC.getPoint3d();
        Point3d pointD = atomD.getPoint3d();
        Point3d pointE = atomE.getPoint3d();
        Point3d pointF = atomF.getPoint3d();
        Point3d pointG = atomG.getPoint3d();
        boolean isColinearABG = StereoTool.isColinear(pointA, pointB, pointG);
        if (!isColinearABG) {
            return false;
        }
        Vector3d normal = new Vector3d();
        StereoTool.isSquarePlanar(pointC, pointD, pointE, pointF, normal);
        Vector3d vectorAB = new Vector3d((Tuple3d)pointA);
        vectorAB.sub((Tuple3d)pointB);
        return normal.dot(vectorAB) < 0.0;
    }

    @TestMethod(value="trigonalBipyramidalTest")
    public static boolean isTrigonalBipyramidal(IAtom atomA, IAtom atomB, IAtom atomC, IAtom atomD, IAtom atomE, IAtom atomF) {
        Point3d pointA = atomA.getPoint3d();
        Point3d pointB = atomB.getPoint3d();
        Point3d pointC = atomC.getPoint3d();
        Point3d pointD = atomD.getPoint3d();
        Point3d pointE = atomE.getPoint3d();
        Point3d pointF = atomF.getPoint3d();
        boolean isColinearABF = StereoTool.isColinear(pointA, pointB, pointF);
        if (isColinearABF) {
            TetrahedralSign handednessCDEF;
            Vector3d normal = StereoTool.getNormal(pointC, pointD, pointE);
            TetrahedralSign handednessCDEA = StereoTool.getHandedness(normal, pointC, pointF);
            return handednessCDEA != (handednessCDEF = StereoTool.getHandedness(normal, pointC, pointA));
        }
        return false;
    }

    @TestMethod(value="getStereoCWTest, getStereoACWTest")
    public static ITetrahedralChirality.Stereo getStereo(IAtom atom1, IAtom atom2, IAtom atom3, IAtom atom4) {
        TetrahedralSign sign = StereoTool.getHandedness(atom2, atom3, atom4, atom1);
        if (sign == TetrahedralSign.PLUS) {
            return ITetrahedralChirality.Stereo.ANTI_CLOCKWISE;
        }
        return ITetrahedralChirality.Stereo.CLOCKWISE;
    }

    @TestMethod(value="tetrahedralPlusAtomsAboveXYClockwiseTest, tetrahedralPlusAtomsAboveXYTest,tetrahedralMinusAtomsAboveXYTest,tetrahedralPlusAtomsBelowXYTest,tetrahedralMinusAtomsBelowXYTest")
    public static TetrahedralSign getHandedness(IAtom baseAtomA, IAtom baseAtomB, IAtom baseAtomC, IAtom apexAtom) {
        Point3d pointA = baseAtomA.getPoint3d();
        Point3d pointB = baseAtomB.getPoint3d();
        Point3d pointC = baseAtomC.getPoint3d();
        Point3d pointD = apexAtom.getPoint3d();
        return StereoTool.getHandedness(pointA, pointB, pointC, pointD);
    }

    private static TetrahedralSign getHandedness(Point3d pointA, Point3d pointB, Point3d pointC, Point3d pointD) {
        Vector3d normal = StereoTool.getNormal(pointA, pointB, pointC);
        return StereoTool.getHandedness(normal, pointA, pointD);
    }

    private static TetrahedralSign getHandedness(Vector3d planeNormal, Point3d pointInPlane, Point3d testPoint) {
        double distance = StereoTool.signedDistanceToPlane(planeNormal, pointInPlane, testPoint);
        if (distance > 0.0) {
            return TetrahedralSign.PLUS;
        }
        return TetrahedralSign.MINUS;
    }

    @TestMethod(value="colinearTestWithColinearPoints,colinearTestWithNearlyColinearPoints,colinearTestWithNonColinearPoints")
    public static boolean isColinear(Point3d ptA, Point3d ptB, Point3d ptC) {
        Vector3d vectorAB = new Vector3d();
        Vector3d vectorAC = new Vector3d();
        Vector3d normal = new Vector3d();
        StereoTool.getRawNormal(ptA, ptB, ptC, normal, vectorAB, vectorAC);
        return StereoTool.isColinear(normal);
    }

    private static boolean isColinear(Vector3d normal) {
        double baCrossACLen = normal.length();
        return baCrossACLen < 0.05;
    }

    @TestMethod(value="positivePointPlaneDistanceTest, negativePointPlaneDistanceTest")
    public static double signedDistanceToPlane(Vector3d planeNormal, Point3d pointInPlane, Point3d point) {
        if (planeNormal == null) {
            return Double.NaN;
        }
        Vector3d pointPointDiff = new Vector3d();
        pointPointDiff.sub((Tuple3d)point, (Tuple3d)pointInPlane);
        return planeNormal.dot(pointPointDiff);
    }

    @TestMethod(value="getNormalFromThreePoints")
    public static Vector3d getNormal(Point3d ptA, Point3d ptB, Point3d ptC) {
        Vector3d vectorAB = new Vector3d();
        Vector3d vectorAC = new Vector3d();
        Vector3d normal = new Vector3d();
        StereoTool.getRawNormal(ptA, ptB, ptC, normal, vectorAB, vectorAC);
        normal.normalize();
        return normal;
    }

    private static void getRawNormal(Point3d ptA, Point3d ptB, Point3d ptC, Vector3d normal, Vector3d vcAB, Vector3d vcAC) {
        vcAB.sub((Tuple3d)ptB, (Tuple3d)ptA);
        vcAC.sub((Tuple3d)ptC, (Tuple3d)ptA);
        normal.cross(vcAB, vcAC);
    }

    public static enum SquarePlanarShape {
        U_SHAPE,
        FOUR_SHAPE,
        Z_SHAPE;

    }

    public static enum TetrahedralSign {
        PLUS,
        MINUS;

    }

    public static enum StereoClass {
        TETRAHEDRAL,
        SQUARE_PLANAR,
        TRIGONAL_BIPYRAMIDAL,
        OCTAHEDRAL;

    }
}

