/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.hash.stereo;

import java.util.Arrays;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.hash.stereo.GeometricParity;
import org.openscience.cdk.hash.stereo.PermutationParity;
import org.openscience.cdk.hash.stereo.StereoEncoder;

@TestClass(value="org.openscience.cdk.hash.stereo.GeometryEncoderTest")
final class GeometryEncoder
implements StereoEncoder {
    private static final long CLOCKWISE = 15543053L;
    private static final long ANTICLOCKWISE = 15521419L;
    private final PermutationParity permutation;
    private final GeometricParity geometric;
    private final int[] centres;

    @TestMethod(value="testConstruction_Empty")
    public GeometryEncoder(int[] centres, PermutationParity permutation, GeometricParity geometric) {
        if (centres.length == 0) {
            throw new IllegalArgumentException("no centres[] provided");
        }
        this.permutation = permutation;
        this.geometric = geometric;
        this.centres = Arrays.copyOf(centres, centres.length);
    }

    @TestMethod(value="testConstruction_Singleton")
    public GeometryEncoder(int centre, PermutationParity permutation, GeometricParity geometric) {
        this(new int[]{centre}, permutation, geometric);
    }

    @Override
    @TestMethod(value="testEncode_Clockwise,testEncode_Anticlockwise,testEncode_Clockwise_Alt,testEncode_Anticlockwise_Alt,testEncode_Clockwise_Two, testEncode_Anticlockwise_Two,testEncode_NoGeometry,testEncode_NoPermutation")
    public boolean encode(long[] current, long[] next) {
        int p = this.permutation.parity(current);
        if (p != 0) {
            int q = this.geometric.parity() * p;
            if (q > 0) {
                for (int i : this.centres) {
                    next[i] = current[i] * 15521419L;
                }
            } else if (q < 0) {
                for (int i : this.centres) {
                    next[i] = current[i] * 15543053L;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    @TestMethod(value="testReset")
    public void reset() {
    }
}

