/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.font;

import java.awt.Font;
import java.util.HashMap;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.renderer.font.AbstractFontManager;
import org.openscience.cdk.renderer.font.IFontManager;

@TestClass(value="org.openscience.cdk.renderer.font.AWTFontManagerTest")
public class AWTFontManager
extends AbstractFontManager {
    private HashMap<Integer, Font> fontSizeToFontMap;
    private int minFontSize = 9;
    private Font currentFont;

    @TestMethod(value="testConstructor")
    public AWTFontManager() {
        this.makeFonts();
        this.toMiddle();
        this.resetVirtualCounts();
    }

    @Override
    protected void makeFonts() {
        int size = this.minFontSize;
        double scale = 0.5;
        this.fontSizeToFontMap = new HashMap();
        for (int i = 0; i < 20; ++i) {
            if (super.getFontStyle() == IFontManager.FontStyle.NORMAL) {
                this.fontSizeToFontMap.put(size, new Font(super.getFontName(), 0, size));
            } else {
                this.fontSizeToFontMap.put(size, new Font(super.getFontName(), 1, size));
            }
            this.registerFontSizeMapping(scale, size);
            ++size;
            scale += 0.1;
        }
    }

    public void setFontForZoom(double zoom) {
        int size = this.getFontSizeForZoom(zoom);
        if (size != -1) {
            this.currentFont = this.fontSizeToFontMap.get(size);
        }
    }

    public Font getFont() {
        return this.currentFont;
    }
}

