/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.beam;

import java.util.BitSet;
import uk.ac.ebi.beam.Edge;
import uk.ac.ebi.beam.Graph;
import uk.ac.ebi.beam.Localise;

final class ElectronAssignment {
    private ElectronAssignment() {
    }

    private static boolean containsOddCardinalitySubgraph(Graph g, BitSet bs) {
        boolean[] visited = new boolean[g.order()];
        int i = bs.nextClearBit(0);
        while (i < g.order()) {
            visited[i] = true;
            i = bs.nextClearBit(i + 1);
        }
        i = bs.nextSetBit(0);
        while (i >= 0) {
            if (!visited[i] && ElectronAssignment.isOdd(ElectronAssignment.visit(g, i, 0, visited))) {
                return true;
            }
            i = bs.nextSetBit(i + 1);
        }
        return false;
    }

    private static int visit(Graph g, int v, int c, boolean[] visited) {
        visited[v] = true;
        for (Edge e : g.edges(v)) {
            int w = e.other(v);
            if (visited[w] || e.bond().order() != 1) continue;
            c = ElectronAssignment.visit(g, w, c, visited);
        }
        return 1 + c;
    }

    private static boolean isOdd(int x) {
        return (x & 1) == 1;
    }

    static boolean verify(Graph g) {
        return !g.isDelocalised() || !ElectronAssignment.containsOddCardinalitySubgraph(g, Localise.buildSet(g, new BitSet()));
    }
}

