/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.formula;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.openscience.cdk.config.IsotopeFactory;
import org.openscience.cdk.config.Isotopes;
import org.openscience.cdk.formula.IsotopeContainer;
import org.openscience.cdk.formula.IsotopePattern;
import org.openscience.cdk.formula.IsotopePatternManipulator;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.interfaces.IMolecularFormula;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.MolecularFormulaManipulator;

public class IsotopePatternGenerator {
    private IChemObjectBuilder builder = null;
    private IsotopeFactory isoFactory;
    private ILoggingTool logger = LoggingToolFactory.createLoggingTool(IsotopePatternGenerator.class);
    private double minAbundance = 0.1;

    public IsotopePatternGenerator() {
        this(0.1);
    }

    public IsotopePatternGenerator(double minAb) {
        this.minAbundance = minAb;
        this.logger.info("Generating all Isotope structures with IsotopeGenerator");
    }

    public IsotopePattern getIsotopes(IMolecularFormula molFor) {
        if (this.builder == null) {
            try {
                this.isoFactory = Isotopes.getInstance();
                this.builder = molFor.getBuilder();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String mf = MolecularFormulaManipulator.getString(molFor, true);
        IMolecularFormula molecularFormula = MolecularFormulaManipulator.getMajorIsotopeMolecularFormula(mf, this.builder);
        IsotopePattern abundance_Mass = null;
        for (IIsotope isos : molecularFormula.isotopes()) {
            String elementSymbol = isos.getSymbol();
            int atomCount = molecularFormula.getIsotopeCount(isos);
            for (int i = 0; i < atomCount; ++i) {
                abundance_Mass = this.calculateAbundanceAndMass(abundance_Mass, elementSymbol);
            }
        }
        IsotopePattern isoP = IsotopePatternManipulator.sortAndNormalizedByIntensity(abundance_Mass);
        isoP = this.cleanAbundance(isoP, this.minAbundance);
        IsotopePattern isoPattern = IsotopePatternManipulator.sortByMass(isoP);
        return isoPattern;
    }

    private IsotopePattern calculateAbundanceAndMass(IsotopePattern isotopePattern, String elementSymbol) {
        double abundance;
        double mass;
        int i;
        IIsotope[] isotopes = this.isoFactory.getIsotopes(elementSymbol);
        if (isotopes == null) {
            return isotopePattern;
        }
        if (isotopes.length == 0) {
            return isotopePattern;
        }
        HashMap<Double, Double> isotopeMassAndAbundance = new HashMap<Double, Double>();
        IsotopePattern currentISOPattern = new IsotopePattern();
        for (i = 0; i < isotopes.length; ++i) {
            mass = isotopes[i].getExactMass();
            abundance = isotopes[i].getNaturalAbundance();
            currentISOPattern.addIsotope(new IsotopeContainer(mass, abundance));
        }
        if (isotopePattern == null) {
            isotopePattern = currentISOPattern;
        } else {
            for (i = 0; i < isotopePattern.getNumberOfIsotopes(); ++i) {
                double totalAbundance = isotopePattern.getIsotopes().get(i).getIntensity();
                if (totalAbundance == 0.0) continue;
                for (int j = 0; j < currentISOPattern.getNumberOfIsotopes(); ++j) {
                    abundance = currentISOPattern.getIsotopes().get(j).getIntensity();
                    mass = isotopePattern.getIsotopes().get(i).getMass();
                    if (abundance == 0.0) continue;
                    double newAbundance = totalAbundance * abundance * 0.01;
                    double previousMass = this.searchMass(isotopeMassAndAbundance.keySet(), mass += currentISOPattern.getIsotopes().get(j).getMass());
                    if (isotopeMassAndAbundance.containsKey(previousMass)) {
                        newAbundance += ((Double)isotopeMassAndAbundance.get(previousMass)).doubleValue();
                        mass = previousMass;
                    }
                    if (newAbundance > 1.0E-10) {
                        isotopeMassAndAbundance.put(mass, newAbundance);
                    }
                    previousMass = 0.0;
                }
            }
            Iterator itr = isotopeMassAndAbundance.keySet().iterator();
            isotopePattern = new IsotopePattern();
            while (itr.hasNext()) {
                mass = (Double)itr.next();
                isotopePattern.addIsotope(new IsotopeContainer(mass, (double)((Double)isotopeMassAndAbundance.get(mass))));
            }
        }
        return isotopePattern;
    }

    private double searchMass(Set<Double> keySet, double mass) {
        double TOLERANCE = 5.0E-5f;
        for (double key : keySet) {
            double diff = Math.abs(key - mass);
            if (!(diff < TOLERANCE)) continue;
            return key;
        }
        return 0.0;
    }

    private IsotopePattern cleanAbundance(IsotopePattern isopattern, double minAbundance) {
        double intensity;
        double biggestIntensity = 0.0;
        for (IsotopeContainer sc : isopattern.getIsotopes()) {
            intensity = sc.getIntensity();
            if (!(intensity > biggestIntensity)) continue;
            biggestIntensity = intensity;
        }
        for (IsotopeContainer sc : isopattern.getIsotopes()) {
            intensity = sc.getIntensity();
            if ((intensity /= biggestIntensity) < 0.0) {
                intensity = 0.0;
            }
            sc.setIntensity(intensity);
        }
        IsotopePattern sortedIsoPattern = new IsotopePattern();
        sortedIsoPattern.setMonoIsotope(new IsotopeContainer(isopattern.getIsotopes().get(0).getMass(), isopattern.getIsotopes().get(0).getIntensity()));
        for (int i = 1; i < isopattern.getNumberOfIsotopes(); ++i) {
            if (!(isopattern.getIsotopes().get(i).getIntensity() >= minAbundance)) continue;
            sortedIsoPattern.addIsotope(new IsotopeContainer(isopattern.getIsotopes().get(i).getMass(), isopattern.getIsotopes().get(i).getIntensity()));
        }
        return sortedIsoPattern;
    }
}

