/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.cml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.dict.DictRef;
import org.openscience.cdk.geometry.CrystalGeometryTools;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.interfaces.ICrystal;
import org.openscience.cdk.interfaces.IMonomer;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.IReactionSet;
import org.openscience.cdk.interfaces.ISingleElectron;
import org.openscience.cdk.interfaces.IStrand;
import org.openscience.cdk.interfaces.ITetrahedralChirality;
import org.openscience.cdk.io.cml.CMLStack;
import org.openscience.cdk.io.cml.ICMLModule;
import org.openscience.cdk.stereo.TetrahedralChirality;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.BondManipulator;
import org.openscience.cdk.tools.periodictable.PeriodicTable;
import org.xml.sax.Attributes;

public class CMLCoreModule
implements ICMLModule {
    protected ILoggingTool logger = LoggingToolFactory.createLoggingTool(CMLCoreModule.class);
    protected final String SYSTEMID = "CML-1999-05-15";
    protected IChemFile currentChemFile;
    protected IAtomContainer currentMolecule;
    protected IAtomContainerSet currentMoleculeSet;
    protected IChemModel currentChemModel;
    protected IChemSequence currentChemSequence;
    protected IReactionSet currentReactionSet;
    protected IReaction currentReaction;
    protected IAtom currentAtom;
    protected IBond currentBond;
    protected IStrand currentStrand;
    protected IMonomer currentMonomer;
    protected Map<String, IAtom> atomEnumeration;
    protected List<String> moleculeCustomProperty;
    protected int formulaCounter;
    protected int atomCounter;
    protected List<String> elsym;
    protected List<String> eltitles;
    protected List<String> elid;
    protected List<String> formula;
    protected List<String> formalCharges;
    protected List<String> partialCharges;
    protected List<String> isotope;
    protected List<String> atomicNumbers;
    protected List<String> exactMasses;
    protected List<String> x3;
    protected List<String> y3;
    protected List<String> z3;
    protected List<String> x2;
    protected List<String> y2;
    protected List<String> xfract;
    protected List<String> yfract;
    protected List<String> zfract;
    protected List<String> hCounts;
    protected List<String> atomParities;
    protected List<String> parityARef1;
    protected List<String> parityARef2;
    protected List<String> parityARef3;
    protected List<String> parityARef4;
    protected List<String> atomDictRefs;
    protected List<String> atomAromaticities;
    protected List<String> spinMultiplicities;
    protected List<String> occupancies;
    protected Map<Integer, List<String>> atomCustomProperty;
    protected boolean parityAtomsGiven;
    protected boolean parityGiven;
    protected int bondCounter;
    protected List<String> bondid;
    protected List<String> bondARef1;
    protected List<String> bondARef2;
    protected List<String> order;
    protected List<String> bondStereo;
    protected List<String> bondDictRefs;
    protected List<String> bondElid;
    protected List<Boolean> bondAromaticity;
    protected Map<String, Map<String, String>> bondCustomProperty;
    protected boolean stereoGiven;
    protected String inchi;
    protected int curRef;
    protected int CurrentElement;
    protected String BUILTIN;
    protected String DICTREF;
    protected String elementTitle;
    protected String currentChars;
    protected double[] unitcellparams;
    protected int crystalScalar;
    boolean cartesianAxesSet = false;

    public CMLCoreModule(IChemFile chemFile) {
        this.currentChemFile = chemFile;
    }

    public CMLCoreModule(ICMLModule conv) {
        this.inherit(conv);
    }

    @Override
    public void inherit(ICMLModule convention) {
        if (convention instanceof CMLCoreModule) {
            CMLCoreModule conv = (CMLCoreModule)convention;
            this.currentChemFile = conv.currentChemFile;
            this.currentMolecule = conv.currentMolecule;
            this.currentMoleculeSet = conv.currentMoleculeSet;
            this.currentChemModel = conv.currentChemModel;
            this.currentChemSequence = conv.currentChemSequence;
            this.currentReactionSet = conv.currentReactionSet;
            this.currentReaction = conv.currentReaction;
            this.currentAtom = conv.currentAtom;
            this.currentStrand = conv.currentStrand;
            this.currentMonomer = conv.currentMonomer;
            this.atomEnumeration = conv.atomEnumeration;
            this.moleculeCustomProperty = conv.moleculeCustomProperty;
            this.logger = conv.logger;
            this.BUILTIN = conv.BUILTIN;
            this.atomCounter = conv.atomCounter;
            this.formulaCounter = conv.formulaCounter;
            this.elsym = conv.elsym;
            this.eltitles = conv.eltitles;
            this.elid = conv.elid;
            this.formalCharges = conv.formalCharges;
            this.partialCharges = conv.partialCharges;
            this.isotope = conv.isotope;
            this.atomicNumbers = conv.atomicNumbers;
            this.exactMasses = conv.exactMasses;
            this.x3 = conv.x3;
            this.y3 = conv.y3;
            this.z3 = conv.z3;
            this.x2 = conv.x2;
            this.y2 = conv.y2;
            this.xfract = conv.xfract;
            this.yfract = conv.yfract;
            this.zfract = conv.zfract;
            this.hCounts = conv.hCounts;
            this.atomParities = conv.atomParities;
            this.parityARef1 = conv.parityARef1;
            this.parityARef2 = conv.parityARef2;
            this.parityARef3 = conv.parityARef3;
            this.parityARef4 = conv.parityARef4;
            this.atomDictRefs = conv.atomDictRefs;
            this.atomAromaticities = conv.atomAromaticities;
            this.spinMultiplicities = conv.spinMultiplicities;
            this.occupancies = conv.occupancies;
            this.bondCounter = conv.bondCounter;
            this.bondid = conv.bondid;
            this.bondARef1 = conv.bondARef1;
            this.bondARef2 = conv.bondARef2;
            this.order = conv.order;
            this.bondStereo = conv.bondStereo;
            this.bondCustomProperty = conv.bondCustomProperty;
            this.atomCustomProperty = conv.atomCustomProperty;
            this.bondDictRefs = conv.bondDictRefs;
            this.bondAromaticity = conv.bondAromaticity;
            this.curRef = conv.curRef;
            this.unitcellparams = conv.unitcellparams;
            this.inchi = conv.inchi;
        } else {
            this.logger.warn("Cannot inherit information from module: ", convention.getClass().getName());
        }
    }

    @Override
    public IChemFile returnChemFile() {
        return this.currentChemFile;
    }

    protected void newMolecule() {
        this.newMoleculeData();
        this.newAtomData();
        this.newBondData();
        this.newCrystalData();
        this.newFormulaData();
    }

    protected void newMoleculeData() {
        this.inchi = null;
    }

    protected void newFormulaData() {
        this.formulaCounter = 0;
        this.formula = new ArrayList<String>();
    }

    protected void newAtomData() {
        this.atomCounter = 0;
        this.elsym = new ArrayList<String>();
        this.elid = new ArrayList<String>();
        this.eltitles = new ArrayList<String>();
        this.formalCharges = new ArrayList<String>();
        this.partialCharges = new ArrayList<String>();
        this.isotope = new ArrayList<String>();
        this.atomicNumbers = new ArrayList<String>();
        this.exactMasses = new ArrayList<String>();
        this.x3 = new ArrayList<String>();
        this.y3 = new ArrayList<String>();
        this.z3 = new ArrayList<String>();
        this.x2 = new ArrayList<String>();
        this.y2 = new ArrayList<String>();
        this.xfract = new ArrayList<String>();
        this.yfract = new ArrayList<String>();
        this.zfract = new ArrayList<String>();
        this.hCounts = new ArrayList<String>();
        this.atomParities = new ArrayList<String>();
        this.parityARef1 = new ArrayList<String>();
        this.parityARef2 = new ArrayList<String>();
        this.parityARef3 = new ArrayList<String>();
        this.parityARef4 = new ArrayList<String>();
        this.atomAromaticities = new ArrayList<String>();
        this.atomDictRefs = new ArrayList<String>();
        this.spinMultiplicities = new ArrayList<String>();
        this.occupancies = new ArrayList<String>();
        this.atomCustomProperty = new HashMap<Integer, List<String>>();
    }

    protected void newBondData() {
        this.bondCounter = 0;
        this.bondid = new ArrayList<String>();
        this.bondARef1 = new ArrayList<String>();
        this.bondARef2 = new ArrayList<String>();
        this.order = new ArrayList<String>();
        this.bondStereo = new ArrayList<String>();
        this.bondCustomProperty = new Hashtable<String, Map<String, String>>();
        this.bondDictRefs = new ArrayList<String>();
        this.bondElid = new ArrayList<String>();
        this.bondAromaticity = new ArrayList<Boolean>();
    }

    protected void newCrystalData() {
        this.unitcellparams = new double[6];
        this.cartesianAxesSet = false;
        this.crystalScalar = 0;
    }

    @Override
    public void startDocument() {
        this.logger.info("Start XML Doc");
        this.currentChemSequence = this.currentChemFile.getBuilder().newInstance(IChemSequence.class, new Object[0]);
        this.currentChemModel = this.currentChemFile.getBuilder().newInstance(IChemModel.class, new Object[0]);
        this.currentMoleculeSet = this.currentChemFile.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
        this.currentMolecule = this.currentChemFile.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        this.atomEnumeration = new HashMap<String, IAtom>();
        this.moleculeCustomProperty = new ArrayList<String>();
        this.newMolecule();
        this.BUILTIN = "";
        this.curRef = 0;
    }

    @Override
    public void endDocument() {
        if (this.currentReactionSet != null && this.currentReactionSet.getReactionCount() == 0 && this.currentReaction != null) {
            this.logger.debug("Adding reaction to ReactionSet");
            this.currentReactionSet.addReaction(this.currentReaction);
        }
        if (this.currentReactionSet != null && this.currentChemModel.getReactionSet() == null) {
            this.logger.debug("Adding SOR to ChemModel");
            this.currentChemModel.setReactionSet(this.currentReactionSet);
        }
        if (this.currentMoleculeSet != null && this.currentMoleculeSet.getAtomContainerCount() != 0) {
            this.logger.debug("Adding reaction to MoleculeSet");
            this.currentChemModel.setMoleculeSet(this.currentMoleculeSet);
        }
        if (this.currentChemSequence.getChemModelCount() == 0) {
            this.logger.debug("Adding ChemModel to ChemSequence");
            this.currentChemSequence.addChemModel(this.currentChemModel);
        }
        if (this.currentChemFile.getChemSequenceCount() == 0) {
            this.currentChemFile.addChemSequence(this.currentChemSequence);
        }
        this.logger.info("End XML Doc");
    }

    @Override
    public void startElement(CMLStack xpath, String uri, String local, String raw, Attributes atts) {
        block108: {
            String att;
            int i;
            String name;
            block120: {
                block119: {
                    block118: {
                        block117: {
                            block116: {
                                block115: {
                                    block114: {
                                        block113: {
                                            block112: {
                                                block111: {
                                                    block110: {
                                                        block109: {
                                                            block107: {
                                                                name = local;
                                                                this.logger.debug("StartElement");
                                                                this.currentChars = "";
                                                                this.BUILTIN = "";
                                                                this.DICTREF = "";
                                                                for (i = 0; i < atts.getLength(); ++i) {
                                                                    String qname = atts.getQName(i);
                                                                    if (qname.equals("builtin")) {
                                                                        this.BUILTIN = atts.getValue(i);
                                                                        this.logger.debug(name, "->BUILTIN found: ", atts.getValue(i));
                                                                        continue;
                                                                    }
                                                                    if (qname.equals("dictRef")) {
                                                                        this.DICTREF = atts.getValue(i);
                                                                        this.logger.debug(name, "->DICTREF found: ", atts.getValue(i));
                                                                        continue;
                                                                    }
                                                                    if (qname.equals("title")) {
                                                                        this.elementTitle = atts.getValue(i);
                                                                        this.logger.debug(name, "->TITLE found: ", atts.getValue(i));
                                                                        continue;
                                                                    }
                                                                    this.logger.debug("Qname: ", qname);
                                                                }
                                                                if (!"atom".equals(name)) break block107;
                                                                ++this.atomCounter;
                                                                for (i = 0; i < atts.getLength(); ++i) {
                                                                    StringTokenizer tokenizer;
                                                                    att = atts.getQName(i);
                                                                    String value = atts.getValue(i);
                                                                    if (att.equals("id")) {
                                                                        this.elid.add(value);
                                                                    } else if (att.equals("elementType")) {
                                                                        this.elsym.add(value);
                                                                    } else if (att.equals("title")) {
                                                                        this.eltitles.add(value);
                                                                    } else if (att.equals("x2")) {
                                                                        this.x2.add(value);
                                                                    } else if (att.equals("xy2")) {
                                                                        tokenizer = new StringTokenizer(value);
                                                                        this.x2.add(tokenizer.nextToken());
                                                                        this.y2.add(tokenizer.nextToken());
                                                                    } else if (att.equals("xyzFract")) {
                                                                        tokenizer = new StringTokenizer(value);
                                                                        this.xfract.add(tokenizer.nextToken());
                                                                        this.yfract.add(tokenizer.nextToken());
                                                                        this.zfract.add(tokenizer.nextToken());
                                                                    } else if (att.equals("xyz3")) {
                                                                        tokenizer = new StringTokenizer(value);
                                                                        this.x3.add(tokenizer.nextToken());
                                                                        this.y3.add(tokenizer.nextToken());
                                                                        this.z3.add(tokenizer.nextToken());
                                                                    } else if (att.equals("y2")) {
                                                                        this.y2.add(value);
                                                                    } else if (att.equals("x3")) {
                                                                        this.x3.add(value);
                                                                    } else if (att.equals("y3")) {
                                                                        this.y3.add(value);
                                                                    } else if (att.equals("z3")) {
                                                                        this.z3.add(value);
                                                                    } else if (att.equals("xFract")) {
                                                                        this.xfract.add(value);
                                                                    } else if (att.equals("yFract")) {
                                                                        this.yfract.add(value);
                                                                    } else if (att.equals("zFract")) {
                                                                        this.zfract.add(value);
                                                                    } else if (att.equals("formalCharge")) {
                                                                        this.formalCharges.add(value);
                                                                    } else if (att.equals("hydrogenCount")) {
                                                                        this.hCounts.add(value);
                                                                    } else if (att.equals("isotopeNumber")) {
                                                                        this.isotope.add(value);
                                                                    } else if (att.equals("dictRef")) {
                                                                        this.logger.debug("occupancy: " + value);
                                                                        this.atomDictRefs.add(value);
                                                                    } else if (att.equals("spinMultiplicity")) {
                                                                        this.spinMultiplicities.add(value);
                                                                    } else if (att.equals("occupancy")) {
                                                                        this.occupancies.add(value);
                                                                    } else {
                                                                        this.logger.warn("Unparsed attribute: " + att);
                                                                    }
                                                                    this.parityAtomsGiven = false;
                                                                    this.parityGiven = false;
                                                                }
                                                                break block108;
                                                            }
                                                            if (!"atomArray".equals(name) || xpath.endsWith("formula", "atomArray")) break block109;
                                                            boolean atomsCounted = false;
                                                            for (int i2 = 0; i2 < atts.getLength(); ++i2) {
                                                                String att2 = atts.getQName(i2);
                                                                int count = 0;
                                                                if (att2.equals("atomID")) {
                                                                    count = this.addArrayElementsTo(this.elid, atts.getValue(i2));
                                                                } else if (att2.equals("elementType")) {
                                                                    count = this.addArrayElementsTo(this.elsym, atts.getValue(i2));
                                                                } else if (att2.equals("x2")) {
                                                                    count = this.addArrayElementsTo(this.x2, atts.getValue(i2));
                                                                } else if (att2.equals("y2")) {
                                                                    count = this.addArrayElementsTo(this.y2, atts.getValue(i2));
                                                                } else if (att2.equals("x3")) {
                                                                    count = this.addArrayElementsTo(this.x3, atts.getValue(i2));
                                                                } else if (att2.equals("y3")) {
                                                                    count = this.addArrayElementsTo(this.y3, atts.getValue(i2));
                                                                } else if (att2.equals("z3")) {
                                                                    count = this.addArrayElementsTo(this.z3, atts.getValue(i2));
                                                                } else if (att2.equals("xFract")) {
                                                                    count = this.addArrayElementsTo(this.xfract, atts.getValue(i2));
                                                                } else if (att2.equals("yFract")) {
                                                                    count = this.addArrayElementsTo(this.yfract, atts.getValue(i2));
                                                                } else if (att2.equals("zFract")) {
                                                                    count = this.addArrayElementsTo(this.zfract, atts.getValue(i2));
                                                                } else {
                                                                    this.logger.warn("Unparsed attribute: " + att2);
                                                                }
                                                                if (atomsCounted) continue;
                                                                this.atomCounter += count;
                                                                atomsCounted = true;
                                                            }
                                                            break block108;
                                                        }
                                                        if (!"atomParity".equals(name)) break block110;
                                                        for (i = 0; i < atts.getLength(); ++i) {
                                                            att = atts.getQName(i);
                                                            if (!att.equals("atomRefs4") || this.parityAtomsGiven) continue;
                                                            try {
                                                                StringTokenizer st = new StringTokenizer(atts.getValue(i));
                                                                this.parityARef1.add((String)st.nextElement());
                                                                this.parityARef2.add((String)st.nextElement());
                                                                this.parityARef3.add((String)st.nextElement());
                                                                this.parityARef4.add((String)st.nextElement());
                                                                this.parityAtomsGiven = true;
                                                                continue;
                                                            }
                                                            catch (Exception e) {
                                                                this.logger.error("Error in CML file: ", e.getMessage());
                                                                this.logger.debug(e);
                                                            }
                                                        }
                                                        break block108;
                                                    }
                                                    if (!"bond".equals(name)) break block111;
                                                    ++this.bondCounter;
                                                    for (i = 0; i < atts.getLength(); ++i) {
                                                        att = atts.getQName(i);
                                                        this.logger.debug("B2 ", att, "=", atts.getValue(i));
                                                        if (att.equals("id")) {
                                                            this.bondid.add(atts.getValue(i));
                                                            this.logger.debug("B3 ", this.bondid);
                                                            continue;
                                                        }
                                                        if (att.equals("atomRefs") || att.equals("atomRefs2")) {
                                                            try {
                                                                StringTokenizer st = new StringTokenizer(atts.getValue(i));
                                                                this.bondARef1.add((String)st.nextElement());
                                                                this.bondARef2.add((String)st.nextElement());
                                                            }
                                                            catch (Exception e) {
                                                                this.logger.error("Error in CML file: ", e.getMessage());
                                                                this.logger.debug(e);
                                                            }
                                                            continue;
                                                        }
                                                        if (att.equals("order")) {
                                                            this.order.add(atts.getValue(i).trim());
                                                            continue;
                                                        }
                                                        if (!att.equals("dictRef")) continue;
                                                        this.bondDictRefs.add(atts.getValue(i).trim());
                                                    }
                                                    this.stereoGiven = false;
                                                    this.curRef = 0;
                                                    break block108;
                                                }
                                                if (!"bondArray".equals(name)) break block112;
                                                boolean bondsCounted = false;
                                                for (int i3 = 0; i3 < atts.getLength(); ++i3) {
                                                    String att3 = atts.getQName(i3);
                                                    int count = 0;
                                                    if (att3.equals("bondID")) {
                                                        count = this.addArrayElementsTo(this.bondid, atts.getValue(i3));
                                                    } else if (att3.equals("atomRefs1")) {
                                                        count = this.addArrayElementsTo(this.bondARef1, atts.getValue(i3));
                                                    } else if (att3.equals("atomRefs2")) {
                                                        count = this.addArrayElementsTo(this.bondARef2, atts.getValue(i3));
                                                    } else if (att3.equals("atomRef1")) {
                                                        count = this.addArrayElementsTo(this.bondARef1, atts.getValue(i3));
                                                    } else if (att3.equals("atomRef2")) {
                                                        count = this.addArrayElementsTo(this.bondARef2, atts.getValue(i3));
                                                    } else if (att3.equals("order")) {
                                                        count = this.addArrayElementsTo(this.order, atts.getValue(i3));
                                                    } else {
                                                        this.logger.warn("Unparsed attribute: " + att3);
                                                    }
                                                    if (bondsCounted) continue;
                                                    this.bondCounter += count;
                                                    bondsCounted = true;
                                                }
                                                this.curRef = 0;
                                                break block108;
                                            }
                                            if (!"bondStereo".equals(name)) break block113;
                                            for (i = 0; i < atts.getLength(); ++i) {
                                                String value;
                                                if (!atts.getQName(i).equals("dictRef") || !(value = atts.getValue(i)).startsWith("cml:") || value.length() <= 4) continue;
                                                this.bondStereo.add(value.substring(4));
                                                this.stereoGiven = true;
                                            }
                                            break block108;
                                        }
                                        if (!"bondType".equals(name)) break block114;
                                        for (i = 0; i < atts.getLength(); ++i) {
                                            if (!atts.getQName(i).equals("dictRef") || !atts.getValue(i).equals("cdk:aromaticBond")) continue;
                                            this.bondAromaticity.add(Boolean.TRUE);
                                        }
                                        break block108;
                                    }
                                    if (!"molecule".equals(name)) break block115;
                                    this.newMolecule();
                                    this.BUILTIN = "";
                                    if (this.currentChemModel == null) {
                                        this.currentChemModel = this.currentChemFile.getBuilder().newInstance(IChemModel.class, new Object[0]);
                                    }
                                    if (this.currentMoleculeSet == null) {
                                        this.currentMoleculeSet = this.currentChemFile.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
                                    }
                                    this.currentMolecule = this.currentChemFile.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
                                    for (i = 0; i < atts.getLength(); ++i) {
                                        if (atts.getQName(i).equals("id")) {
                                            this.currentMolecule.setID(atts.getValue(i));
                                            continue;
                                        }
                                        if (!atts.getQName(i).equals("dictRef")) continue;
                                        this.currentMolecule.setProperty(new DictRef(this.DICTREF, atts.getValue(i)), atts.getValue(i));
                                    }
                                    break block108;
                                }
                                if (!"crystal".equals(name)) break block116;
                                this.newCrystalData();
                                this.currentMolecule = this.currentChemFile.getBuilder().newInstance(ICrystal.class, this.currentMolecule);
                                for (i = 0; i < atts.getLength(); ++i) {
                                    att = atts.getQName(i);
                                    if (!att.equals("z")) continue;
                                    ((ICrystal)this.currentMolecule).setZ(Integer.parseInt(atts.getValue(i)));
                                }
                                break block108;
                            }
                            if (!"symmetry".equals(name)) break block117;
                            for (i = 0; i < atts.getLength(); ++i) {
                                att = atts.getQName(i);
                                if (!att.equals("spaceGroup")) continue;
                                ((ICrystal)this.currentMolecule).setSpaceGroup(atts.getValue(i));
                            }
                            break block108;
                        }
                        if (!"identifier".equals(name)) break block118;
                        if (atts.getValue("convention") == null || !atts.getValue("convention").equals("iupac:inchi") || atts.getValue("value") == null) break block108;
                        this.currentMolecule.setProperty("cdk:InChI", atts.getValue("value"));
                        break block108;
                    }
                    if (!"scalar".equals(name)) break block119;
                    if (!xpath.endsWith("crystal", "scalar")) break block108;
                    ++this.crystalScalar;
                    break block108;
                }
                if (!"label".equals(name)) break block120;
                if (!xpath.endsWith("atomType", "label")) break block108;
                this.currentAtom.setAtomTypeName(atts.getValue("value"));
                break block108;
            }
            if ("list".equals(name)) {
                if (this.DICTREF.equals("cdk:model")) {
                    this.currentChemModel = this.currentChemFile.getBuilder().newInstance(IChemModel.class, new Object[0]);
                    for (i = 0; i < atts.getLength(); ++i) {
                        att = atts.getQName(i);
                        if (!att.equals("id")) continue;
                        this.currentChemModel.setID(atts.getValue(i));
                    }
                } else if (this.DICTREF.equals("cdk:moleculeSet")) {
                    this.currentMoleculeSet = this.currentChemFile.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
                    for (i = 0; i < atts.getLength(); ++i) {
                        att = atts.getQName(i);
                        if (!att.equals("id")) continue;
                        this.currentMoleculeSet.setID(atts.getValue(i));
                    }
                    this.currentMolecule = this.currentChemFile.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
                } else {
                    this.currentMoleculeSet = this.currentChemFile.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
                    for (i = 0; i < atts.getLength(); ++i) {
                        att = atts.getQName(i);
                        if (!att.equals("id")) continue;
                        this.currentMoleculeSet.setID(atts.getValue(i));
                    }
                    this.currentMolecule = this.currentChemFile.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
                }
            } else if ("formula".equals(name)) {
                ++this.formulaCounter;
                for (i = 0; i < atts.getLength(); ++i) {
                    att = atts.getQName(i);
                    String value = atts.getValue(i);
                    if (!att.equals("concise")) continue;
                    this.formula.add(value);
                }
            }
        }
    }

    @Override
    public void endElement(CMLStack xpath, String uri, String name, String raw) {
        this.logger.debug("EndElement: ", name);
        String cData = this.currentChars;
        if ("bond".equals(name)) {
            if (!this.stereoGiven) {
                this.bondStereo.add("");
            }
            if (this.bondCounter > this.bondDictRefs.size()) {
                this.bondDictRefs.add(null);
            }
            if (this.bondCounter > this.bondAromaticity.size()) {
                this.bondAromaticity.add(null);
            }
        } else if ("atom".equals(name)) {
            if (this.atomCounter > this.eltitles.size()) {
                this.eltitles.add(null);
            }
            if (this.atomCounter > this.hCounts.size()) {
                this.hCounts.add(null);
            }
            if (this.atomCounter > this.atomDictRefs.size()) {
                this.atomDictRefs.add(null);
            }
            if (this.atomCounter > this.atomAromaticities.size()) {
                this.atomAromaticities.add(null);
            }
            if (this.atomCounter > this.isotope.size()) {
                this.isotope.add(null);
            }
            if (this.atomCounter > this.atomicNumbers.size()) {
                this.atomicNumbers.add(null);
            }
            if (this.atomCounter > this.exactMasses.size()) {
                this.exactMasses.add(null);
            }
            if (this.atomCounter > this.spinMultiplicities.size()) {
                this.spinMultiplicities.add(null);
            }
            if (this.atomCounter > this.occupancies.size()) {
                this.occupancies.add(null);
            }
            if (this.atomCounter > this.formalCharges.size()) {
                this.formalCharges.add("0");
            }
            if (!this.parityGiven) {
                this.atomParities.add("");
            }
            if (!this.parityAtomsGiven) {
                this.parityARef1.add("");
                this.parityARef2.add("");
                this.parityARef3.add("");
                this.parityARef4.add("");
            }
            if (this.atomCounter > this.x2.size() && this.x2.size() != 0) {
                this.x2.add(null);
                this.y2.add(null);
            }
            if (this.atomCounter > this.x3.size() && this.x3.size() != 0) {
                this.x3.add(null);
                this.y3.add(null);
                this.z3.add(null);
            }
            if (this.atomCounter > this.xfract.size() && this.xfract.size() != 0) {
                this.xfract.add(null);
                this.yfract.add(null);
                this.zfract.add(null);
            }
        } else if ("molecule".equals(name)) {
            this.storeData();
            if (this.currentMolecule instanceof ICrystal) {
                this.logger.debug("Adding crystal to chemModel");
                this.currentChemModel.setCrystal((ICrystal)this.currentMolecule);
                this.currentChemSequence.addChemModel(this.currentChemModel);
            } else if (this.currentMolecule instanceof IAtomContainer) {
                this.logger.debug("Adding molecule to set");
                this.currentMoleculeSet.addAtomContainer(this.currentMolecule);
                this.logger.debug("#mols in set: " + this.currentMoleculeSet.getAtomContainerCount());
            }
        } else if ("crystal".equals(name)) {
            if (this.crystalScalar > 0) {
                Vector3d[] axes = CrystalGeometryTools.notionalToCartesian(this.unitcellparams[0], this.unitcellparams[1], this.unitcellparams[2], this.unitcellparams[3], this.unitcellparams[4], this.unitcellparams[5]);
                this.cartesianAxesSet = true;
                ((ICrystal)this.currentMolecule).setA(axes[0]);
                ((ICrystal)this.currentMolecule).setB(axes[1]);
                ((ICrystal)this.currentMolecule).setC(axes[2]);
            } else {
                this.logger.error("Could not find crystal unit cell parameters");
            }
        } else if ("list".equals(name)) {
            if (this.currentChemModel.getMoleculeSet() != this.currentMoleculeSet) {
                this.currentChemModel.setMoleculeSet(this.currentMoleculeSet);
                this.currentChemSequence.addChemModel(this.currentChemModel);
            }
        } else if ("coordinate3".equals(name)) {
            if (this.BUILTIN.equals("xyz3")) {
                this.logger.debug("New coord3 xyz3 found: ", this.currentChars);
                try {
                    StringTokenizer st = new StringTokenizer(this.currentChars);
                    this.x3.add(st.nextToken());
                    this.y3.add(st.nextToken());
                    this.z3.add(st.nextToken());
                    this.logger.debug("coord3 x3.length: ", this.x3.size());
                    this.logger.debug("coord3 y3.length: ", this.y3.size());
                    this.logger.debug("coord3 z3.length: ", this.z3.size());
                }
                catch (Exception exception) {
                    this.logger.error("CMLParsing error while setting coordinate3!");
                    this.logger.debug(exception);
                }
            } else {
                this.logger.warn("Unknown coordinate3 BUILTIN: " + this.BUILTIN);
            }
        } else if ("string".equals(name)) {
            if (this.BUILTIN.equals("elementType")) {
                this.logger.debug("Element: ", cData.trim());
                this.elsym.add(cData);
            } else if (this.BUILTIN.equals("atomRef")) {
                ++this.curRef;
                this.logger.debug("Bond: ref #", this.curRef);
                if (this.curRef == 1) {
                    this.bondARef1.add(cData.trim());
                } else if (this.curRef == 2) {
                    this.bondARef2.add(cData.trim());
                }
            } else if (this.BUILTIN.equals("order")) {
                this.logger.debug("Bond: order ", cData.trim());
                this.order.add(cData.trim());
            } else if (this.BUILTIN.equals("formalCharge")) {
                this.logger.warn("formalCharge BUILTIN accepted but violating CML DTD");
                this.logger.debug("Charge: ", cData.trim());
                String charge = cData.trim();
                if (charge.startsWith("+") && charge.length() > 1) {
                    charge = charge.substring(1);
                }
                this.formalCharges.add(charge);
            }
        } else if ("bondStereo".equals(name)) {
            if (!this.currentChars.isEmpty() && !this.stereoGiven) {
                this.bondStereo.add(this.currentChars);
                this.stereoGiven = Boolean.TRUE;
            }
        } else if ("atomParity".equals(name)) {
            if (!this.currentChars.isEmpty() && !this.parityGiven && this.parityAtomsGiven) {
                this.atomParities.add(this.currentChars);
                this.parityGiven = Boolean.TRUE;
            }
        } else if ("float".equals(name)) {
            if (this.BUILTIN.equals("x3")) {
                this.x3.add(cData.trim());
            } else if (this.BUILTIN.equals("y3")) {
                this.y3.add(cData.trim());
            } else if (this.BUILTIN.equals("z3")) {
                this.z3.add(cData.trim());
            } else if (this.BUILTIN.equals("x2")) {
                this.x2.add(cData.trim());
            } else if (this.BUILTIN.equals("y2")) {
                this.y2.add(cData.trim());
            } else if (this.BUILTIN.equals("order")) {
                this.order.add(cData.trim());
            } else if (this.BUILTIN.equals("charge") || this.BUILTIN.equals("partialCharge")) {
                this.partialCharges.add(cData.trim());
            }
        } else if ("integer".equals(name)) {
            if (this.BUILTIN.equals("formalCharge")) {
                this.formalCharges.add(cData.trim());
            }
        } else if ("coordinate2".equals(name)) {
            if (this.BUILTIN.equals("xy2")) {
                this.logger.debug("New coord2 xy2 found.", cData);
                try {
                    StringTokenizer st = new StringTokenizer(cData);
                    this.x2.add(st.nextToken());
                    this.y2.add(st.nextToken());
                }
                catch (Exception e) {
                    this.notify("CMLParsing error: " + e, "CML-1999-05-15", 175, 1);
                }
            }
        } else if ("stringArray".equals(name)) {
            if (this.BUILTIN.equals("id") || this.BUILTIN.equals("atomId") || this.BUILTIN.equals("atomID")) {
                try {
                    boolean countAtoms = this.atomCounter == 0;
                    StringTokenizer st = new StringTokenizer(cData);
                    while (st.hasMoreTokens()) {
                        if (countAtoms) {
                            ++this.atomCounter;
                        }
                        String token = st.nextToken();
                        this.logger.debug("StringArray (Token): ", token);
                        this.elid.add(token);
                    }
                }
                catch (Exception e) {
                    this.notify("CMLParsing error: " + e, "CML-1999-05-15", 186, 1);
                }
            } else if (this.BUILTIN.equals("elementType")) {
                try {
                    boolean countAtoms = this.atomCounter == 0;
                    StringTokenizer st = new StringTokenizer(cData);
                    while (st.hasMoreTokens()) {
                        if (countAtoms) {
                            ++this.atomCounter;
                        }
                        this.elsym.add(st.nextToken());
                    }
                }
                catch (Exception e) {
                    this.notify("CMLParsing error: " + e, "CML-1999-05-15", 194, 1);
                }
            } else if (this.BUILTIN.equals("atomRefs")) {
                ++this.curRef;
                this.logger.debug("New atomRefs found: ", this.curRef);
                try {
                    boolean countBonds = this.bondCounter == 0;
                    StringTokenizer st = new StringTokenizer(cData);
                    while (st.hasMoreTokens()) {
                        if (countBonds) {
                            ++this.bondCounter;
                        }
                        String token = st.nextToken();
                        this.logger.debug("Token: ", token);
                        if (this.curRef == 1) {
                            this.bondARef1.add(token);
                            continue;
                        }
                        if (this.curRef != 2) continue;
                        this.bondARef2.add(token);
                    }
                }
                catch (Exception e) {
                    this.notify("CMLParsing error: " + e, "CML-1999-05-15", 194, 1);
                }
            } else if (this.BUILTIN.equals("atomRef")) {
                ++this.curRef;
                this.logger.debug("New atomRef found: ", this.curRef);
                try {
                    boolean countBonds = this.bondCounter == 0;
                    StringTokenizer st = new StringTokenizer(cData);
                    while (st.hasMoreTokens()) {
                        if (countBonds) {
                            ++this.bondCounter;
                        }
                        String token = st.nextToken();
                        this.logger.debug("Token: ", token);
                        if (this.curRef == 1) {
                            this.bondARef1.add(token);
                            continue;
                        }
                        if (this.curRef != 2) continue;
                        this.bondARef2.add(token);
                    }
                }
                catch (Exception e) {
                    this.notify("CMLParsing error: " + e, "CML-1999-05-15", 194, 1);
                }
            } else if (this.BUILTIN.equals("order")) {
                this.logger.debug("New bond order found.");
                try {
                    StringTokenizer st = new StringTokenizer(cData);
                    while (st.hasMoreTokens()) {
                        String token = st.nextToken();
                        this.logger.debug("Token: ", token);
                        this.order.add(token);
                    }
                }
                catch (Exception e) {
                    this.notify("CMLParsing error: " + e, "CML-1999-05-15", 194, 1);
                }
            }
        } else if ("integerArray".equals(name)) {
            this.logger.debug("IntegerArray: builtin = ", this.BUILTIN);
            if (this.BUILTIN.equals("formalCharge")) {
                try {
                    StringTokenizer st = new StringTokenizer(cData);
                    while (st.hasMoreTokens()) {
                        String token = st.nextToken();
                        this.logger.debug("Charge added: ", token);
                        this.formalCharges.add(token);
                    }
                }
                catch (Exception e) {
                    this.notify("CMLParsing error: " + e, "CML-1999-05-15", 205, 1);
                }
            }
        } else if ("scalar".equals(name)) {
            if (xpath.endsWith("crystal", "scalar")) {
                this.logger.debug("Going to set a crystal parameter: " + this.crystalScalar, " to ", cData);
                try {
                    this.unitcellparams[this.crystalScalar - 1] = Double.parseDouble(cData.trim());
                }
                catch (NumberFormatException exception) {
                    this.logger.error("Content must a float: " + cData);
                }
            } else if (xpath.endsWith("bond", "scalar")) {
                if (this.DICTREF.equals("mdl:stereo")) {
                    this.bondStereo.add(cData.trim());
                    this.stereoGiven = true;
                } else {
                    Map<String, String> bp = this.bondCustomProperty.get(this.bondid.get(this.bondid.size() - 1));
                    if (bp == null) {
                        bp = new Hashtable<String, String>();
                        this.bondCustomProperty.put(this.bondid.get(this.bondid.size() - 1), bp);
                    }
                    bp.put(this.elementTitle, cData.trim());
                }
            } else if (xpath.endsWith("atom", "scalar")) {
                if (this.DICTREF.equals("cdk:partialCharge")) {
                    this.partialCharges.add(cData.trim());
                } else if (this.DICTREF.equals("cdk:atomicNumber")) {
                    this.atomicNumbers.add(cData.trim());
                } else if (this.DICTREF.equals("cdk:aromaticAtom")) {
                    this.atomAromaticities.add(cData.trim());
                } else if (this.DICTREF.equals("cdk:isotopicMass")) {
                    this.exactMasses.add(cData.trim());
                } else {
                    if (this.atomCustomProperty.get(this.atomCounter - 1) == null) {
                        this.atomCustomProperty.put(this.atomCounter - 1, new ArrayList());
                    }
                    this.atomCustomProperty.get(this.atomCounter - 1).add(this.elementTitle);
                    this.atomCustomProperty.get(this.atomCounter - 1).add(cData.trim());
                }
            } else if (xpath.endsWith("molecule", "scalar")) {
                if (this.DICTREF.equals("pdb:id")) {
                    this.currentMolecule.setProperty(new DictRef(this.DICTREF, cData), cData);
                } else if (this.DICTREF.equals("cdk:molecularProperty")) {
                    this.currentMolecule.setProperty(this.elementTitle, cData);
                } else {
                    this.moleculeCustomProperty.add(this.elementTitle);
                    this.moleculeCustomProperty.add(cData.trim());
                }
            } else if (xpath.endsWith("reaction", "scalar")) {
                if (this.DICTREF.equals("cdk:reactionProperty")) {
                    this.currentReaction.setProperty(this.elementTitle, cData);
                }
            } else {
                this.logger.warn("Ignoring scalar: " + xpath);
            }
        } else if ("floatArray".equals(name)) {
            if (this.BUILTIN.equals("x3")) {
                try {
                    StringTokenizer st = new StringTokenizer(cData);
                    while (st.hasMoreTokens()) {
                        this.x3.add(st.nextToken());
                    }
                }
                catch (Exception e) {
                    this.notify("CMLParsing error: " + e, "CML-1999-05-15", 205, 1);
                }
            } else if (this.BUILTIN.equals("y3")) {
                try {
                    StringTokenizer st = new StringTokenizer(cData);
                    while (st.hasMoreTokens()) {
                        this.y3.add(st.nextToken());
                    }
                }
                catch (Exception e) {
                    this.notify("CMLParsing error: " + e, "CML-1999-05-15", 213, 1);
                }
            } else if (this.BUILTIN.equals("z3")) {
                try {
                    StringTokenizer st = new StringTokenizer(cData);
                    while (st.hasMoreTokens()) {
                        this.z3.add(st.nextToken());
                    }
                }
                catch (Exception e) {
                    this.notify("CMLParsing error: " + e, "CML-1999-05-15", 221, 1);
                }
            } else if (this.BUILTIN.equals("x2")) {
                this.logger.debug("New floatArray found.");
                try {
                    StringTokenizer st = new StringTokenizer(cData);
                    while (st.hasMoreTokens()) {
                        this.x2.add(st.nextToken());
                    }
                }
                catch (Exception e) {
                    this.notify("CMLParsing error: " + e, "CML-1999-05-15", 205, 1);
                }
            } else if (this.BUILTIN.equals("y2")) {
                this.logger.debug("New floatArray found.");
                try {
                    StringTokenizer st = new StringTokenizer(cData);
                    while (st.hasMoreTokens()) {
                        this.y2.add(st.nextToken());
                    }
                }
                catch (Exception e) {
                    this.notify("CMLParsing error: " + e, "CML-1999-05-15", 454, 1);
                }
            } else if (this.BUILTIN.equals("partialCharge")) {
                this.logger.debug("New floatArray with partial charges found.");
                try {
                    StringTokenizer st = new StringTokenizer(cData);
                    while (st.hasMoreTokens()) {
                        this.partialCharges.add(st.nextToken());
                    }
                }
                catch (Exception e) {
                    this.notify("CMLParsing error: " + e, "CML-1999-05-15", 462, 1);
                }
            }
        } else if ("basic".equals(name)) {
            this.inchi = cData;
        } else if ("name".equals(name)) {
            if (xpath.endsWith("molecule", "name")) {
                if (this.DICTREF.length() > 0) {
                    this.currentMolecule.setProperty(new DictRef(this.DICTREF, cData), cData);
                } else {
                    this.currentMolecule.setTitle(cData);
                }
            }
        } else if ("formula".equals(name)) {
            this.currentMolecule.setProperty("cdk:Formula", cData);
        } else {
            this.logger.debug("Skipping end element: " + name);
        }
        this.currentChars = "";
        this.BUILTIN = "";
        this.elementTitle = "";
    }

    @Override
    public void characterData(CMLStack xpath, char[] ch, int start, int length) {
        this.currentChars = this.currentChars + new String(ch, start, length);
        this.logger.debug("CD: ", this.currentChars);
    }

    protected void notify(String message, String systemId, int line, int column) {
        this.logger.debug("Message: ", message);
        this.logger.debug("SystemId: ", systemId);
        this.logger.debug("Line: ", line);
        this.logger.debug("Column: ", column);
    }

    protected void storeData() {
        if (this.inchi != null) {
            this.currentMolecule.setProperty("cdk:InChI", this.inchi);
        }
        if (this.formula != null && this.formula.size() > 0) {
            this.currentMolecule.setProperty("cdk:Formula", this.formula);
        }
        Iterator<String> customs = this.moleculeCustomProperty.iterator();
        while (customs.hasNext()) {
            String x = customs.next();
            String y = customs.next();
            this.currentMolecule.setProperty(x, y);
        }
        this.storeAtomData();
        this.newAtomData();
        this.storeBondData();
        this.newBondData();
        this.convertCMLToCDKHydrogenCounts();
    }

    private void convertCMLToCDKHydrogenCounts() {
        for (IAtom atom : this.currentMolecule.atoms()) {
            int explicitHCount;
            if (atom.getImplicitHydrogenCount() == null || (explicitHCount = AtomContainerManipulator.countExplicitHydrogens(this.currentMolecule, atom)) == 0) continue;
            atom.setImplicitHydrogenCount(atom.getImplicitHydrogenCount() - explicitHCount);
        }
    }

    protected void storeAtomData() {
        int i;
        this.logger.debug("No atoms: ", this.atomCounter);
        if (this.atomCounter == 0) {
            return;
        }
        boolean hasID = false;
        boolean has3D = false;
        boolean has3Dfract = false;
        boolean has2D = false;
        boolean hasFormalCharge = false;
        boolean hasAtomAromaticities = false;
        boolean hasPartialCharge = false;
        boolean hasHCounts = false;
        boolean hasSymbols = false;
        boolean hasTitles = false;
        boolean hasIsotopes = false;
        boolean hasAtomicNumbers = false;
        boolean hasExactMasses = false;
        boolean hasDictRefs = false;
        boolean hasSpinMultiplicities = false;
        boolean hasAtomParities = false;
        boolean hasOccupancies = false;
        if (this.elid.size() == this.atomCounter) {
            hasID = true;
        } else {
            this.logger.debug("No atom ids: " + this.elid.size(), " != " + this.atomCounter);
        }
        if (this.elsym.size() == this.atomCounter) {
            hasSymbols = true;
        } else {
            this.logger.debug("No atom symbols: " + this.elsym.size(), " != " + this.atomCounter);
        }
        if (this.eltitles.size() == this.atomCounter) {
            hasTitles = true;
        } else {
            this.logger.debug("No atom titles: " + this.eltitles.size(), " != " + this.atomCounter);
        }
        if (this.x3.size() == this.atomCounter && this.y3.size() == this.atomCounter && this.z3.size() == this.atomCounter) {
            has3D = true;
        } else {
            this.logger.debug("No 3D info: " + this.x3.size(), " " + this.y3.size(), " " + this.z3.size(), " != " + this.atomCounter);
        }
        if (this.xfract.size() == this.atomCounter && this.yfract.size() == this.atomCounter && this.zfract.size() == this.atomCounter) {
            has3Dfract = true;
        } else {
            this.logger.debug("No 3D fractional info: " + this.xfract.size(), " " + this.yfract.size(), " " + this.zfract.size(), " != " + this.atomCounter);
        }
        if (this.x2.size() == this.atomCounter && this.y2.size() == this.atomCounter) {
            has2D = true;
        } else {
            this.logger.debug("No 2D info: " + this.x2.size(), " " + this.y2.size(), " != " + this.atomCounter);
        }
        if (this.formalCharges.size() == this.atomCounter) {
            hasFormalCharge = true;
        } else {
            this.logger.debug("No formal Charge info: " + this.formalCharges.size(), " != " + this.atomCounter);
        }
        if (this.atomAromaticities.size() == this.atomCounter) {
            hasAtomAromaticities = true;
        } else {
            this.logger.debug("No aromatic atom info: " + this.atomAromaticities.size(), " != " + this.atomCounter);
        }
        if (this.partialCharges.size() == this.atomCounter) {
            hasPartialCharge = true;
        } else {
            this.logger.debug("No partial Charge info: " + this.partialCharges.size(), " != " + this.atomCounter);
        }
        if (this.hCounts.size() == this.atomCounter) {
            hasHCounts = true;
        } else {
            this.logger.debug("No hydrogen Count info: " + this.hCounts.size(), " != " + this.atomCounter);
        }
        if (this.spinMultiplicities.size() == this.atomCounter) {
            hasSpinMultiplicities = true;
        } else {
            this.logger.debug("No spinMultiplicity info: " + this.spinMultiplicities.size(), " != " + this.atomCounter);
        }
        if (this.atomParities.size() == this.atomCounter) {
            hasAtomParities = true;
        } else {
            this.logger.debug("No atomParity info: " + this.spinMultiplicities.size(), " != " + this.atomCounter);
        }
        if (this.occupancies.size() == this.atomCounter) {
            hasOccupancies = true;
        } else {
            this.logger.debug("No occupancy info: " + this.occupancies.size(), " != " + this.atomCounter);
        }
        if (this.atomDictRefs.size() == this.atomCounter) {
            hasDictRefs = true;
        } else {
            this.logger.debug("No dictRef info: " + this.atomDictRefs.size(), " != " + this.atomCounter);
        }
        if (this.isotope.size() == this.atomCounter) {
            hasIsotopes = true;
        } else {
            this.logger.debug("No isotope info: " + this.isotope.size(), " != " + this.atomCounter);
        }
        if (this.atomicNumbers.size() == this.atomCounter) {
            hasAtomicNumbers = true;
        } else {
            this.logger.debug("No atomicNumbers info: " + this.atomicNumbers.size(), " != " + this.atomCounter);
        }
        if (this.exactMasses.size() == this.atomCounter) {
            hasExactMasses = true;
        } else {
            this.logger.debug("No atomicNumbers info: " + this.atomicNumbers.size(), " != " + this.atomCounter);
        }
        for (i = 0; i < this.atomCounter; ++i) {
            String symbol;
            this.logger.info("Storing atom: ", i);
            this.currentAtom = this.currentChemFile.getBuilder().newInstance(IAtom.class, "H");
            this.logger.debug("Atom # " + this.atomCounter);
            if (hasID) {
                this.logger.debug("id: ", this.elid.get(i));
                this.currentAtom.setID(this.elid.get(i));
                this.atomEnumeration.put(this.elid.get(i), this.currentAtom);
            }
            if (hasTitles) {
                if (hasSymbols) {
                    symbol = this.elsym.get(i);
                    if (symbol.equals("Du") || symbol.equals("Dummy")) {
                        if (!(this.currentAtom instanceof IPseudoAtom)) {
                            this.currentAtom = this.currentChemFile.getBuilder().newInstance(IPseudoAtom.class, this.currentAtom);
                            if (hasID) {
                                this.atomEnumeration.put(this.elid.get(i), this.currentAtom);
                            }
                        }
                        ((IPseudoAtom)this.currentAtom).setLabel(this.eltitles.get(i));
                    } else if (this.eltitles.get(i) != null) {
                        this.currentAtom.setProperty("cdk:Title", this.eltitles.get(i));
                    }
                } else if (this.eltitles.get(i) != null) {
                    this.currentAtom.setProperty("cdk:Title", this.eltitles.get(i));
                }
            }
            if (hasSymbols) {
                symbol = this.elsym.get(i);
                if (symbol.equals("Du") || symbol.equals("Dummy")) {
                    symbol = "R";
                }
                if (symbol.equals("R") && !(this.currentAtom instanceof IPseudoAtom)) {
                    this.currentAtom = this.currentChemFile.getBuilder().newInstance(IPseudoAtom.class, this.currentAtom);
                    ((IPseudoAtom)this.currentAtom).setLabel("R");
                    if (hasID) {
                        this.atomEnumeration.put(this.elid.get(i), this.currentAtom);
                    }
                }
                this.currentAtom.setSymbol(symbol);
                if (!hasAtomicNumbers || this.atomicNumbers.get(i) == null) {
                    this.currentAtom.setAtomicNumber(PeriodicTable.getAtomicNumber(symbol));
                }
            }
            if (has3D && this.x3.get(i) != null && this.y3.get(i) != null && this.z3.get(i) != null) {
                this.currentAtom.setPoint3d(new Point3d(Double.parseDouble(this.x3.get(i)), Double.parseDouble(this.y3.get(i)), Double.parseDouble(this.z3.get(i))));
            }
            if (has3Dfract) {
                this.currentAtom.setFractionalPoint3d(new Point3d(Double.parseDouble(this.xfract.get(i)), Double.parseDouble(this.yfract.get(i)), Double.parseDouble(this.zfract.get(i))));
            }
            if (hasFormalCharge) {
                this.currentAtom.setFormalCharge(Integer.parseInt(this.formalCharges.get(i)));
            }
            if (hasAtomAromaticities && this.atomAromaticities.get(i) != null) {
                this.currentAtom.setFlag(32, true);
            }
            if (hasPartialCharge) {
                this.logger.debug("Storing partial atomic charge...");
                this.currentAtom.setCharge(Double.parseDouble(this.partialCharges.get(i)));
            }
            if (hasHCounts) {
                String hCount = this.hCounts.get(i);
                if (hCount != null) {
                    this.currentAtom.setImplicitHydrogenCount(Integer.parseInt(hCount));
                } else {
                    this.currentAtom.setImplicitHydrogenCount((Integer)CDKConstants.UNSET);
                }
            }
            if (has2D && this.x2.get(i) != null && this.y2.get(i) != null) {
                this.currentAtom.setPoint2d(new Point2d(Double.parseDouble(this.x2.get(i)), Double.parseDouble(this.y2.get(i))));
            }
            if (hasDictRefs && this.atomDictRefs.get(i) != null) {
                this.currentAtom.setProperty("org.openscience.cdk.dict", this.atomDictRefs.get(i));
            }
            if (hasSpinMultiplicities && this.spinMultiplicities.get(i) != null) {
                int unpairedElectrons = Integer.parseInt(this.spinMultiplicities.get(i)) - 1;
                for (int sm = 0; sm < unpairedElectrons; ++sm) {
                    this.currentMolecule.addSingleElectron(this.currentChemFile.getBuilder().newInstance(ISingleElectron.class, this.currentAtom));
                }
            }
            if (!hasOccupancies || this.occupancies.get(i) != null) {
                // empty if block
            }
            if (hasIsotopes && this.isotope.get(i) != null) {
                this.currentAtom.setMassNumber((int)Double.parseDouble(this.isotope.get(i)));
            }
            if (hasAtomicNumbers && this.atomicNumbers.get(i) != null) {
                this.currentAtom.setAtomicNumber(Integer.parseInt(this.atomicNumbers.get(i)));
            }
            if (hasExactMasses && this.exactMasses.get(i) != null) {
                this.currentAtom.setExactMass(Double.parseDouble(this.exactMasses.get(i)));
            }
            if (this.atomCustomProperty.get(i) != null) {
                Iterator<String> it = this.atomCustomProperty.get(i).iterator();
                while (it.hasNext()) {
                    this.currentAtom.setProperty(it.next(), it.next());
                }
            }
            this.currentMolecule.addAtom(this.currentAtom);
        }
        for (i = 0; i < this.atomCounter; ++i) {
            ITetrahedralChirality.Stereo config;
            if (!hasAtomParities || this.atomParities.get(i) == null || this.atomParities.get(i).isEmpty()) continue;
            IAtom ligandAtom1 = this.atomEnumeration.get(this.parityARef1.get(i));
            IAtom ligandAtom2 = this.atomEnumeration.get(this.parityARef2.get(i));
            IAtom ligandAtom3 = this.atomEnumeration.get(this.parityARef3.get(i));
            IAtom ligandAtom4 = this.atomEnumeration.get(this.parityARef4.get(i));
            IAtom[] ligandAtoms = new IAtom[]{ligandAtom1, ligandAtom2, ligandAtom3, ligandAtom4};
            int parity = 0;
            try {
                parity = (int)Math.signum(Double.parseDouble(this.atomParities.get(i)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (parity > 0) {
                config = ITetrahedralChirality.Stereo.CLOCKWISE;
            } else if (parity < 0) {
                config = ITetrahedralChirality.Stereo.ANTI_CLOCKWISE;
            } else {
                config = null;
                this.logger.warn("Cannot interpret stereo information, invalid parity: '" + this.atomParities.get(i) + "'");
            }
            if (config == null) continue;
            TetrahedralChirality chirality = new TetrahedralChirality(this.currentMolecule.getAtom(i), ligandAtoms, config);
            this.currentMolecule.addStereoElement(chirality);
        }
        if (this.elid.size() > 0) {
            this.bondElid = this.elid;
        }
    }

    protected void storeBondData() {
        this.logger.debug("Testing a1,a2,stereo,order = count: " + this.bondARef1.size(), "," + this.bondARef2.size(), "," + this.bondStereo.size(), "," + this.order.size(), "=" + this.bondCounter);
        if (this.bondARef1.size() == this.bondCounter && this.bondARef2.size() == this.bondCounter) {
            this.logger.debug("About to add bond info...");
            Iterator<String> orders = this.order.iterator();
            Iterator<String> ids = this.bondid.iterator();
            Iterator<String> bar1s = this.bondARef1.iterator();
            Iterator<String> bar2s = this.bondARef2.iterator();
            Iterator<String> stereos = this.bondStereo.iterator();
            Iterator<Boolean> aroms = this.bondAromaticity.iterator();
            while (bar1s.hasNext()) {
                Map<String, String> currentBondProperties;
                Boolean nextArom;
                IAtom a1 = this.atomEnumeration.get(bar1s.next());
                IAtom a2 = this.atomEnumeration.get(bar2s.next());
                this.currentBond = this.currentChemFile.getBuilder().newInstance(IBond.class, a1, a2);
                if (ids.hasNext()) {
                    this.currentBond.setID(ids.next());
                }
                if (orders.hasNext()) {
                    String bondOrder = orders.next();
                    if ("S".equals(bondOrder)) {
                        this.currentBond.setOrder(IBond.Order.SINGLE);
                    } else if ("D".equals(bondOrder)) {
                        this.currentBond.setOrder(IBond.Order.DOUBLE);
                    } else if ("T".equals(bondOrder)) {
                        this.currentBond.setOrder(IBond.Order.TRIPLE);
                    } else if ("A".equals(bondOrder)) {
                        this.currentBond.setOrder(IBond.Order.SINGLE);
                        this.currentBond.setFlag(32, true);
                    } else {
                        this.currentBond.setOrder(BondManipulator.createBondOrder(Double.parseDouble(bondOrder)));
                    }
                }
                if (stereos.hasNext()) {
                    String nextStereo = stereos.next();
                    if ("H".equals(nextStereo)) {
                        this.currentBond.setStereo(IBond.Stereo.DOWN);
                    } else if ("W".equals(nextStereo)) {
                        this.currentBond.setStereo(IBond.Stereo.UP);
                    } else if (nextStereo != null && !nextStereo.isEmpty()) {
                        this.logger.warn("Cannot interpret bond display information: '" + nextStereo + "'");
                    }
                }
                if (aroms.hasNext() && (nextArom = aroms.next()) != null && nextArom.booleanValue()) {
                    this.currentBond.setFlag(32, true);
                }
                if (this.currentBond.getID() != null && (currentBondProperties = this.bondCustomProperty.get(this.currentBond.getID())) != null) {
                    for (String key : currentBondProperties.keySet()) {
                        this.currentBond.setProperty(key, currentBondProperties.get(key));
                    }
                    this.bondCustomProperty.remove(this.currentBond.getID());
                }
                this.currentMolecule.addBond(this.currentBond);
            }
        }
    }

    protected int addArrayElementsTo(List<String> toAddto, String array) {
        StringTokenizer tokenizer = new StringTokenizer(array);
        int i = 0;
        while (tokenizer.hasMoreElements()) {
            toAddto.add(tokenizer.nextToken());
            ++i;
        }
        return i;
    }
}

