/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.qsar.AbstractMolecularDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleResult;
import org.openscience.cdk.qsar.result.IDescriptorResult;

public class VAdjMaDescriptor
extends AbstractMolecularDescriptor
implements IMolecularDescriptor {
    private static final String[] NAMES = new String[]{"VAdjMat"};

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#vAdjMa", this.getClass().getName(), "The Chemistry Development Kit");
    }

    @Override
    public void setParameters(Object[] params) throws CDKException {
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public String[] getDescriptorNames() {
        return NAMES;
    }

    @Override
    public DescriptorValue calculate(IAtomContainer atomContainer) {
        int n = 0;
        for (IBond bond : atomContainer.bonds()) {
            if (bond.getBegin().getAtomicNumber() == 1 || bond.getEnd().getAtomicNumber() == 1) continue;
            ++n;
        }
        double vadjMa = 0.0;
        if (n > 0) {
            vadjMa += Math.log(n) / Math.log(2.0) + 1.0;
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(vadjMa), this.getDescriptorNames());
    }

    @Override
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleResult(0.0);
    }

    @Override
    public String[] getParameterNames() {
        return null;
    }

    @Override
    public Object getParameterType(String name) {
        return null;
    }
}

