% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autogif.R
\name{autogif}
\alias{autogif}
\title{Make a gif from a TROLL simulation}
\usage{
autogif(
  name = NULL,
  path = NULL,
  variables = c("species", "height_ct", "npp_gpp", "height", "lai"),
  global,
  species,
  climate,
  daily,
  forest = NULL,
  verbose = TRUE,
  overwrite = TRUE,
  thin = NULL
)
}
\arguments{
\item{name}{char. Model name (if NULL timestamp).}

\item{path}{char. Path to save the simulation outputs, the default is null
corresponding to a simulation in memory without saved intermediary files.}

\item{variables}{char. Variables to build as a gif among 'species',
'height_ct', 'npp_gpp', 'height', or 'lai' (see details).}

\item{global}{df. Global parameters.}

\item{species}{df. Species parameters.}

\item{climate}{df. Climate parameters.}

\item{daily}{df. Daily variation parameters.}

\item{forest}{df. TROLL with forest input, if null starts from an empty grid
(default NULL).}

\item{verbose}{bool. Show TROLL outputs in the console.}

\item{overwrite}{bool. Overwrite previous outputs.}

\item{thin}{int. Vector of integers corresponding to the iterations to be
kept to reduce output size, default is NULL and corresponds to no thinning.}
}
\value{
A list of gganimate objects corresponding to chosen outputs.
}
\description{
Make a gif from a TROLL simulation
}
\examples{
\dontrun{
data("TROLLv3_species")
data("TROLLv3_climatedaytime12")
data("TROLLv3_daytimevar")
autogif(
  name = "test", global = generate_parameters(
    cols = 100, rows = 100,
    iterperyear = 12, nbiter = 12 * 100,
    extent_visual = 10
  ),
  species = TROLLv3_species,
  climate = TROLLv3_climatedaytime12,
  daily = TROLLv3_daytimevar,
  verbose = FALSE
)
}

}
